/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.TezEntityDescriptor;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.InputReadyTracker;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezTaskContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;

public class TezInputContextImpl
extends TezTaskContextImpl
implements TezInputContext {
    private final byte[] userPayload;
    private final String sourceVertexName;
    private final EventMetaData sourceInfo;
    private final int inputIndex;
    private final Input input;
    private final InputReadyTracker inputReadyTracker;

    @InterfaceAudience.Private
    public TezInputContextImpl(Configuration conf, int appAttemptNumber, TezUmbilical tezUmbilical, String taskVertexName, String sourceVertexName, TezTaskAttemptID taskAttemptID, TezCounters counters, int inputIndex, byte[] userPayload, RuntimeTask runtimeTask, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv, MemoryDistributor memDist, InputDescriptor inputDescriptor, Input input, InputReadyTracker inputReadyTracker) {
        super(conf, appAttemptNumber, taskVertexName, taskAttemptID, counters, runtimeTask, tezUmbilical, serviceConsumerMetadata, auxServiceEnv, memDist, (TezEntityDescriptor)inputDescriptor);
        this.userPayload = userPayload;
        this.inputIndex = inputIndex;
        this.sourceVertexName = sourceVertexName;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, taskVertexName, sourceVertexName, taskAttemptID);
        this.input = input;
        this.inputReadyTracker = inputReadyTracker;
    }

    public void sendEvents(List<Event> events) {
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event e : events) {
            TezEvent tEvt = new TezEvent(e, this.sourceInfo);
            tezEvents.add(tEvt);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    public byte[] getUserPayload() {
        return this.userPayload;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public String getSourceVertexName() {
        return this.sourceVertexName;
    }

    public void fatalError(Throwable exception, String message) {
        super.signalFatalError(exception, message, this.sourceInfo);
    }

    public void inputIsReady() {
        this.inputReadyTracker.setInputIsReady(this.input);
    }
}

