/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringInterner;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.GroupInputSpec;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;

public class TaskSpec
implements Writable {
    private TezTaskAttemptID taskAttemptId;
    private String vertexName;
    private ProcessorDescriptor processorDescriptor;
    private List<InputSpec> inputSpecList;
    private List<OutputSpec> outputSpecList;
    private List<GroupInputSpec> groupInputSpecList;

    public TaskSpec() {
    }

    public TaskSpec(TezTaskAttemptID taskAttemptID, String vertexName, ProcessorDescriptor processorDescriptor, List<InputSpec> inputSpecList, List<OutputSpec> outputSpecList, List<GroupInputSpec> groupInputSpecList) {
        this.taskAttemptId = taskAttemptID;
        this.vertexName = StringInterner.weakIntern((String)vertexName);
        this.processorDescriptor = processorDescriptor;
        this.inputSpecList = inputSpecList;
        this.outputSpecList = outputSpecList;
        this.groupInputSpecList = groupInputSpecList;
    }

    public String getVertexName() {
        return this.vertexName;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public ProcessorDescriptor getProcessorDescriptor() {
        return this.processorDescriptor;
    }

    public List<InputSpec> getInputs() {
        return this.inputSpecList;
    }

    public List<OutputSpec> getOutputs() {
        return this.outputSpecList;
    }

    public List<GroupInputSpec> getGroupInputs() {
        return this.groupInputSpecList;
    }

    public void write(DataOutput out) throws IOException {
        this.taskAttemptId.write(out);
        out.writeUTF(this.vertexName);
        this.processorDescriptor.write(out);
        out.writeInt(this.inputSpecList.size());
        for (InputSpec inputSpec : this.inputSpecList) {
            inputSpec.write(out);
        }
        out.writeInt(this.outputSpecList.size());
        for (OutputSpec outputSpec : this.outputSpecList) {
            outputSpec.write(out);
        }
        if (this.groupInputSpecList != null && !this.groupInputSpecList.isEmpty()) {
            out.writeBoolean(true);
            out.writeInt(this.groupInputSpecList.size());
            for (GroupInputSpec group : this.groupInputSpecList) {
                group.write(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.taskAttemptId = TezTaskAttemptID.readTezTaskAttemptID((DataInput)in);
        this.vertexName = StringInterner.weakIntern((String)in.readUTF());
        this.processorDescriptor = new ProcessorDescriptor();
        this.processorDescriptor.readFields(in);
        int numInputSpecs = in.readInt();
        this.inputSpecList = new ArrayList<InputSpec>(numInputSpecs);
        for (int i = 0; i < numInputSpecs; ++i) {
            InputSpec inputSpec = new InputSpec();
            inputSpec.readFields(in);
            this.inputSpecList.add(inputSpec);
        }
        int numOutputSpecs = in.readInt();
        this.outputSpecList = new ArrayList<OutputSpec>(numOutputSpecs);
        for (int i = 0; i < numOutputSpecs; ++i) {
            OutputSpec outputSpec = new OutputSpec();
            outputSpec.readFields(in);
            this.outputSpecList.add(outputSpec);
        }
        boolean hasGroupInputs = in.readBoolean();
        if (hasGroupInputs) {
            int numGroups = in.readInt();
            this.groupInputSpecList = Lists.newArrayListWithCapacity((int)numGroups);
            for (int i = 0; i < numGroups; ++i) {
                GroupInputSpec group = new GroupInputSpec();
                group.readFields(in);
                this.groupInputSpecList.add(group);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("VertexName: " + this.vertexName);
        sb.append(", TaskAttemptID:" + this.taskAttemptId);
        sb.append(", processorName=" + this.processorDescriptor.getClassName() + ", inputSpecListSize=" + this.inputSpecList.size() + ", outputSpecListSize=" + this.outputSpecList.size());
        sb.append(", inputSpecList=[");
        for (InputSpec inputSpec : this.inputSpecList) {
            sb.append("{" + inputSpec.toString() + "}, ");
        }
        sb.append("], outputSpecList=[");
        for (OutputSpec outputSpec : this.outputSpecList) {
            sb.append("{" + outputSpec.toString() + "}, ");
        }
        sb.append("]");
        if (this.groupInputSpecList != null && !this.groupInputSpecList.isEmpty()) {
            sb.append(" groupInputSpecList=[");
            for (GroupInputSpec groupInputSpec : this.groupInputSpecList) {
                sb.append("{" + groupInputSpec.toString() + "}, ");
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

