/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.TezTaskContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezUmbilical;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TezTaskContextImpl
implements TezTaskContext {
    private static final AtomicInteger ID_GEN = new AtomicInteger(10000);
    private final Configuration conf;
    protected final String taskVertexName;
    protected final TezTaskAttemptID taskAttemptID;
    private final TezCounters counters;
    private String[] workDirs;
    private String uniqueIdentifier;
    protected final RuntimeTask runtimeTask;
    protected final TezUmbilical tezUmbilical;
    private final Map<String, ByteBuffer> serviceConsumerMetadata;
    private final int appAttemptNumber;
    private final Map<String, String> auxServiceEnv;

    @InterfaceAudience.Private
    public TezTaskContextImpl(Configuration conf, int appAttemptNumber, String taskVertexName, TezTaskAttemptID taskAttemptID, TezCounters counters, RuntimeTask runtimeTask, TezUmbilical tezUmbilical, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv) {
        this.conf = conf;
        this.taskVertexName = taskVertexName;
        this.taskAttemptID = taskAttemptID;
        this.counters = counters;
        this.workDirs = this.conf.getStrings("tez.runtime.local.dirs");
        this.runtimeTask = runtimeTask;
        this.tezUmbilical = tezUmbilical;
        this.serviceConsumerMetadata = serviceConsumerMetadata;
        this.appAttemptNumber = appAttemptNumber;
        this.auxServiceEnv = auxServiceEnv;
        this.uniqueIdentifier = String.format("%s_%05d", taskAttemptID.toString(), this.generateId());
    }

    public ApplicationId getApplicationId() {
        return this.taskAttemptID.getTaskID().getVertexID().getDAGId().getApplicationId();
    }

    public int getTaskIndex() {
        return this.taskAttemptID.getTaskID().getId();
    }

    public int getDAGAttemptNumber() {
        return this.appAttemptNumber;
    }

    public int getTaskAttemptNumber() {
        return this.taskAttemptID.getId();
    }

    public String getDAGName() {
        return this.taskAttemptID.getTaskID().getVertexID().getDAGId().toString();
    }

    public String getTaskVertexName() {
        return this.taskVertexName;
    }

    public TezCounters getCounters() {
        return this.counters;
    }

    public String[] getWorkDirs() {
        return Arrays.copyOf(this.workDirs, this.workDirs.length);
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public ByteBuffer getServiceConsumerMetaData(String serviceName) {
        return (ByteBuffer)this.serviceConsumerMetadata.get(serviceName).asReadOnlyBuffer().rewind();
    }

    public ByteBuffer getServiceProviderMetaData(String serviceName) {
        return AuxiliaryServiceHelper.getServiceDataFromEnv((String)serviceName, this.auxServiceEnv);
    }

    protected void signalFatalError(Throwable t, String message, EventMetaData sourceInfo) {
        this.runtimeTask.setFatalError(t, message);
        String diagnostics = t != null && message != null ? "exceptionThrown=" + StringUtils.stringifyException((Throwable)t) + ", errorMessage=" + message : (t == null && message == null ? "Unknown error" : (t != null ? "exceptionThrown=" + StringUtils.stringifyException((Throwable)t) : " errorMessage=" + message));
        this.tezUmbilical.signalFatalError(this.taskAttemptID, diagnostics, sourceInfo);
    }

    private int generateId() {
        return ID_GEN.incrementAndGet();
    }
}

