/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop.mapred;

import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.mapreduce.common.Utils;

public class MRReporter
implements Reporter {
    private TezCounters tezCounters;
    private InputSplit split;
    private float progress = 0.0f;

    public MRReporter(TezCounters tezCounters) {
        this(tezCounters, null);
    }

    public MRReporter(TezCounters tezCounters, InputSplit split) {
        this.tezCounters = tezCounters;
        this.split = split;
    }

    public void progress() {
    }

    public void setStatus(String status) {
    }

    public Counters.Counter getCounter(Enum<?> name) {
        return Utils.getMRCounter(this.tezCounters.findCounter(name));
    }

    public Counters.Counter getCounter(String group, String name) {
        return Utils.getMRCounter(this.tezCounters.findCounter(group, name));
    }

    public void incrCounter(Enum<?> key, long amount) {
        this.getCounter(key).increment(amount);
    }

    public void incrCounter(String group, String counter, long amount) {
        this.getCounter(group, counter).increment(amount);
    }

    public InputSplit getInputSplit() throws UnsupportedOperationException {
        if (this.split == null) {
            throw new UnsupportedOperationException("Input only available on map");
        }
        return this.split;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public float getProgress() {
        return this.progress;
    }
}

