/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.input.base;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.Reader;

@InterfaceAudience.Private
public abstract class MRInputBase
extends AbstractLogicalInput {
    protected JobConf jobConf;
    protected TezCounter inputRecordCounter;
    @InterfaceAudience.Private
    protected boolean useNewApi;

    public MRInputBase(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    public Reader getReader() throws Exception {
        return null;
    }

    public List<Event> initialize() throws IOException {
        this.getContext().requestInitialMemory(0L, null);
        MRRuntimeProtos.MRInputUserPayloadProto mrUserPayload = MRInputHelpers.parseMRInputPayload(this.getContext().getUserPayload());
        boolean isGrouped = mrUserPayload.getGroupingEnabled();
        Preconditions.checkArgument((!mrUserPayload.hasSplits() ? 1 : 0) != 0, (Object)("Split information not expected in " + ((Object)((Object)this)).getClass().getName()));
        Configuration conf = TezUtils.createConfFromByteString((ByteString)mrUserPayload.getConfigurationBytes());
        this.jobConf = new JobConf(conf);
        this.useNewApi = this.jobConf.getUseNewMapper();
        if (isGrouped) {
            if (this.useNewApi) {
                this.jobConf.set("mapreduce.job.inputformat.class", TezGroupedSplitsInputFormat.class.getName());
            } else {
                this.jobConf.set("mapred.input.format.class", org.apache.hadoop.mapred.split.TezGroupedSplitsInputFormat.class.getName());
            }
        }
        this.jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
        TaskAttemptID taskAttemptId = new TaskAttemptID(new TaskID(Long.toString(this.getContext().getApplicationId().getClusterTimestamp()), this.getContext().getApplicationId().getId(), TaskType.MAP, this.getContext().getTaskIndex()), this.getContext().getTaskAttemptNumber());
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        this.jobConf.setInt("mapreduce.job.application.attempt.id", this.getContext().getDAGAttemptNumber());
        this.inputRecordCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED);
        return null;
    }
}

