/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;

public class MultiStageMRConfigUtil {
    private static final String INITIAL_MAP_VERTEX_NAME = "initialmap";
    private static final String FINAL_REDUCE_VERTEX_NAME = "finalreduce";
    private static final String INTERMEDIATE_TASK_VERTEX_NAME_PREFIX = "ivertex";

    public static Configuration getBasicIntermediateStageConf(Configuration baseConf, int i) {
        return MultiStageMRConfigUtil.getBasicIntermediateStageConfInternal(baseConf, MultiStageMRConfigUtil.getPropertyNameForIntermediateStage(i, ""), false, true);
    }

    public static Configuration getAndRemoveBasicIntermediateStageConf(Configuration baseConf, int i) {
        return MultiStageMRConfigUtil.getBasicIntermediateStageConfInternal(baseConf, MultiStageMRConfigUtil.getPropertyNameForIntermediateStage(i, ""), true, true);
    }

    public static Configuration getIntermediateStageConf(Configuration baseConf, int i) {
        return MultiStageMRConfigUtil.getBasicIntermediateStageConfInternal(baseConf, MultiStageMRConfigUtil.getPropertyNameForIntermediateStage(i, ""), false, false);
    }

    public static Configuration getAndRemoveBasicNonIntermediateStageConf(Configuration baseConf) {
        Configuration newConf = new Configuration(false);
        for (String key : DeprecatedKeys.getMRToTezRuntimeParamMap().keySet()) {
            if (baseConf.get(key) == null) continue;
            newConf.set(key, baseConf.get(key));
            baseConf.unset(key);
        }
        for (String key : DeprecatedKeys.getMultiStageParamMap().keySet()) {
            if (baseConf.get(key) == null) continue;
            newConf.set(key, baseConf.get(key));
            baseConf.unset(key);
        }
        return newConf;
    }

    public static int getNumIntermediateStages(Configuration conf) {
        return conf.getInt("mrr.intermediate.num-stages", 0);
    }

    public static String getPropertyNameForIntermediateStage(int intermediateStage, String originalPropertyName) {
        return "mrr.intermediate.stage." + intermediateStage + "." + originalPropertyName;
    }

    public static String getInitialMapVertexName() {
        return INITIAL_MAP_VERTEX_NAME;
    }

    public boolean isInitialMapVertex(String vertexName) {
        return vertexName.equals(INITIAL_MAP_VERTEX_NAME);
    }

    public static String getFinalReduceVertexName() {
        return FINAL_REDUCE_VERTEX_NAME;
    }

    public boolean isFinalReduceVertex(String vertexName) {
        return vertexName.equals(FINAL_REDUCE_VERTEX_NAME);
    }

    public static String getIntermediateStageVertexName(int stageNum) {
        return INTERMEDIATE_TASK_VERTEX_NAME_PREFIX + stageNum;
    }

    public static int getIntermediateStageNum(String vertexName) {
        if (vertexName.matches("ivertex\\d+")) {
            return Integer.parseInt(vertexName.substring(INTERMEDIATE_TASK_VERTEX_NAME_PREFIX.length()));
        }
        return -1;
    }

    public static Configuration getBasicConfForVertex(Configuration baseConf, String vertexName) {
        return MultiStageMRConfigUtil.getBasicIntermediateStageConfInternal(baseConf, MultiStageMRConfigUtil.getPropertyNameForVertex(vertexName, ""), false, true);
    }

    public static Configuration getAndRemoveBasicConfForVertex(Configuration baseConf, String vertexName) {
        return MultiStageMRConfigUtil.getBasicIntermediateStageConfInternal(baseConf, MultiStageMRConfigUtil.getPropertyNameForVertex(vertexName, ""), true, true);
    }

    public static Configuration getConfForVertex(Configuration baseConf, String vertexName) {
        return MultiStageMRConfigUtil.getBasicIntermediateStageConfInternal(baseConf, MultiStageMRConfigUtil.getPropertyNameForVertex(vertexName, ""), false, false);
    }

    public static void addConfigurationForVertex(Configuration baseConf, String vertexName, Configuration vertexConf) {
        for (Map.Entry entry : vertexConf) {
            baseConf.set(MultiStageMRConfigUtil.getPropertyNameForVertex(vertexName, (String)entry.getKey()), (String)entry.getValue());
        }
    }

    public static String getPropertyNameForVertex(String vertexName, String originalPropertyName) {
        return "mrr.vertex." + vertexName + "." + originalPropertyName;
    }

    public static void printConf(Configuration conf) {
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            System.err.println("Key: " + key + ", Value: " + value);
        }
    }

    @InterfaceAudience.Private
    static Configuration extractStageConf(Configuration baseConf, String prefix) {
        Configuration strippedConf = new Configuration(false);
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : baseConf) {
            String key = (String)entry.getKey();
            if (key.startsWith(prefix)) {
                if (prefix.equals("") && key.startsWith("mrr.intermediate.stage.")) continue;
                String newKey = key.replace(prefix, "");
                strippedConf.set(newKey, (String)entry.getValue());
                continue;
            }
            if (key.startsWith("mrr.intermediate.stage.")) continue;
            conf.set(key, (String)entry.getValue());
        }
        for (Map.Entry entry : strippedConf) {
            if (Configuration.isDeprecated((String)((String)entry.getKey()))) continue;
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return conf;
    }

    private static Configuration getBasicIntermediateStageConfInternal(Configuration baseConf, String prefix, boolean remove, boolean stageOnly) {
        Configuration strippedConf = new Configuration(false);
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : baseConf) {
            String key = (String)entry.getKey();
            if (key.startsWith(prefix)) {
                if (remove) {
                    baseConf.unset(key);
                }
                String newKey = key.replace(prefix, "");
                strippedConf.set(newKey, (String)entry.getValue());
                continue;
            }
            if (stageOnly) continue;
            conf.set(key, (String)entry.getValue());
        }
        if (stageOnly) {
            conf = strippedConf;
        } else {
            for (Map.Entry entry : strippedConf) {
                conf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return conf;
    }
}

