/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.split.TezGroupedSplitsInputFormat;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.mapreduce.combine.MRCombiner;
import org.apache.tez.mapreduce.committer.MROutputCommitter;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoDisk;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.output.MROutputLegacy;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.TezRootInputInitializer;

public class MRHelpers {
    private static final Log LOG = LogFactory.getLog(MRHelpers.class);
    static final int SPLIT_SERIALIZED_LENGTH_ESTIMATE = 40;
    static final String JOB_SPLIT_RESOURCE_NAME = "job.split";
    static final String JOB_SPLIT_METAINFO_RESOURCE_NAME = "job.splitmetainfo";

    @InterfaceAudience.Private
    public static org.apache.hadoop.mapreduce.InputSplit[] generateNewSplits(JobContext jobContext, String inputFormatName, int numTasks) throws ClassNotFoundException, IOException, InterruptedException {
        org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat inputFormat;
        Configuration conf = jobContext.getConfiguration();
        org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat finalInputFormat = inputFormat = (org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat)((Object)ReflectionUtils.newInstance((Class)jobContext.getInputFormatClass(), (Configuration)conf));
        if (inputFormatName != null && !inputFormatName.isEmpty()) {
            if (!((Object)((Object)inputFormat)).getClass().equals(org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat.class)) {
                throw new TezUncheckedException("Expected " + org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat.class.getName() + " in conf but got: " + ((Object)((Object)inputFormat)).getClass().getName());
            }
            try {
                inputFormat = (InputFormat)ReflectionUtils.newInstance(Class.forName(inputFormatName), (Configuration)conf);
            }
            catch (ClassNotFoundException e) {
                throw new TezUncheckedException((Throwable)e);
            }
            org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat groupedFormat = new org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat();
            groupedFormat.setConf(conf);
            groupedFormat.setInputFormat(inputFormat);
            groupedFormat.setDesiredNumberOfSplits(numTasks);
            finalInputFormat = groupedFormat;
        }
        List array = finalInputFormat.getSplits(jobContext);
        org.apache.hadoop.mapreduce.InputSplit[] splits = array.toArray(new org.apache.hadoop.mapreduce.InputSplit[array.size()]);
        Arrays.sort(splits, new InputSplitComparator());
        return splits;
    }

    private static InputSplitInfoDisk writeNewSplits(JobContext jobContext, Path inputSplitDir) throws IOException, InterruptedException, ClassNotFoundException {
        org.apache.hadoop.mapreduce.InputSplit[] splits = MRHelpers.generateNewSplits(jobContext, null, 0);
        Configuration conf = jobContext.getConfiguration();
        JobSplitWriter.createSplitFiles((Path)inputSplitDir, (Configuration)conf, (FileSystem)inputSplitDir.getFileSystem(conf), (org.apache.hadoop.mapreduce.InputSplit[])splits);
        ArrayList<VertexLocationHint.TaskLocationHint> locationHints = new ArrayList<VertexLocationHint.TaskLocationHint>(splits.length);
        for (int i = 0; i < splits.length; ++i) {
            locationHints.add(new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(splits[i].getLocations())), null));
        }
        return new InputSplitInfoDisk(JobSubmissionFiles.getJobSplitFile((Path)inputSplitDir), JobSubmissionFiles.getJobSplitMetaFile((Path)inputSplitDir), splits.length, locationHints, jobContext.getCredentials());
    }

    @InterfaceAudience.Private
    public static InputSplit[] generateOldSplits(JobConf jobConf, String inputFormatName, int numTasks) throws IOException {
        TezGroupedSplitsInputFormat inputFormat;
        TezGroupedSplitsInputFormat finalInputFormat = inputFormat = jobConf.getInputFormat();
        if (inputFormatName != null && !inputFormatName.isEmpty()) {
            if (!inputFormat.getClass().equals(TezGroupedSplitsInputFormat.class)) {
                throw new TezUncheckedException("Expected " + TezGroupedSplitsInputFormat.class.getName() + " in conf but got: " + inputFormat.getClass().getName());
            }
            try {
                inputFormat = (org.apache.hadoop.mapred.InputFormat)ReflectionUtils.newInstance(Class.forName(inputFormatName), (Configuration)jobConf);
            }
            catch (ClassNotFoundException e) {
                throw new TezUncheckedException((Throwable)e);
            }
            TezGroupedSplitsInputFormat groupedFormat = new TezGroupedSplitsInputFormat();
            groupedFormat.setConf((Configuration)jobConf);
            groupedFormat.setInputFormat(inputFormat);
            groupedFormat.setDesiredNumberOfSplits(numTasks);
            finalInputFormat = groupedFormat;
        }
        InputSplit[] splits = finalInputFormat.getSplits(jobConf, jobConf.getNumMapTasks());
        Arrays.sort(splits, new OldInputSplitComparator());
        return splits;
    }

    private static InputSplitInfoDisk writeOldSplits(JobConf jobConf, Path inputSplitDir) throws IOException {
        InputSplit[] splits = MRHelpers.generateOldSplits(jobConf, null, 0);
        JobSplitWriter.createSplitFiles((Path)inputSplitDir, (Configuration)jobConf, (FileSystem)inputSplitDir.getFileSystem((Configuration)jobConf), (InputSplit[])splits);
        ArrayList<VertexLocationHint.TaskLocationHint> locationHints = new ArrayList<VertexLocationHint.TaskLocationHint>(splits.length);
        for (int i = 0; i < splits.length; ++i) {
            locationHints.add(new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(splits[i].getLocations())), null));
        }
        return new InputSplitInfoDisk(JobSubmissionFiles.getJobSplitFile((Path)inputSplitDir), JobSubmissionFiles.getJobSplitMetaFile((Path)inputSplitDir), splits.length, locationHints, jobConf.getCredentials());
    }

    public static InputSplitInfoDisk generateInputSplits(Configuration conf, Path inputSplitsDir) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = Job.getInstance((Configuration)conf);
        JobConf jobConf = new JobConf(conf);
        conf.setBoolean("mapreduce.tez.splits.via.events", false);
        if (jobConf.getUseNewMapper()) {
            LOG.info((Object)("Generating new input splits, splitsDir=" + inputSplitsDir.toString()));
            return MRHelpers.writeNewSplits((JobContext)job, inputSplitsDir);
        }
        LOG.info((Object)("Generating old input splits, splitsDir=" + inputSplitsDir.toString()));
        return MRHelpers.writeOldSplits(jobConf, inputSplitsDir);
    }

    public static InputSplitInfoMem generateInputSplitsToMem(Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        InputSplitInfoMem splitInfoMem = null;
        JobConf jobConf = new JobConf(conf);
        if (jobConf.getUseNewMapper()) {
            LOG.info((Object)"Generating mapreduce api input splits");
            Job job = Job.getInstance((Configuration)conf);
            org.apache.hadoop.mapreduce.InputSplit[] splits = MRHelpers.generateNewSplits((JobContext)job, null, 0);
            splitInfoMem = new InputSplitInfoMem(splits, MRHelpers.createTaskLocationHintsFromSplits(splits), splits.length, job.getCredentials(), job.getConfiguration());
        } else {
            LOG.info((Object)"Generating mapred api input splits");
            InputSplit[] splits = MRHelpers.generateOldSplits(jobConf, null, 0);
            splitInfoMem = new InputSplitInfoMem(splits, MRHelpers.createTaskLocationHintsFromSplits(splits), splits.length, jobConf.getCredentials(), (Configuration)jobConf);
        }
        LOG.info((Object)("NumSplits: " + splitInfoMem.getNumTasks() + ", SerializedSize: " + splitInfoMem.getSplitsProto().getSerializedSize()));
        return splitInfoMem;
    }

    @InterfaceAudience.Private
    public static <T extends org.apache.hadoop.mapreduce.InputSplit> MRRuntimeProtos.MRSplitProto createSplitProto(T newSplit, SerializationFactory serializationFactory) throws IOException, InterruptedException {
        MRRuntimeProtos.MRSplitProto.Builder builder = MRRuntimeProtos.MRSplitProto.newBuilder();
        builder.setSplitClassName(newSplit.getClass().getName());
        Serializer serializer = serializationFactory.getSerializer(newSplit.getClass());
        ByteString.Output out = ByteString.newOutput((int)40);
        serializer.open((OutputStream)out);
        serializer.serialize(newSplit);
        ByteString splitBs = out.toByteString();
        builder.setSplitBytes(splitBs);
        return builder.build();
    }

    @InterfaceAudience.Private
    public static MRRuntimeProtos.MRSplitProto createSplitProto(InputSplit oldSplit) throws IOException {
        MRRuntimeProtos.MRSplitProto.Builder builder = MRRuntimeProtos.MRSplitProto.newBuilder();
        builder.setSplitClassName(oldSplit.getClass().getName());
        ByteString.Output os = ByteString.newOutput((int)40);
        oldSplit.write((DataOutput)new DataOutputStream((OutputStream)os));
        ByteString splitBs = os.toByteString();
        builder.setSplitBytes(splitBs);
        return builder.build();
    }

    private static String getChildLogLevel(Configuration conf, boolean isMap) {
        if (isMap) {
            return conf.get("mapreduce.map.log.level", JobConf.DEFAULT_LOG_LEVEL.toString());
        }
        return conf.get("mapreduce.reduce.log.level", JobConf.DEFAULT_LOG_LEVEL.toString());
    }

    private static String getLog4jCmdLineProperties(Configuration conf, boolean isMap) {
        Vector<String> logProps = new Vector<String>(4);
        MRHelpers.addLog4jSystemProperties(MRHelpers.getChildLogLevel(conf, isMap), logProps);
        StringBuilder sb = new StringBuilder();
        for (String str : logProps) {
            sb.append(str).append(" ");
        }
        return sb.toString();
    }

    public static void addLog4jSystemProperties(String logLevel, List<String> vargs) {
        vargs.add("-Dlog4j.configuration=tez-container-log4j.properties");
        vargs.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        vargs.add("-Dtez.root.logger=" + logLevel + "," + "CLA");
    }

    public static String getMapJavaOpts(Configuration conf) {
        String adminOpts = conf.get("mapreduce.admin.map.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        String userOpts = conf.get("mapreduce.map.java.opts", conf.get("mapred.child.java.opts", "-Xmx200m"));
        return adminOpts.trim() + " " + userOpts.trim() + " " + MRHelpers.getLog4jCmdLineProperties(conf, true);
    }

    public static String getReduceJavaOpts(Configuration conf) {
        String adminOpts = conf.get("mapreduce.admin.reduce.child.java.opts", "-Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN ");
        String userOpts = conf.get("mapreduce.reduce.java.opts", conf.get("mapred.child.java.opts", "-Xmx200m"));
        return adminOpts.trim() + " " + userOpts.trim() + " " + MRHelpers.getLog4jCmdLineProperties(conf, false);
    }

    public static void doJobClientMagic(Configuration conf) throws IOException {
        MRHelpers.setUseNewAPI(conf);
        InetAddress ip = InetAddress.getLocalHost();
        if (ip != null) {
            String submitHostAddress = ip.getHostAddress();
            String submitHostName = ip.getHostName();
            conf.set("mapreduce.job.submithostname", submitHostName);
            conf.set("mapreduce.job.submithostaddress", submitHostAddress);
        }
        conf.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        boolean useNewApi = conf.getBoolean("mapred.mapper.new-api", false);
        if (useNewApi) {
            if (conf.get("mapreduce.job.combine.class") != null) {
                conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
            }
        } else if (conf.get("mapred.combiner.class") != null) {
            conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
        }
        MRHelpers.setWorkingDirectory(conf);
    }

    private static void setWorkingDirectory(Configuration conf) {
        String name = conf.get("mapreduce.job.working.dir");
        if (name == null) {
            try {
                Path dir = FileSystem.get((Configuration)conf).getWorkingDirectory();
                conf.set("mapreduce.job.working.dir", dir.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void setUseNewAPI(Configuration conf) throws IOException {
        String mode;
        int numReduces = conf.getInt("mapreduce.job.reduces", 1);
        String oldMapperClass = "mapred.mapper.class";
        String oldReduceClass = "mapred.reducer.class";
        conf.setBooleanIfUnset("mapred.mapper.new-api", conf.get(oldMapperClass) == null);
        if (conf.getBoolean("mapred.mapper.new-api", false)) {
            mode = "new map API";
            MRHelpers.ensureNotSet(conf, "mapred.input.format.class", mode);
            MRHelpers.ensureNotSet(conf, oldMapperClass, mode);
            if (numReduces != 0) {
                MRHelpers.ensureNotSet(conf, "mapred.partitioner.class", mode);
            } else {
                MRHelpers.ensureNotSet(conf, "mapred.output.format.class", mode);
            }
        } else {
            mode = "map compatability";
            MRHelpers.ensureNotSet(conf, "mapreduce.job.inputformat.class", mode);
            MRHelpers.ensureNotSet(conf, "mapreduce.job.map.class", mode);
            if (numReduces != 0) {
                MRHelpers.ensureNotSet(conf, "mapreduce.job.partitioner.class", mode);
            } else {
                MRHelpers.ensureNotSet(conf, "mapreduce.job.outputformat.class", mode);
            }
        }
        if (numReduces != 0) {
            conf.setBooleanIfUnset("mapred.reducer.new-api", conf.get(oldReduceClass) == null);
            if (conf.getBoolean("mapred.reducer.new-api", false)) {
                mode = "new reduce API";
                MRHelpers.ensureNotSet(conf, "mapred.output.format.class", mode);
                MRHelpers.ensureNotSet(conf, oldReduceClass, mode);
            } else {
                mode = "reduce compatability";
                MRHelpers.ensureNotSet(conf, "mapreduce.job.outputformat.class", mode);
                MRHelpers.ensureNotSet(conf, "mapreduce.job.reduce.class", mode);
            }
        }
    }

    private static void ensureNotSet(Configuration conf, String attr, String msg) throws IOException {
        if (conf.get(attr) != null) {
            throw new IOException(attr + " is incompatible with " + msg + " mode.");
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive, Pig"})
    @InterfaceStability.Unstable
    public static byte[] createUserPayloadFromConf(Configuration conf) throws IOException {
        return TezUtils.createUserPayloadFromConf((Configuration)conf);
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive, Pig"})
    public static ByteString createByteStringFromConf(Configuration conf) throws IOException {
        return TezUtils.createByteStringFromConf((Configuration)conf);
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive, Pig"})
    @InterfaceStability.Unstable
    public static Configuration createConfFromUserPayload(byte[] bb) throws IOException {
        return TezUtils.createConfFromUserPayload((byte[])bb);
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive, Pig"})
    public static Configuration createConfFromByteString(ByteString bs) throws IOException {
        return TezUtils.createConfFromByteString((ByteString)bs);
    }

    public static byte[] createMRInputPayload(byte[] configurationBytes, MRRuntimeProtos.MRSplitsProto mrSplitsProto) throws IOException {
        Preconditions.checkArgument((configurationBytes != null ? 1 : 0) != 0, (Object)"Configuration bytes must be specified");
        return MRHelpers.createMRInputPayload(ByteString.copyFrom((byte[])configurationBytes), mrSplitsProto, null);
    }

    public static byte[] createMRInputPayload(Configuration conf, MRRuntimeProtos.MRSplitsProto mrSplitsProto) throws IOException {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Configuration must be specified");
        return MRHelpers.createMRInputPayload(MRHelpers.createByteStringFromConf(conf), mrSplitsProto, null);
    }

    public static byte[] createMRInputPayloadWithGrouping(byte[] configurationBytes, String inputFormatName) throws IOException {
        Preconditions.checkArgument((configurationBytes != null ? 1 : 0) != 0, (Object)"Configuration bytes must be specified");
        Preconditions.checkArgument((inputFormatName != null ? 1 : 0) != 0, (Object)"InputFormat must be specified");
        return MRHelpers.createMRInputPayload(ByteString.copyFrom((byte[])configurationBytes), null, inputFormatName);
    }

    public static byte[] createMRInputPayloadWithGrouping(Configuration conf, String inputFormatName) throws IOException {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Configuration must be specified");
        Preconditions.checkArgument((inputFormatName != null ? 1 : 0) != 0, (Object)"InputFormat must be specified");
        return MRHelpers.createMRInputPayload(MRHelpers.createByteStringFromConf(conf), null, inputFormatName);
    }

    private static byte[] createMRInputPayload(ByteString bytes, MRRuntimeProtos.MRSplitsProto mrSplitsProto, String inputFormatName) throws IOException {
        MRRuntimeProtos.MRInputUserPayloadProto.Builder userPayloadBuilder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        userPayloadBuilder.setConfigurationBytes(bytes);
        if (mrSplitsProto != null) {
            userPayloadBuilder.setSplits(mrSplitsProto);
        }
        if (inputFormatName != null) {
            userPayloadBuilder.setInputFormatName(inputFormatName);
        }
        return userPayloadBuilder.build().toByteArray();
    }

    public static MRRuntimeProtos.MRInputUserPayloadProto parseMRInputPayload(byte[] bytes) throws IOException {
        return MRRuntimeProtos.MRInputUserPayloadProto.parseFrom(bytes);
    }

    public static void updateLocalResourcesForInputSplits(FileSystem fs, InputSplitInfo inputSplitInfo, Map<String, LocalResource> localResources) throws IOException {
        if (localResources.containsKey(JOB_SPLIT_RESOURCE_NAME)) {
            throw new RuntimeException("LocalResources already contains a resource named job.split");
        }
        if (localResources.containsKey(JOB_SPLIT_METAINFO_RESOURCE_NAME)) {
            throw new RuntimeException("LocalResources already contains a resource named job.splitmetainfo");
        }
        FileStatus splitFileStatus = fs.getFileStatus(inputSplitInfo.getSplitsFile());
        FileStatus metaInfoFileStatus = fs.getFileStatus(inputSplitInfo.getSplitsMetaInfoFile());
        localResources.put(JOB_SPLIT_RESOURCE_NAME, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)inputSplitInfo.getSplitsFile()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)splitFileStatus.getLen(), (long)splitFileStatus.getModificationTime()));
        localResources.put(JOB_SPLIT_METAINFO_RESOURCE_NAME, LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)inputSplitInfo.getSplitsMetaInfoFile()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)metaInfoFileStatus.getLen(), (long)metaInfoFileStatus.getModificationTime()));
    }

    public static Resource getMapResource(Configuration conf) {
        return Resource.newInstance((int)conf.getInt("mapreduce.map.memory.mb", 1024), (int)conf.getInt("mapreduce.map.cpu.vcores", 1));
    }

    public static Resource getReduceResource(Configuration conf) {
        return Resource.newInstance((int)conf.getInt("mapreduce.reduce.memory.mb", 1024), (int)conf.getInt("mapreduce.reduce.cpu.vcores", 1));
    }

    public static void updateEnvironmentForMRTasks(Configuration conf, Map<String, String> environment, boolean isMap) {
        environment.put(ApplicationConstants.Environment.SHELL.name(), conf.get("mapreduce.admin.user.shell", "/bin/bash"));
        Apps.addToEnvironment(environment, (String)ApplicationConstants.Environment.LD_LIBRARY_PATH.name(), (String)ApplicationConstants.Environment.PWD.$());
        Apps.setEnvFromInputString(environment, (String)conf.get("mapreduce.admin.user.env", "LD_LIBRARY_PATH=$HADOOP_COMMON_HOME/lib/native"));
        String mapredChildEnv = isMap ? conf.get("mapreduce.map.env", "") : conf.get("mapreduce.reduce.env", "");
        Apps.setEnvFromInputString(environment, (String)mapredChildEnv);
        environment.put("HADOOP_ROOT_LOGGER", MRHelpers.getChildLogLevel(conf, isMap) + ",CLA");
    }

    private static Configuration getBaseJobConf(Configuration conf) {
        if (conf != null) {
            return new JobConf(conf);
        }
        return new JobConf();
    }

    public static Configuration getBaseMRConfiguration(Configuration conf) {
        return MRHelpers.getBaseJobConf(conf);
    }

    public static Configuration getBaseMRConfiguration() {
        return MRHelpers.getBaseJobConf(null);
    }

    public static void updateEnvironmentForMRAM(Configuration conf, Map<String, String> environment) {
        MRApps.setEnvFromInputString(environment, (String)conf.get("yarn.app.mapreduce.am.admin.user.env"));
        MRApps.setEnvFromInputString(environment, (String)conf.get("yarn.app.mapreduce.am.env"));
    }

    public static String getMRAMJavaOpts(Configuration conf) {
        String mrAppMasterAdminOptions = conf.get("yarn.app.mapreduce.am.admin-command-opts", "");
        String mrAppMasterUserOptions = conf.get("yarn.app.mapreduce.am.command-opts", "-Xmx1024m");
        return mrAppMasterAdminOptions.trim() + " " + mrAppMasterUserOptions.trim();
    }

    public static void addMRInput(Vertex vertex, byte[] userPayload, Class<? extends TezRootInputInitializer> initClazz) {
        InputDescriptor id = new InputDescriptor(MRInputLegacy.class.getName()).setUserPayload(userPayload);
        vertex.addInput("MRInput", id, initClazz);
    }

    public static void addMROutput(Vertex vertex, byte[] userPayload) {
        OutputDescriptor od = new OutputDescriptor(MROutput.class.getName()).setUserPayload(userPayload);
        vertex.addOutput("MROutput", od, MROutputCommitter.class);
    }

    @InterfaceAudience.Private
    public static void addMROutputLegacy(Vertex vertex, byte[] userPayload) {
        OutputDescriptor od = new OutputDescriptor(MROutputLegacy.class.getName()).setUserPayload(userPayload);
        vertex.addOutput("MROutput", od, MROutputCommitter.class);
    }

    public static InputSplit createOldFormatSplitFromUserPayload(MRRuntimeProtos.MRSplitProto splitProto, SerializationFactory serializationFactory) throws IOException {
        Class<?> clazz;
        Preconditions.checkNotNull((Object)splitProto, (Object)"splitProto cannot be null");
        String className = splitProto.getSplitClassName();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to load InputSplit class: [" + className + "]", e);
        }
        Deserializer deserializer = serializationFactory.getDeserializer(clazz);
        deserializer.open(splitProto.getSplitBytes().newInput());
        InputSplit inputSplit = (InputSplit)deserializer.deserialize(null);
        deserializer.close();
        return inputSplit;
    }

    public static org.apache.hadoop.mapreduce.InputSplit createNewFormatSplitFromUserPayload(MRRuntimeProtos.MRSplitProto splitProto, SerializationFactory serializationFactory) throws IOException {
        Class<?> clazz;
        Preconditions.checkNotNull((Object)splitProto, (Object)"splitProto must be specified");
        String className = splitProto.getSplitClassName();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to load InputSplit class: [" + className + "]", e);
        }
        Deserializer deserializer = serializationFactory.getDeserializer(clazz);
        deserializer.open(splitProto.getSplitBytes().newInput());
        org.apache.hadoop.mapreduce.InputSplit inputSplit = (org.apache.hadoop.mapreduce.InputSplit)deserializer.deserialize(null);
        deserializer.close();
        return inputSplit;
    }

    private static List<VertexLocationHint.TaskLocationHint> createTaskLocationHintsFromSplits(org.apache.hadoop.mapreduce.InputSplit[] newFormatSplits) {
        Iterable iterable = Iterables.transform(Arrays.asList(newFormatSplits), (Function)new Function<org.apache.hadoop.mapreduce.InputSplit, VertexLocationHint.TaskLocationHint>(){

            public VertexLocationHint.TaskLocationHint apply(org.apache.hadoop.mapreduce.InputSplit input) {
                try {
                    return new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(input.getLocations())), null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return Lists.newArrayList((Iterable)iterable);
    }

    private static List<VertexLocationHint.TaskLocationHint> createTaskLocationHintsFromSplits(InputSplit[] oldFormatSplits) {
        Iterable iterable = Iterables.transform(Arrays.asList(oldFormatSplits), (Function)new Function<InputSplit, VertexLocationHint.TaskLocationHint>(){

            public VertexLocationHint.TaskLocationHint apply(InputSplit input) {
                try {
                    return new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(input.getLocations())), null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return Lists.newArrayList((Iterable)iterable);
    }

    private static class OldInputSplitComparator
    implements Comparator<InputSplit> {
        private OldInputSplitComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("Problem getting input split size", ie);
            }
        }
    }

    private static class InputSplitComparator
    implements Comparator<org.apache.hadoop.mapreduce.InputSplit> {
        private InputSplitComparator() {
        }

        @Override
        public int compare(org.apache.hadoop.mapreduce.InputSplit o1, org.apache.hadoop.mapreduce.InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("exception in InputSplit compare", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("exception in InputSplit compare", ie);
            }
        }
    }
}

