/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.split.TezGroupedSplit;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.TezRootInputInitializer;
import org.apache.tez.runtime.api.TezRootInputInitializerContext;
import org.apache.tez.runtime.api.events.RootInputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;

public class MRInputAMSplitGenerator
implements TezRootInputInitializer {
    private boolean sendSerializedEvents;
    private static final Log LOG = LogFactory.getLog(MRInputAMSplitGenerator.class);

    /*
     * WARNING - void declaration
     */
    public List<Event> initialize(TezRootInputInitializerContext rootInputContext) throws Exception {
        Stopwatch sw = null;
        if (LOG.isDebugEnabled()) {
            sw = new Stopwatch().start();
        }
        MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto = MRHelpers.parseMRInputPayload(rootInputContext.getUserPayload());
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time to parse MRInput payload into prot: " + sw.elapsedMillis()));
        }
        if (LOG.isDebugEnabled()) {
            sw.reset().start();
        }
        Configuration conf = MRHelpers.createConfFromByteString(userPayloadProto.getConfigurationBytes());
        this.sendSerializedEvents = conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
        LOG.info((Object)("Emitting serialized splits: " + this.sendSerializedEvents));
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time converting ByteString to configuration: " + sw.elapsedMillis()));
        }
        if (LOG.isDebugEnabled()) {
            sw.reset().start();
        }
        int totalResource = rootInputContext.getTotalAvailableResource().getMemory();
        int taskResource = rootInputContext.getVertexTaskResource().getMemory();
        float waves = conf.getFloat("tez.am.grouping.split-waves", TezConfiguration.TEZ_AM_GROUPING_SPLIT_WAVES_DEFAULT);
        int numTasks = (int)((float)totalResource * waves / (float)taskResource);
        LOG.info((Object)("Input " + rootInputContext.getInputName() + " asking for " + numTasks + " tasks. Headroom: " + totalResource + " Task Resource: " + taskResource + " waves: " + waves));
        InputSplitInfoMem inputSplitInfo = null;
        String realInputFormatName = userPayloadProto.getInputFormatName();
        if (realInputFormatName != null && !realInputFormatName.isEmpty()) {
            JobConf jobConf = new JobConf(conf);
            if (jobConf.getUseNewMapper()) {
                void var17_24;
                LOG.info((Object)"Grouping mapreduce api input splits");
                Job job = Job.getInstance((Configuration)conf);
                InputSplit[] splits = MRHelpers.generateNewSplits((JobContext)job, realInputFormatName, numTasks);
                ArrayList locationHints = Lists.newArrayListWithCapacity((int)splits.length);
                InputSplit[] arr$ = splits;
                int len$ = arr$.length;
                boolean bl = false;
                while (var17_24 < len$) {
                    InputSplit split = arr$[var17_24];
                    String rack = ((TezGroupedSplit)split).getRack();
                    if (rack == null) {
                        if (split.getLocations() != null) {
                            locationHints.add(new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(split.getLocations())), null));
                        } else {
                            locationHints.add(new VertexLocationHint.TaskLocationHint(null, null));
                        }
                    } else {
                        locationHints.add(new VertexLocationHint.TaskLocationHint(null, Collections.singleton(rack)));
                    }
                    ++var17_24;
                }
                inputSplitInfo = new InputSplitInfoMem(splits, (List<VertexLocationHint.TaskLocationHint>)locationHints, splits.length, null, conf);
            } else {
                LOG.info((Object)"Grouping mapred api input splits");
                org.apache.hadoop.mapred.InputSplit[] splits = MRHelpers.generateOldSplits(jobConf, realInputFormatName, numTasks);
                ArrayList locationHints = Lists.newArrayListWithCapacity((int)splits.length);
                for (org.apache.hadoop.mapred.InputSplit inputSplit : splits) {
                    String rack = ((org.apache.hadoop.mapred.split.TezGroupedSplit)inputSplit).getRack();
                    if (rack == null) {
                        if (inputSplit.getLocations() != null) {
                            locationHints.add(new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(inputSplit.getLocations())), null));
                            continue;
                        }
                        locationHints.add(new VertexLocationHint.TaskLocationHint(null, null));
                        continue;
                    }
                    locationHints.add(new VertexLocationHint.TaskLocationHint(null, Collections.singleton(rack)));
                }
                inputSplitInfo = new InputSplitInfoMem(splits, (List<VertexLocationHint.TaskLocationHint>)locationHints, splits.length, null, conf);
            }
        } else {
            inputSplitInfo = MRHelpers.generateInputSplitsToMem(conf);
        }
        if (LOG.isDebugEnabled()) {
            sw.stop();
            LOG.debug((Object)("Time to create splits to mem: " + sw.elapsedMillis()));
        }
        ArrayList events = Lists.newArrayListWithCapacity((int)(inputSplitInfo.getNumTasks() + 1));
        RootInputConfigureVertexTasksEvent configureVertexEvent = new RootInputConfigureVertexTasksEvent(inputSplitInfo.getNumTasks(), inputSplitInfo.getTaskLocationHints());
        events.add(configureVertexEvent);
        if (this.sendSerializedEvents) {
            MRRuntimeProtos.MRSplitsProto splitsProto = inputSplitInfo.getSplitsProto();
            int count = 0;
            for (MRRuntimeProtos.MRSplitProto mrSplit : splitsProto.getSplitsList()) {
                RootInputDataInformationEvent rootInputDataInformationEvent = new RootInputDataInformationEvent(count++, mrSplit.toByteArray());
                events.add(rootInputDataInformationEvent);
            }
        } else {
            RootInputDataInformationEvent diEvent;
            int count = 0;
            if (inputSplitInfo.holdsNewFormatSplits()) {
                for (org.apache.hadoop.mapred.InputSplit inputSplit : inputSplitInfo.getNewFormatSplits()) {
                    diEvent = new RootInputDataInformationEvent(count++, (Object)inputSplit);
                    events.add(diEvent);
                }
            } else {
                for (org.apache.hadoop.mapred.InputSplit inputSplit : inputSplitInfo.getOldFormatSplits()) {
                    diEvent = new RootInputDataInformationEvent(count++, (Object)inputSplit);
                    events.add(diEvent);
                }
            }
        }
        return events;
    }
}

