/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor;

import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.task.ReduceContextImpl;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.apache.tez.common.TezTaskStatus;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;
import org.apache.tez.mapreduce.hadoop.IDConverter;
import org.apache.tez.mapreduce.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.tez.mapreduce.hadoop.mapreduce.JobContextImpl;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.FileSystemStatisticUpdater;
import org.apache.tez.mapreduce.processor.GcTimeUpdater;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.library.common.security.TokenCache;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MRTask {
    static final Log LOG = LogFactory.getLog(MRTask.class);
    protected JobConf jobConf;
    protected JobContext jobContext;
    protected org.apache.hadoop.mapred.TaskAttemptContext taskAttemptContext;
    protected OutputCommitter committer;
    transient TezCounters counters;
    protected GcTimeUpdater gcUpdater;
    private ResourceCalculatorProcessTree pTree;
    private long initCpuCumulativeTime = 0L;
    protected TezProcessorContext processorContext;
    protected TaskAttemptID taskAttemptId;
    protected Progress progress = new Progress();
    protected SecretKey jobTokenSecret;
    boolean isMap;
    AtomicBoolean taskDone = new AtomicBoolean(false);
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    protected MRTaskReporter mrReporter;
    protected boolean useNewApi;
    private Map<String, FileSystemStatisticUpdater> statisticUpdaters = new HashMap<String, FileSystemStatisticUpdater>();

    public MRTask(boolean isMap) {
        this.isMap = isMap;
    }

    public void initialize(TezProcessorContext context) throws IOException, InterruptedException {
        DeprecatedKeys.init();
        this.processorContext = context;
        this.counters = context.getCounters();
        this.taskAttemptId = new TaskAttemptID(new TaskID(Long.toString(context.getApplicationId().getClusterTimestamp()), context.getApplicationId().getId(), this.isMap ? TaskType.MAP : TaskType.REDUCE, context.getTaskIndex()), context.getTaskAttemptNumber());
        this.gcUpdater = new GcTimeUpdater(this.counters);
        byte[] userPayload = context.getUserPayload();
        Configuration conf = TezUtils.createConfFromUserPayload((byte[])userPayload);
        this.jobConf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        this.jobConf.set("tez.runtime.task.attempt.id", this.taskAttemptId.toString());
        this.jobConf.set("mapreduce.task.attempt.id", this.taskAttemptId.toString());
        this.jobConf.setInt("mapreduce.job.application.attempt.id", context.getDAGAttemptNumber());
        this.initResourceCalculatorPlugin();
        LOG.info((Object)("MRTask.inited: taskAttemptId = " + this.taskAttemptId.toString()));
        this.jobConf.set("mapreduce.task.vertex.name", this.processorContext.getTaskVertexName());
        if (LOG.isDebugEnabled() && userPayload != null) {
            Iterator iter = this.jobConf.iterator();
            String taskIdStr = this.taskAttemptId.getTaskID().toString();
            while (iter.hasNext()) {
                Map.Entry confEntry = (Map.Entry)iter.next();
                LOG.debug((Object)("TaskConf Entry, taskId=" + taskIdStr + ", key=" + (String)confEntry.getKey() + ", value=" + (String)confEntry.getValue()));
            }
        }
        this.configureMRTask();
    }

    private void configureMRTask() throws IOException, InterruptedException {
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        this.jobConf.setCredentials(credentials);
        Token jobToken = TokenCache.getJobToken((Credentials)credentials);
        if (jobToken != null) {
            SecretKey sk;
            this.jobTokenSecret = sk = JobTokenSecretManager.createSecretKey((byte[])jobToken.getPassword());
        } else {
            LOG.warn((Object)"No job token set");
        }
        this.configureLocalDirs();
        if (this.jobConf.get("tez.dag.credentials.binary") != null) {
            this.jobConf.set("mapreduce.job.credentials.binary", this.jobConf.get("tez.dag.credentials.binary"));
        }
        MRTask.setupDistributedCacheConfig(this.jobConf);
    }

    private void configureLocalDirs() throws IOException {
        this.jobConf.setStrings("tez.runtime.local.dirs", this.processorContext.getWorkDirs());
        this.jobConf.set("tez.runtime.task-local-resource.dir", System.getenv(ApplicationConstants.Environment.PWD.name()));
        this.jobConf.setStrings("mapreduce.cluster.local.dir", this.processorContext.getWorkDirs());
        LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.runtime.local.dirs");
        Path workDir = null;
        try {
            workDir = lDirAlloc.getLocalPathToRead("work", (Configuration)this.jobConf);
        }
        catch (DiskChecker.DiskErrorException e) {
            // empty catch block
        }
        if (workDir == null) {
            workDir = lDirAlloc.getLocalPathForWrite("work", (Configuration)this.jobConf);
            FileSystem lfs = FileSystem.getLocal((Configuration)this.jobConf).getRaw();
            boolean madeDir = false;
            try {
                madeDir = lfs.mkdirs(workDir);
            }
            catch (FileAlreadyExistsException e) {
                madeDir = true;
                workDir = lDirAlloc.getLocalPathToRead("work", (Configuration)this.jobConf);
            }
            if (!madeDir) {
                throw new IOException("Mkdirs failed to create " + workDir.toString());
            }
        }
        this.jobConf.set("tez.runtime.job.local.dir", workDir.toString());
        this.jobConf.set("mapreduce.job.local.dir", workDir.toString());
    }

    private static void setupDistributedCacheConfig(JobConf job) throws IOException {
        URI[] cacheFiles;
        String localWorkDir = job.get("tez.runtime.task-local-resource.dir");
        URI[] cacheArchives = DistributedCache.getCacheArchives((Configuration)job);
        if (cacheArchives != null) {
            ArrayList<String> localArchives = new ArrayList<String>();
            for (int i = 0; i < cacheArchives.length; ++i) {
                URI u = cacheArchives[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localArchives.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localArchives.isEmpty()) {
                job.set("mapreduce.job.cache.local.archives", StringUtils.arrayToString((String[])localArchives.toArray(new String[localArchives.size()])));
            }
        }
        if ((cacheFiles = DistributedCache.getCacheFiles((Configuration)job)) != null) {
            ArrayList<String> localFiles = new ArrayList<String>();
            for (int i = 0; i < cacheFiles.length; ++i) {
                URI u = cacheFiles[i];
                Path p = new Path(u);
                Path name = new Path(null == u.getFragment() ? p.getName() : u.getFragment());
                String linkName = name.toUri().getPath();
                localFiles.add(new Path(localWorkDir, linkName).toUri().getPath());
            }
            if (!localFiles.isEmpty()) {
                job.set("mapreduce.job.cache.local.files", StringUtils.arrayToString((String[])localFiles.toArray(new String[localFiles.size()])));
            }
        }
    }

    private void initResourceCalculatorPlugin() {
        Class clazz = this.jobConf.getClass("mapreduce.job.process-tree.class", null, ResourceCalculatorProcessTree.class);
        this.pTree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)System.getenv().get("JVM_PID"), (Class)clazz, (Configuration)this.jobConf);
        LOG.info((Object)(" Using ResourceCalculatorProcessTree : " + this.pTree));
        if (this.pTree != null) {
            this.pTree.updateProcessTree();
            this.initCpuCumulativeTime = this.pTree.getCumulativeCpuTime();
        }
    }

    public TezProcessorContext getUmbilical() {
        return this.processorContext;
    }

    public void initTask() throws IOException, InterruptedException {
        this.mrReporter = new MRTaskReporter(this.processorContext);
        this.useNewApi = this.jobConf.getUseNewMapper();
        TezDAGID dagId = IDConverter.fromMRTaskAttemptId((org.apache.hadoop.mapreduce.TaskAttemptID)this.taskAttemptId).getTaskID().getVertexID().getDAGId();
        this.jobContext = new JobContextImpl((Configuration)this.jobConf, dagId, (Progressable)this.mrReporter);
        this.taskAttemptContext = new TaskAttemptContextImpl(this.jobConf, this.taskAttemptId, this.mrReporter);
        if (this.getState() == TezTaskStatus.State.UNASSIGNED) {
            this.setState(TezTaskStatus.State.RUNNING);
        }
        this.localizeConfiguration(this.jobConf);
    }

    public MRTaskReporter getMRReporter() {
        return this.mrReporter;
    }

    public void setState(TezTaskStatus.State state) {
    }

    public TezTaskStatus.State getState() {
        return null;
    }

    public OutputCommitter getCommitter() {
        return this.committer;
    }

    public void setCommitter(OutputCommitter committer) {
        this.committer = committer;
    }

    public TezCounters getCounters() {
        return this.counters;
    }

    public void setConf(JobConf jobConf) {
        this.jobConf = jobConf;
    }

    public JobConf getConf() {
        return this.jobConf;
    }

    @InterfaceAudience.Private
    public static List<FileSystem.Statistics> getFsStatistics(Path path, Configuration conf) throws IOException {
        ArrayList<FileSystem.Statistics> matchedStats = new ArrayList<FileSystem.Statistics>();
        path = path.getFileSystem(conf).makeQualified(path);
        String scheme = path.toUri().getScheme();
        for (FileSystem.Statistics stats : FileSystem.getAllStatistics()) {
            if (!stats.getScheme().equals(scheme)) continue;
            matchedStats.add(stats);
        }
        return matchedStats;
    }

    @InterfaceAudience.Private
    public synchronized String getOutputName() {
        return "part-" + NUMBER_FORMAT.format(this.taskAttemptId.getTaskID().getId());
    }

    public void waitBeforeCompletion(MRTaskReporter reporter) throws IOException, InterruptedException {
    }

    public void done(LogicalOutput output) throws IOException, InterruptedException {
        MROutput sOut;
        this.updateCounters();
        LOG.info((Object)("Task:" + this.taskAttemptId + " is done." + " And is in the process of committing"));
        if (output instanceof MROutput && (sOut = (MROutput)output).isCommitRequired()) {
            this.commit(sOut);
        }
        this.taskDone.set(true);
        this.updateCounters();
        this.sendLastUpdate();
    }

    public void statusUpdate() throws IOException, InterruptedException {
    }

    private void sendLastUpdate() throws IOException, InterruptedException {
        this.statusUpdate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commit(MROutput output) throws IOException {
        int retries = 3;
        while (true) {
            try {
                while (!this.processorContext.canCommit()) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ie) {
                continue;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failure sending canCommit: " + StringUtils.stringifyException((Throwable)ie)));
                if (--retries == 0) throw ie;
                continue;
            }
            break;
        }
        try {
            LOG.info((Object)("Task " + this.taskAttemptId + " is allowed to commit now"));
            output.commit();
            return;
        }
        catch (IOException iee) {
            LOG.warn((Object)("Failure committing: " + StringUtils.stringifyException((Throwable)iee)));
            this.discardOutput(output);
            throw iee;
        }
    }

    private void discardOutput(MROutput output) {
        try {
            output.abort();
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Failure cleaning up: " + StringUtils.stringifyException((Throwable)ioe)));
        }
    }

    public void updateCounters() {
        HashMap map = new HashMap();
        for (FileSystem.Statistics statistics : FileSystem.getAllStatistics()) {
            List<FileSystem.Statistics> list;
            String uriScheme = statistics.getScheme();
            if (map.containsKey(uriScheme)) {
                list = (List)map.get(uriScheme);
                list.add(statistics);
                continue;
            }
            list = new ArrayList();
            list.add(statistics);
            map.put(uriScheme, list);
        }
        for (Map.Entry entry : map.entrySet()) {
            FileSystemStatisticUpdater updater = this.statisticUpdaters.get(entry.getKey());
            if (updater == null) {
                updater = new FileSystemStatisticUpdater(this.counters, (List)entry.getValue(), (String)entry.getKey());
                this.statisticUpdaters.put((String)entry.getKey(), updater);
            }
            updater.updateCounters();
        }
        this.gcUpdater.incrementGcCounter();
        this.updateResourceCounters();
    }

    private void updateHeapUsageCounter() {
        long currentHeapUsage = Runtime.getRuntime().totalMemory();
        this.counters.findCounter((Enum)TaskCounter.COMMITTED_HEAP_BYTES).setValue(currentHeapUsage);
    }

    void updateResourceCounters() {
        this.updateHeapUsageCounter();
        if (this.pTree == null) {
            return;
        }
        this.pTree.updateProcessTree();
        long cpuTime = this.pTree.getCumulativeCpuTime();
        long pMem = this.pTree.getCumulativeRssmem();
        long vMem = this.pTree.getCumulativeVmem();
        this.counters.findCounter((Enum)TaskCounter.CPU_MILLISECONDS).setValue(cpuTime -= this.initCpuCumulativeTime);
        this.counters.findCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES).setValue(pMem);
        this.counters.findCounter((Enum)TaskCounter.VIRTUAL_MEMORY_BYTES).setValue(vMem);
    }

    public static String normalizeStatus(String status, Configuration conf) {
        int progressStatusLength = conf.getInt("mapreduce.task.max.status.length", 512);
        if (status.length() > progressStatusLength) {
            LOG.warn((Object)("Task status: \"" + status + "\" truncated to max limit (" + progressStatusLength + " characters)"));
            status = status.substring(0, progressStatusLength);
        }
        return status;
    }

    protected static <INKEY, INVALUE, OUTKEY, OUTVALUE> Reducer.Context createReduceContext(Reducer<INKEY, INVALUE, OUTKEY, OUTVALUE> reducer, Configuration job, TaskAttemptID taskId, final TezRawKeyValueIterator rIter, Counter inputKeyCounter, Counter inputValueCounter, RecordWriter<OUTKEY, OUTVALUE> output, OutputCommitter committer, StatusReporter reporter, RawComparator<INKEY> comparator, Class<INKEY> keyClass, Class<INVALUE> valueClass) throws IOException, InterruptedException {
        RawKeyValueIterator r = new RawKeyValueIterator(){

            public boolean next() throws IOException {
                return rIter.next();
            }

            public DataInputBuffer getValue() throws IOException {
                return rIter.getValue();
            }

            public Progress getProgress() {
                return rIter.getProgress();
            }

            public DataInputBuffer getKey() throws IOException {
                return rIter.getKey();
            }

            public void close() throws IOException {
                rIter.close();
            }
        };
        ReduceContextImpl reduceContext = new ReduceContextImpl(job, (org.apache.hadoop.mapreduce.TaskAttemptID)taskId, r, inputKeyCounter, inputValueCounter, output, committer, reporter, comparator, keyClass, valueClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using key class: " + keyClass + ", valueClass: " + valueClass));
        }
        Reducer.Context reducerContext = new WrappedReducer().getReducerContext((ReduceContext)reduceContext);
        return reducerContext;
    }

    public void taskCleanup() throws IOException, InterruptedException {
        this.statusUpdate();
        LOG.info((Object)"Runnning cleanup for the task");
        this.committer.abortTask((TaskAttemptContext)this.taskAttemptContext);
    }

    public void localizeConfiguration(JobConf jobConf) throws IOException, InterruptedException {
        jobConf.set("mapreduce.task.id", this.taskAttemptId.getTaskID().toString());
        jobConf.set("mapreduce.task.attempt.id", this.taskAttemptId.toString());
        jobConf.setInt("mapreduce.task.partition", this.taskAttemptId.getTaskID().getId());
        jobConf.set("mapreduce.job.id", this.taskAttemptId.getJobID().toString());
    }

    public abstract TezCounter getOutputRecordsCounter();

    public abstract TezCounter getInputRecordsCounter();

    public TaskAttemptContext getTaskAttemptContext() {
        return this.taskAttemptContext;
    }

    public JobContext getJobContext() {
        return this.jobContext;
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.taskAttemptId;
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

