/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.counters.FileSystemCounterGroup;
import org.apache.hadoop.mapreduce.counters.FrameworkCounterGroup;
import org.apache.hadoop.mapreduce.util.CountersStrings;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.FileSystemCounterGroup;
import org.apache.tez.common.counters.FrameworkCounterGroup;
import org.apache.tez.common.counters.GenericCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRCounters
extends Counters {
    private final TezCounters raw;

    public MRCounters(TezCounters raw) {
        this.raw = raw;
    }

    public synchronized Counters.Group getGroup(String groupName) {
        return new MRCounterGroup((CounterGroup)this.raw.getGroup(groupName));
    }

    public synchronized Collection<String> getGroupNames() {
        return IteratorUtils.toList(this.raw.getGroupNames().iterator());
    }

    public synchronized String makeCompactString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Counters.Group group = (Counters.Group)i$.next();
            for (Counters.Counter counter : group) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(group.getDisplayName());
                builder.append('.');
                builder.append(counter.getDisplayName());
                builder.append(':');
                builder.append(counter.getCounter());
            }
        }
        return builder.toString();
    }

    public synchronized Counters.Counter findCounter(String group, String name) {
        return new MRCounter(this.raw.findCounter(group, name));
    }

    public Counters.Counter findCounter(String group, int id, String name) {
        return new MRCounter(this.raw.findCounter(group, name));
    }

    public void incrCounter(Enum<?> key, long amount) {
        this.raw.findCounter(key).increment(amount);
    }

    public void incrCounter(String group, String counter, long amount) {
        this.raw.findCounter(group, counter).increment(amount);
    }

    public synchronized long getCounter(Enum<?> key) {
        return this.raw.findCounter(key).getValue();
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Counters.Group otherGroup : other) {
            Counters.Group group = this.getGroup(otherGroup.getName());
            group.setDisplayName(otherGroup.getDisplayName());
            for (Counters.Counter otherCounter : otherGroup) {
                Counters.Counter counter = group.getCounterForName(otherCounter.getName());
                counter.setDisplayName(otherCounter.getDisplayName());
                counter.increment(otherCounter.getValue());
            }
        }
    }

    public int size() {
        return this.countCounters();
    }

    public void log(Log log) {
        log.info((Object)("Counters: " + this.size()));
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Counters.Group group = (Counters.Group)i$.next();
            log.info((Object)("  " + group.getDisplayName()));
            for (Counters.Counter counter : group) {
                log.info((Object)("    " + counter.getDisplayName() + "=" + counter.getCounter()));
            }
        }
    }

    public String makeEscapedCompactString() {
        return CountersStrings.toEscapedCompactString((AbstractCounters)this);
    }

    static TezCounter convert(Counters.Counter counter) {
        Counter underlyingCounter = counter.getUnderlyingCounter();
        if (underlyingCounter instanceof FrameworkCounterGroup.FrameworkCounter) {
            FrameworkCounterGroup.FrameworkCounter real = (FrameworkCounterGroup.FrameworkCounter)underlyingCounter;
            return new FrameworkCounterGroup.FrameworkCounter(real.getKey(), real.getGroupName());
        }
        if (underlyingCounter instanceof FileSystemCounterGroup.FSCounter) {
            FileSystemCounterGroup.FSCounter real = (FileSystemCounterGroup.FSCounter)underlyingCounter;
            return new FileSystemCounterGroup.FSCounter(real.getScheme(), MRCounters.convert(real.getFileSystemCounter()));
        }
        return new GenericCounter(underlyingCounter.getName(), underlyingCounter.getDisplayName(), underlyingCounter.getValue());
    }

    static FileSystemCounter convert(org.apache.hadoop.mapreduce.FileSystemCounter c) {
        switch (c) {
            case BYTES_READ: {
                return FileSystemCounter.BYTES_READ;
            }
            case BYTES_WRITTEN: {
                return FileSystemCounter.BYTES_WRITTEN;
            }
            case READ_OPS: {
                return FileSystemCounter.READ_OPS;
            }
            case LARGE_READ_OPS: {
                return FileSystemCounter.LARGE_READ_OPS;
            }
            case WRITE_OPS: {
                return FileSystemCounter.WRITE_OPS;
            }
        }
        throw new IllegalArgumentException("Unknow FileSystemCounter: " + c);
    }

    public static class MRCounter
    extends Counters.Counter {
        private final TezCounter raw;

        public MRCounter(TezCounter raw) {
            this.raw = raw;
        }

        public void setDisplayName(String displayName) {
            this.raw.setDisplayName(displayName);
        }

        public String getName() {
            return this.raw.getName();
        }

        public String getDisplayName() {
            return this.raw.getDisplayName();
        }

        public long getValue() {
            return this.raw.getValue();
        }

        public void setValue(long value) {
            this.raw.setValue(value);
        }

        public void increment(long incr) {
            this.raw.increment(incr);
        }

        public void write(DataOutput out) throws IOException {
            this.raw.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.raw.readFields(in);
        }

        public String makeEscapedCompactString() {
            return CountersStrings.toEscapedCompactString((Counter)new MRCounter(this.raw));
        }

        @Deprecated
        public boolean contentEquals(Counters.Counter counter) {
            MRCounter c = new MRCounter(this.raw);
            return c.equals(counter.getUnderlyingCounter());
        }

        public long getCounter() {
            return this.raw.getValue();
        }

        public Counter getUnderlyingCounter() {
            return new MRCounter(this.raw).getUnderlyingCounter();
        }

        public synchronized boolean equals(Object genericRight) {
            return this.raw.equals(genericRight);
        }

        public int hashCode() {
            return this.raw.hashCode();
        }
    }

    public static class MRCounterGroup
    extends Counters.Group {
        private final CounterGroup group;

        public MRCounterGroup(CounterGroup group) {
            this.group = group;
        }

        public String getName() {
            return this.group.getName();
        }

        public String getDisplayName() {
            return this.group.getDisplayName();
        }

        public void setDisplayName(String displayName) {
            this.group.setDisplayName(displayName);
        }

        public void addCounter(Counters.Counter counter) {
            this.group.addCounter(MRCounters.convert(counter));
        }

        public Counters.Counter addCounter(String name, String displayName, long value) {
            return new MRCounter(this.group.addCounter(name, displayName, value));
        }

        public Counters.Counter findCounter(String counterName, String displayName) {
            return new MRCounter(this.group.findCounter(counterName, displayName));
        }

        public int size() {
            return this.group.size();
        }

        public void incrAllCounters(CounterGroupBase rightGroup) {
            new MRCounterGroup(this.group).incrAllCounters(rightGroup);
        }

        public CounterGroupBase getUnderlyingGroup() {
            return new MRCounterGroup(this.group).getUnderlyingGroup();
        }

        public void readFields(DataInput arg0) throws IOException {
        }

        public void write(DataOutput arg0) throws IOException {
        }

        public Iterator iterator() {
            return this.group.iterator();
        }
    }
}

