/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecatedKeys {
    private static Map<String, String> mrParamToDAGParamMap = new HashMap<String, String>();
    private static Map<String, Map<MultiStageKeys, String>> multiStageParamMap = new HashMap<String, Map<MultiStageKeys, String>>();
    private static Map<String, String> mrParamToTezRuntimeParamMap = new HashMap<String, String>();

    private static void populateMultiStageParamMap() {
        multiStageParamMap.put("mapreduce.job.output.key.comparator.class", DeprecatedKeys.getDeprecationMap("tez.runtime.intermediate-input.key.comparator.class", "tez.runtime.intermediate-output.key.comparator.class"));
        multiStageParamMap.put("mapreduce.map.output.key.class", DeprecatedKeys.getDeprecationMap("tez.runtime.intermediate-input.key.class", "tez.runtime.intermediate-output.key.class"));
        multiStageParamMap.put("mapreduce.map.output.value.class", DeprecatedKeys.getDeprecationMap("tez.runtime.intermediate-input.value.class", "tez.runtime.intermediate-output.value.class"));
        multiStageParamMap.put("mapreduce.map.output.compress", DeprecatedKeys.getDeprecationMap("tez.runtime.intermdiate-input.is-compressed", "tez.runtime.intermediate-output.should-compress"));
        multiStageParamMap.put("mapreduce.map.output.compress.codec", DeprecatedKeys.getDeprecationMap("tez.runtime.intermediate-input.compress.codec", "tez.runtime.intermediate-output.compress.codec"));
    }

    private static Map<MultiStageKeys, String> getDeprecationMap(String inputKey, String outputKey) {
        EnumMap m = Maps.newEnumMap(MultiStageKeys.class);
        m.put(MultiStageKeys.INPUT, inputKey);
        m.put(MultiStageKeys.OUTPUT, outputKey);
        return m;
    }

    private static void populateMRToDagParamMap() {
        mrParamToDAGParamMap.put("yarn.app.mapreduce.am.job.task.listener.thread-count", "tez.am.task.listener.thread-count");
        mrParamToDAGParamMap.put("mapreduce.job.maxtaskfailures.per.tracker", "tez.am.maxtaskfailures.per.node");
        mrParamToDAGParamMap.put("yarn.app.mapreduce.am.job.node-blacklisting.enable", "tez.am.node-blacklisting.enabled");
        mrParamToDAGParamMap.put("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", "tez.am.node-blacklisting.ignore-threshold-node-percent");
    }

    public static void init() {
    }

    private static void populateMRToTezRuntimeParamMap() {
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.queuename", "tez.queue.name");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.ifile.readahead", "tez.runtime.ifile.readahead");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.ifile.readahead.bytes", "tez.runtime.ifile.readahead.bytes");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.task.merge.progress.records", "tez.task.merge.progress.records");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.task.io.sort.factor", "tez.runtime.io.sort.factor");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.map.sort.spill.percent", "tez.runtime.sort.spill.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.task.io.sort.mb", "tez.runtime.io.sort.mb");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.task.index.cache.limit.bytes", "tez.runtime.index.cache.memory.limit.bytes");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.map.combine.minspills", "tez.runtime.combine.min.spills");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.counters.max", "tez.runtime.job.counters.max");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.counters.group.name.max", "tez.runtime.job.counters.group.name.max");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.counters.counter.name.max", "tez.runtime.job.counters.counter.name.max");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.counters.groups.max", "tez.runtime.job.counters.groups.max");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.memory.totalbytes", "tez.runtime.task.memory");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.parallelcopies", "tez.runtime.shuffle.parallel.copies");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.maxfetchfailures", "tez.runtime.shuffle.fetch.failures.limit");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.notify.readerror", "tez.runtime.shuffle.notify.readerror");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.connect.timeout", "tez.runtime.shuffle.connect.timeout");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.read.timeout", "tez.runtime.shuffle.read.timeout");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.shuffle.ssl.enabled", "tez.runtime.shuffle.ssl.enable");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.input.buffer.percent", "tez.runtime.shuffle.input.buffer.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.memory.limit.percent", "tez.runtime.shuffle.memory.limit.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.shuffle.merge.percent", "tez.runtime.shuffle.merge.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.merge.memtomem.threshold", "tez.runtime.shuffle.memory-to-memory.segments");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.merge.memtomem.enabled", "tez.runtime.shuffle.memory-to-memory.enable");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.reduce.input.buffer.percent", "tez.runtime.task.input.buffer.percent");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.credentials.binary", "tez.dag.credentials.binary");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("map.sort.class", "tez.runtime.internal.sorter.class");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.output.group.comparator.class", "tez.runtime.group.comparator.class");
        DeprecatedKeys.registerMRToRuntimeKeyTranslation("mapreduce.job.output.group.comparator.class", "tez.runtime.intermediate-input.key.secondary.comparator.class");
    }

    private static void addDeprecatedKeys() {
    }

    private static void registerMRToRuntimeKeyTranslation(String mrKey, String tezKey) {
        mrParamToTezRuntimeParamMap.put(mrKey, tezKey);
    }

    private static void _(String mrKey, String tezKey) {
        Configuration.addDeprecation((String)mrKey, (String)tezKey);
    }

    public static Map<String, String> getMRToDAGParamMap() {
        return Collections.unmodifiableMap(mrParamToDAGParamMap);
    }

    public static Map<String, String> getMRToTezRuntimeParamMap() {
        return Collections.unmodifiableMap(mrParamToTezRuntimeParamMap);
    }

    public static Map<String, Map<MultiStageKeys, String>> getMultiStageParamMap() {
        return Collections.unmodifiableMap(multiStageParamMap);
    }

    static {
        DeprecatedKeys.populateMRToTezRuntimeParamMap();
        DeprecatedKeys.populateMRToDagParamMap();
        DeprecatedKeys.populateMultiStageParamMap();
        DeprecatedKeys.addDeprecatedKeys();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MultiStageKeys {
        INPUT,
        OUTPUT;

    }
}

