/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.split;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TezGroupedSplitsInputFormat<K, V>
implements InputFormat<K, V>,
Configurable {
    private static final Log LOG = LogFactory.getLog(TezGroupedSplitsInputFormat.class);
    InputFormat<K, V> wrappedInputFormat;
    int desiredNumSplits = 0;
    Configuration conf;

    public void setInputFormat(InputFormat<K, V> wrappedInputFormat) {
        this.wrappedInputFormat = wrappedInputFormat;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("wrappedInputFormat: " + wrappedInputFormat.getClass().getName()));
        }
    }

    public void setDesiredNumberOfSplits(int num) {
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0);
        this.desiredNumSplits = num;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("desiredNumSplits: " + this.desiredNumSplits));
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        LOG.info((Object)"Grouping splits in Tez");
        int configNumSplits = this.conf.getInt("tez.am.grouping.split-count", 0);
        if (configNumSplits > 0) {
            this.desiredNumSplits = configNumSplits;
            LOG.info((Object)("Desired numSplits overridden by config to: " + this.desiredNumSplits));
        }
        if (this.desiredNumSplits > 0) {
            numSplits = this.desiredNumSplits;
        }
        InputSplit[] originalSplits = this.wrappedInputFormat.getSplits(job, numSplits);
        if (configNumSplits <= 0 && originalSplits != null && originalSplits.length != 0) {
            int newDesiredNumSplits;
            long minLengthPerGroup;
            long totalLength = 0L;
            for (InputSplit split : originalSplits) {
                totalLength += split.getLength();
            }
            int splitCount = this.desiredNumSplits > 0 ? this.desiredNumSplits : originalSplits.length;
            long lengthPerGroup = totalLength / (long)splitCount;
            long maxLengthPerGroup = job.getLong("tez.am.grouping.max-size", TezConfiguration.TEZ_AM_GROUPING_SPLIT_MAX_SIZE_DEFAULT);
            if (maxLengthPerGroup < (minLengthPerGroup = job.getLong("tez.am.grouping.min-size", TezConfiguration.TEZ_AM_GROUPING_SPLIT_MIN_SIZE_DEFAULT)) || minLengthPerGroup <= 0L) {
                throw new TezUncheckedException("Invalid max/min group lengths. Required min>0, max>=min.  max: " + maxLengthPerGroup + " min: " + minLengthPerGroup);
            }
            if (lengthPerGroup > maxLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / maxLengthPerGroup) + 1;
                LOG.info((Object)("Desired splits: " + this.desiredNumSplits + " too small. " + " Desired splitLength: " + lengthPerGroup + " Max splitLength: " + maxLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.length));
                this.desiredNumSplits = newDesiredNumSplits;
                if (this.desiredNumSplits > originalSplits.length) {
                    LOG.info((Object)("Recalculating splits. Original splits: " + originalSplits.length));
                    originalSplits = this.wrappedInputFormat.getSplits(job, this.desiredNumSplits);
                }
            } else if (lengthPerGroup < minLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / minLengthPerGroup) + 1;
                LOG.info((Object)("Desired splits: " + this.desiredNumSplits + " too large. " + " Desired splitLength: " + lengthPerGroup + " Min splitLength: " + minLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.length));
                this.desiredNumSplits = newDesiredNumSplits;
                if (this.desiredNumSplits > originalSplits.length) {
                    LOG.info((Object)("Recalculating splits. Original splits: " + originalSplits.length));
                    originalSplits = this.wrappedInputFormat.getSplits(job, this.desiredNumSplits);
                }
            }
        }
        if (originalSplits == null) {
            LOG.info((Object)"Null original splits");
            return null;
        }
        String wrappedInputFormatName = this.wrappedInputFormat.getClass().getName();
        if (this.desiredNumSplits == 0 || originalSplits.length == 0 || this.desiredNumSplits >= originalSplits.length) {
            LOG.info((Object)("Using original number of splits: " + originalSplits.length + " desired splits: " + this.desiredNumSplits));
            InputSplit[] groupedSplits = new TezGroupedSplit[originalSplits.length];
            int i = 0;
            for (InputSplit split : originalSplits) {
                TezGroupedSplit newSplit = new TezGroupedSplit(1, wrappedInputFormatName, split.getLocations());
                newSplit.addSplit(split);
                groupedSplits[i++] = newSplit;
            }
            return groupedSplits;
        }
        String emptyLocation = "EmptyLocation";
        String[] emptyLocations = new String[]{emptyLocation};
        ArrayList<TezGroupedSplit> groupedSplitsList = new ArrayList<TezGroupedSplit>(this.desiredNumSplits);
        long totalLength = 0L;
        HashMap<String, LocationHolder> distinctLocations = new HashMap<String, LocationHolder>();
        for (InputSplit split : originalSplits) {
            totalLength += split.getLength();
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String string : locations) {
                distinctLocations.put(string, null);
            }
        }
        long lengthPerGroup = totalLength / (long)this.desiredNumSplits;
        int numNodeLocations = distinctLocations.size();
        int numSplitsPerLocation = originalSplits.length / numNodeLocations;
        int numSplitsInGroup = originalSplits.length / this.desiredNumSplits;
        for (String location : distinctLocations.keySet()) {
            distinctLocations.put(location, new LocationHolder(numSplitsPerLocation));
        }
        for (String string : originalSplits) {
            SplitHolder splitHolder = new SplitHolder((InputSplit)string);
            String[] locations = string.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location : locations) {
                LocationHolder holder = (LocationHolder)distinctLocations.get(location);
                holder.splits.add(splitHolder);
            }
        }
        boolean groupByLength = this.conf.getBoolean("tez.am.grouping.by-length", true);
        boolean groupByCount = this.conf.getBoolean("tez.am.grouping.by-count", false);
        if (!groupByLength && !groupByCount) {
            throw new TezUncheckedException("None of the grouping parameters are true: tez.am.grouping.by-length, tez.am.grouping.by-count");
        }
        LOG.info((Object)("Desired numSplits: " + this.desiredNumSplits + " lengthPerGroup: " + lengthPerGroup + " numLocations: " + numNodeLocations + " numSplitsPerLocation: " + numSplitsPerLocation + " numSplitsInGroup: " + numSplitsInGroup + " totalLength: " + totalLength + " numOriginalSplits: " + originalSplits.length + " . Grouping by length: " + groupByLength + " count: " + groupByCount));
        int splitsProcessed = 0;
        ArrayList<SplitHolder> arrayList = new ArrayList<SplitHolder>(numSplitsInGroup + 1);
        HashSet<String> groupLocationSet = new HashSet<String>(10);
        boolean allowSmallGroups = false;
        boolean doingRackLocal = false;
        int iterations = 0;
        while (splitsProcessed < originalSplits.length) {
            ++iterations;
            int numFullGroupsCreated = 0;
            for (Map.Entry entry : distinctLocations.entrySet()) {
                arrayList.clear();
                groupLocationSet.clear();
                String location = (String)entry.getKey();
                LocationHolder holder = (LocationHolder)entry.getValue();
                SplitHolder splitHolder = holder.getUnprocessedHeadSplit();
                if (splitHolder == null) continue;
                int oldHeadIndex = holder.headIndex;
                long groupLength = 0L;
                int groupNumSplits = 0;
                do {
                    arrayList.add(splitHolder);
                    holder.incrementHeadIndex();
                } while ((splitHolder = holder.getUnprocessedHeadSplit()) != null && (!groupByLength || (groupLength += splitHolder.split.getLength()) + splitHolder.split.getLength() <= lengthPerGroup) && (!groupByCount || ++groupNumSplits + 1 <= numSplitsInGroup));
                if (!(!holder.isEmpty() || allowSmallGroups || groupByLength && groupLength >= lengthPerGroup / 2L || groupByCount && groupNumSplits >= numSplitsInGroup / 2)) {
                    holder.headIndex = oldHeadIndex;
                    continue;
                }
                ++numFullGroupsCreated;
                String[] groupLocation = new String[]{location};
                if (doingRackLocal) {
                    for (SplitHolder splitH : arrayList) {
                        String[] locations = splitH.split.getLocations();
                        if (locations == null) continue;
                        for (String loc : locations) {
                            groupLocationSet.add(loc);
                        }
                    }
                    groupLocation = groupLocationSet.toArray(groupLocation);
                } else if (location == emptyLocation) {
                    groupLocation = null;
                }
                TezGroupedSplit groupedSplit = new TezGroupedSplit(arrayList.size(), wrappedInputFormatName, groupLocation, doingRackLocal && location != emptyLocation ? location : null);
                for (SplitHolder groupedSplitHolder : arrayList) {
                    groupedSplit.addSplit(groupedSplitHolder.split);
                    groupedSplitHolder.isProcessed = true;
                    ++splitsProcessed;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Grouped " + arrayList.size() + " length: " + groupedSplit.getLength() + " split at: " + location));
                }
                groupedSplitsList.add(groupedSplit);
            }
            if (!doingRackLocal && numFullGroupsCreated < 1) {
                doingRackLocal = true;
                int numRemainingSplits = originalSplits.length - splitsProcessed;
                HashSet<InputSplit> remainingSplits = new HashSet<InputSplit>(numRemainingSplits);
                for (Map.Entry entry : distinctLocations.entrySet()) {
                    LocationHolder locHolder = (LocationHolder)entry.getValue();
                    while (!locHolder.isEmpty()) {
                        SplitHolder splitHolder = locHolder.getUnprocessedHeadSplit();
                        if (splitHolder == null) continue;
                        remainingSplits.add(splitHolder.split);
                        locHolder.incrementHeadIndex();
                    }
                }
                if (remainingSplits.size() != numRemainingSplits) {
                    throw new TezUncheckedException("Expected: " + numRemainingSplits + " got: " + remainingSplits.size());
                }
                RackResolver.init((Configuration)this.conf);
                HashMap<String, String> locToRackMap = new HashMap<String, String>(distinctLocations.size());
                HashMap<String, LocationHolder> rackLocations = new HashMap<String, LocationHolder>();
                for (String location : distinctLocations.keySet()) {
                    String rack = emptyLocation;
                    if (location != emptyLocation) {
                        rack = RackResolver.resolve((String)location).getNetworkLocation();
                    }
                    locToRackMap.put(location, rack);
                    if (rackLocations.get(rack) != null) continue;
                    rackLocations.put(rack, new LocationHolder(numRemainingSplits));
                }
                HashSet rackSet = new HashSet(rackLocations.size());
                for (InputSplit split : remainingSplits) {
                    rackSet.clear();
                    SplitHolder splitHolder = new SplitHolder(split);
                    String[] locations = split.getLocations();
                    if (locations == null || locations.length == 0) {
                        locations = emptyLocations;
                    }
                    for (String location : locations) {
                        rackSet.add(locToRackMap.get(location));
                    }
                    for (String rack : rackSet) {
                        ((LocationHolder)rackLocations.get((Object)rack)).splits.add(splitHolder);
                    }
                }
                distinctLocations.clear();
                distinctLocations = rackLocations;
                float rackSplitReduction = job.getFloat("tez.am.grouping.rack-split-reduction", 0.75f);
                if (rackSplitReduction > 0.0f) {
                    long newLengthPerGroup = (long)((float)lengthPerGroup * rackSplitReduction);
                    int newNumSplitsInGroup = (int)((float)numSplitsInGroup * rackSplitReduction);
                    if (newLengthPerGroup > 0L) {
                        lengthPerGroup = newLengthPerGroup;
                    }
                    if (newNumSplitsInGroup > 0) {
                        numSplitsInGroup = newNumSplitsInGroup;
                    }
                }
                LOG.info((Object)("Doing rack local after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size() + " lengthPerGroup: " + lengthPerGroup + " numSplitsInGroup: " + numSplitsInGroup));
                continue;
            }
            if (!allowSmallGroups && numFullGroupsCreated <= numNodeLocations / 10) {
                allowSmallGroups = true;
                LOG.info((Object)("Allowing small groups after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size()));
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size()));
        }
        InputSplit[] groupedSplits = new InputSplit[groupedSplitsList.size()];
        groupedSplitsList.toArray(groupedSplits);
        LOG.info((Object)("Number of splits desired: " + this.desiredNumSplits + " created: " + groupedSplitsList.size() + " splitsProcessed: " + splitsProcessed));
        return groupedSplits;
    }

    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        TezGroupedSplit groupedSplit = (TezGroupedSplit)split;
        this.initInputFormatFromSplit(groupedSplit);
        return new TezGroupedSplitsRecordReader(groupedSplit, job, reporter);
    }

    void initInputFormatFromSplit(TezGroupedSplit split) {
        if (this.wrappedInputFormat == null) {
            Class<?> clazz = TezGroupedSplitsInputFormat.getClassFromName(split.wrappedInputFormatName);
            try {
                this.wrappedInputFormat = (InputFormat)ReflectionUtils.newInstance(clazz, (Configuration)this.conf);
            }
            catch (Exception e) {
                throw new TezUncheckedException((Throwable)e);
            }
        }
    }

    static Class<?> getClassFromName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e1) {
            throw new TezUncheckedException((Throwable)e1);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TezGroupedSplitsRecordReader
    implements RecordReader<K, V> {
        TezGroupedSplit groupedSplit;
        JobConf job;
        Reporter reporter;
        int idx = 0;
        long progress;
        RecordReader<K, V> curReader;

        public TezGroupedSplitsRecordReader(TezGroupedSplit split, JobConf job, Reporter reporter) throws IOException {
            this.groupedSplit = split;
            this.job = job;
            this.reporter = reporter;
            this.initNextRecordReader();
        }

        public boolean next(K key, V value) throws IOException {
            while (this.curReader == null || !this.curReader.next(key, value)) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K createKey() {
            return this.curReader.createKey();
        }

        public V createValue() {
            return this.curReader.createValue();
        }

        public float getProgress() throws IOException {
            return Math.min(1.0f, (float)this.getPos() / (float)this.groupedSplit.getLength());
        }

        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        protected boolean initNextRecordReader() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    this.progress += this.groupedSplit.wrappedSplits.get(this.idx - 1).getLength();
                }
            }
            if (this.idx == this.groupedSplit.wrappedSplits.size()) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Init record reader for index " + this.idx + " of " + this.groupedSplit.wrappedSplits.size()));
            }
            try {
                this.curReader = TezGroupedSplitsInputFormat.this.wrappedInputFormat.getRecordReader(this.groupedSplit.wrappedSplits.get(this.idx), this.job, this.reporter);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++this.idx;
            return true;
        }

        public long getPos() throws IOException {
            long subprogress = 0L;
            if (null != this.curReader) {
                subprogress = this.curReader.getPos();
            }
            return this.progress + subprogress;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LocationHolder {
        List<SplitHolder> splits;
        int headIndex = 0;

        LocationHolder(int capacity) {
            this.splits = new ArrayList<SplitHolder>(capacity);
        }

        boolean isEmpty() {
            return this.headIndex == this.splits.size();
        }

        SplitHolder getUnprocessedHeadSplit() {
            while (!this.isEmpty()) {
                SplitHolder holder = this.splits.get(this.headIndex);
                if (!holder.isProcessed) {
                    return holder;
                }
                this.incrementHeadIndex();
            }
            return null;
        }

        void incrementHeadIndex() {
            ++this.headIndex;
        }
    }

    class SplitHolder {
        InputSplit split;
        boolean isProcessed = false;

        SplitHolder(InputSplit split) {
            this.split = split;
        }
    }
}

