/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class SecondarySort {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length != 2) {
            System.err.println("Usage: secondarysort <in> <out>");
            System.exit(2);
        }
        Job job = new Job(conf, "secondary sort");
        job.setJarByClass(SecondarySort.class);
        job.setMapperClass(MapClass.class);
        job.setReducerClass(Reduce.class);
        job.setPartitionerClass(FirstPartitioner.class);
        job.setGroupingComparatorClass(FirstGroupingComparator.class);
        job.setMapOutputKeyClass(IntPair.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(otherArgs[0]));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(otherArgs[1]));
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reduce
    extends Reducer<IntPair, IntWritable, Text, IntWritable> {
        private static final Text SEPARATOR = new Text("------------------------------------------------");
        private final Text first = new Text();

        public void reduce(IntPair key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)SEPARATOR, null);
            this.first.set(Integer.toString(key.getFirst()));
            for (IntWritable value : values) {
                context.write((Object)this.first, (Object)value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapClass
    extends Mapper<LongWritable, Text, IntPair, IntWritable> {
        private final IntPair key = new IntPair();
        private final IntWritable value = new IntWritable();

        public void map(LongWritable inKey, Text inValue, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(inValue.toString());
            int left = 0;
            int right = 0;
            if (itr.hasMoreTokens()) {
                left = Integer.parseInt(itr.nextToken());
                if (itr.hasMoreTokens()) {
                    right = Integer.parseInt(itr.nextToken());
                }
                this.key.set(left, right);
                this.value.set(right);
                context.write((Object)this.key, (Object)this.value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FirstGroupingComparator
    implements RawComparator<IntPair> {
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return WritableComparator.compareBytes((byte[])b1, (int)s1, (int)4, (byte[])b2, (int)s2, (int)4);
        }

        public int compare(IntPair o1, IntPair o2) {
            int r;
            int l = o1.getFirst();
            return l == (r = o2.getFirst()) ? 0 : (l < r ? -1 : 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FirstPartitioner
    extends Partitioner<IntPair, IntWritable> {
        public int getPartition(IntPair key, IntWritable value, int numPartitions) {
            return Math.abs(key.getFirst() * 127) % numPartitions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntPair
    implements WritableComparable<IntPair> {
        private int first = 0;
        private int second = 0;

        public void set(int left, int right) {
            this.first = left;
            this.second = right;
        }

        public int getFirst() {
            return this.first;
        }

        public int getSecond() {
            return this.second;
        }

        public void readFields(DataInput in) throws IOException {
            this.first = in.readInt() + Integer.MIN_VALUE;
            this.second = in.readInt() + Integer.MIN_VALUE;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.first - Integer.MIN_VALUE);
            out.writeInt(this.second - Integer.MIN_VALUE);
        }

        public int hashCode() {
            return this.first * 157 + this.second;
        }

        public boolean equals(Object right) {
            if (right instanceof IntPair) {
                IntPair r = (IntPair)right;
                return r.first == this.first && r.second == this.second;
            }
            return false;
        }

        public int compareTo(IntPair o) {
            if (this.first != o.first) {
                return this.first < o.first ? -1 : 1;
            }
            if (this.second != o.second) {
                return this.second < o.second ? -1 : 1;
            }
            return 0;
        }

        static {
            WritableComparator.define(IntPair.class, (WritableComparator)new Comparator());
        }

        public static class Comparator
        extends WritableComparator {
            public Comparator() {
                super(IntPair.class);
            }

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                return Comparator.compareBytes((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
            }
        }
    }
}

