/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.mapreduce.examples.ExampleDriver;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfigUtil;

public class GroupByOrderByMRRTest {
    private static final Log LOG = LogFactory.getLog(GroupByOrderByMRRTest.class);

    public static void main(String[] args) throws Exception {
        DAGStatus dagStatus;
        Configuration conf = new Configuration();
        conf.setInt("mrr.intermediate.num-stages", 1);
        conf.setClass(MultiStageMRConfigUtil.getPropertyNameForIntermediateStage((int)1, (String)"mapreduce.job.reduce.class"), MyGroupByReducer.class, Reducer.class);
        conf.setClass(MultiStageMRConfigUtil.getPropertyNameForIntermediateStage((int)1, (String)"mapreduce.map.output.key.class"), IntWritable.class, Object.class);
        conf.setClass(MultiStageMRConfigUtil.getPropertyNameForIntermediateStage((int)1, (String)"mapreduce.map.output.value.class"), Text.class, Object.class);
        conf.setInt(MultiStageMRConfigUtil.getPropertyNameForIntermediateStage((int)1, (String)"mapreduce.job.reduces"), 2);
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length != 2) {
            System.err.println("Usage: groupbyorderbymrrtest <in> <out>");
            System.exit(2);
        }
        Job job = new Job(conf, "groupbyorderbymrrtest");
        job.setJarByClass(GroupByOrderByMRRTest.class);
        job.setMapperClass(MyMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setReducerClass(MyOrderByNoOpReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        job.setNumReduceTasks(1);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(otherArgs[0]));
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(otherArgs[1]));
        TezClient tezClient = new TezClient(new TezConfiguration(conf));
        job.submit();
        JobID jobId = job.getJobID();
        ApplicationId appId = TypeConverter.toYarn((JobID)jobId).getAppId();
        DAGClient dagClient = tezClient.getDAGClient(appId);
        String[] vNames = new String[]{"initialmap", "ireduce1", "finalreduce"};
        while ((dagStatus = dagClient.getDAGStatus(null)).getState() != DAGStatus.State.RUNNING && dagStatus.getState() != DAGStatus.State.SUCCEEDED && dagStatus.getState() != DAGStatus.State.FAILED && dagStatus.getState() != DAGStatus.State.KILLED && dagStatus.getState() != DAGStatus.State.ERROR) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        while (dagStatus.getState() == DAGStatus.State.RUNNING) {
            try {
                ExampleDriver.printDAGStatus(dagClient, vNames);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                dagStatus = dagClient.getDAGStatus(null);
            }
            catch (TezException e) {
                LOG.fatal((Object)"Failed to get application progress. Exiting");
                System.exit(-1);
            }
        }
        ExampleDriver.printDAGStatus(dagClient, vNames);
        LOG.info((Object)("Application completed. FinalState=" + dagStatus.getState()));
        System.exit(dagStatus.getState() == DAGStatus.State.SUCCEEDED ? 0 : 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyOrderByNoOpReducer
    extends Reducer<IntWritable, Text, Text, IntWritable> {
        public void reduce(IntWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            for (Text word : values) {
                context.write((Object)word, (Object)key);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyGroupByReducer
    extends Reducer<Text, IntWritable, IntWritable, Text> {
        private IntWritable result = new IntWritable();

        public void reduce(Text key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)this.result, (Object)key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyMapper
    extends Mapper<Object, Text, Text, IntWritable> {
        private static final IntWritable one = new IntWritable(1);
        private static final Text word = new Text();

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            StringTokenizer itr = new StringTokenizer(value.toString());
            String empName = "";
            String deptName = "";
            if (itr.hasMoreTokens()) {
                empName = itr.nextToken();
                if (itr.hasMoreTokens()) {
                    deptName = itr.nextToken();
                }
                if (!empName.isEmpty() && !deptName.isEmpty()) {
                    word.set(deptName);
                    context.write((Object)word, (Object)one);
                }
            }
        }
    }
}

