/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ClassUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.client.TezSession;
import org.apache.tez.client.TezSessionConfiguration;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.mapreduce.common.MRInputAMSplitGenerator;
import org.apache.tez.mapreduce.examples.ExampleDriver;
import org.apache.tez.mapreduce.examples.helpers.SplitsInClientOptionParser;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoDisk;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfToTezTranslator;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.processor.FilterByWordInputProcessor;
import org.apache.tez.processor.FilterByWordOutputProcessor;
import org.apache.tez.runtime.library.input.ShuffledUnorderedKVInput;
import org.apache.tez.runtime.library.output.OnFileUnorderedKVOutput;

public class FilterLinesByWord {
    private static Log LOG = LogFactory.getLog(FilterLinesByWord.class);
    public static final String FILTER_PARAM_NAME = "tez.runtime.examples.filterbyword.word";

    private static void printUsage() {
        System.err.println("Usage filtelinesrbyword <in> <out> <filter_word> [-generateSplitsInClient true/<false>]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException, TezException {
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        boolean generateSplitsInClient = false;
        SplitsInClientOptionParser splitCmdLineParser = new SplitsInClientOptionParser();
        try {
            generateSplitsInClient = splitCmdLineParser.parse(otherArgs, false);
            otherArgs = splitCmdLineParser.getRemainingArgs();
        }
        catch (ParseException e1) {
            System.err.println("Invalid options");
            FilterLinesByWord.printUsage();
            System.exit(2);
        }
        if (otherArgs.length != 3) {
            FilterLinesByWord.printUsage();
            System.exit(2);
        }
        String inputPath = otherArgs[0];
        String outputPath = otherArgs[1];
        String filterWord = otherArgs[2];
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(new Path(outputPath))) {
            System.err.println("Output directory : " + outputPath + " already exists");
            System.exit(2);
        }
        TezConfiguration tezConf = new TezConfiguration(conf);
        fs.getWorkingDirectory();
        Path stagingDir = new Path(fs.getWorkingDirectory(), UUID.randomUUID().toString());
        tezConf.set("tez.staging-dir", stagingDir.toString());
        TezClientUtils.ensureStagingDirExists((Configuration)tezConf, (Path)stagingDir);
        tezConf.set("tez.am.java.opts", MRHelpers.getMRAMJavaOpts((Configuration)tezConf));
        String jarPath = ClassUtil.findContainingJar(FilterLinesByWord.class);
        if (jarPath == null) {
            throw new TezUncheckedException("Could not find any jar containing" + FilterLinesByWord.class.getName() + " in the classpath");
        }
        Path remoteJarPath = fs.makeQualified(new Path(stagingDir, "dag_job.jar"));
        fs.copyFromLocalFile(new Path(jarPath), remoteJarPath);
        FileStatus remoteJarStatus = fs.getFileStatus(remoteJarPath);
        TreeMap<String, LocalResource> commonLocalResources = new TreeMap<String, LocalResource>();
        LocalResource dagJarLocalRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromPath((Path)remoteJarPath), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)remoteJarStatus.getLen(), (long)remoteJarStatus.getModificationTime());
        commonLocalResources.put("dag_job.jar", dagJarLocalRsrc);
        AMConfiguration amConf = new AMConfiguration(null, commonLocalResources, tezConf, null);
        TezSessionConfiguration sessionConf = new TezSessionConfiguration(amConf, tezConf);
        TezSession tezSession = new TezSession("FilterLinesByWordSession", sessionConf);
        tezSession.start();
        JobConf stage1Conf = new JobConf(conf);
        stage1Conf.set("mapreduce.input.fileinputformat.inputdir", inputPath);
        stage1Conf.setBoolean("mapred.mapper.new-api", false);
        stage1Conf.set("tez.runtime.intermediate-output.key.class", Text.class.getName());
        stage1Conf.set("tez.runtime.intermediate-output.value.class", TextLongPair.class.getName());
        stage1Conf.set(FILTER_PARAM_NAME, filterWord);
        InputSplitInfoDisk inputSplitInfo = null;
        if (generateSplitsInClient) {
            inputSplitInfo = MRHelpers.generateInputSplits((Configuration)stage1Conf, (Path)stagingDir);
        }
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)stage1Conf, null);
        JobConf stage2Conf = new JobConf(conf);
        stage2Conf.set("tez.runtime.intermediate-input.key.class", Text.class.getName());
        stage2Conf.set("tez.runtime.intermediate-input.value.class", TextLongPair.class.getName());
        stage2Conf.set("mapreduce.output.fileoutputformat.outputdir", outputPath);
        stage2Conf.setBoolean("mapred.mapper.new-api", false);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)stage2Conf, (Configuration)stage1Conf);
        MRHelpers.doJobClientMagic((Configuration)stage1Conf);
        MRHelpers.doJobClientMagic((Configuration)stage2Conf);
        byte[] stage1Payload = MRHelpers.createUserPayloadFromConf((Configuration)stage1Conf);
        int stage1NumTasks = generateSplitsInClient ? inputSplitInfo.getNumTasks() : -1;
        Vertex stage1Vertex = new Vertex("stage1", new ProcessorDescriptor(FilterByWordInputProcessor.class.getName()).setUserPayload(stage1Payload), stage1NumTasks, MRHelpers.getMapResource((Configuration)stage1Conf));
        stage1Vertex.setJavaOpts(MRHelpers.getMapJavaOpts((Configuration)stage1Conf));
        if (generateSplitsInClient) {
            stage1Vertex.setTaskLocationsHint(inputSplitInfo.getTaskLocationHints());
            HashMap<String, LocalResource> stage1LocalResources = new HashMap<String, LocalResource>();
            stage1LocalResources.putAll(commonLocalResources);
            MRHelpers.updateLocalResourcesForInputSplits((FileSystem)fs, (InputSplitInfo)inputSplitInfo, stage1LocalResources);
            stage1Vertex.setTaskLocalResources(stage1LocalResources);
        } else {
            stage1Vertex.setTaskLocalResources(commonLocalResources);
        }
        HashMap stage1Env = new HashMap();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)stage1Conf, stage1Env, (boolean)true);
        stage1Vertex.setTaskEnvironment(stage1Env);
        Class<MRInputAMSplitGenerator> initializerClazz = generateSplitsInClient ? null : MRInputAMSplitGenerator.class;
        stage1Vertex.addInput("MRInput", new InputDescriptor(MRInputLegacy.class.getName()).setUserPayload(MRHelpers.createMRInputPayload((byte[])stage1Payload, null)), initializerClazz);
        Vertex stage2Vertex = new Vertex("stage2", new ProcessorDescriptor(FilterByWordOutputProcessor.class.getName()).setUserPayload(MRHelpers.createUserPayloadFromConf((Configuration)stage2Conf)), 1, MRHelpers.getMapResource((Configuration)stage2Conf));
        stage2Vertex.setJavaOpts(MRHelpers.getReduceJavaOpts((Configuration)stage2Conf)).setTaskLocalResources(commonLocalResources);
        HashMap stage2Env = new HashMap();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)stage2Conf, stage2Env, (boolean)false);
        stage2Vertex.setTaskEnvironment(stage2Env);
        stage2Vertex.addOutput("MROutput", new OutputDescriptor(MROutput.class.getName()).setUserPayload(MRHelpers.createUserPayloadFromConf((Configuration)stage2Conf)));
        DAG dag = new DAG("FilterLinesByWord");
        Edge edge = new Edge(stage1Vertex, stage2Vertex, new EdgeProperty(EdgeProperty.DataMovementType.BROADCAST, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(OnFileUnorderedKVOutput.class.getName()), new InputDescriptor(ShuffledUnorderedKVInput.class.getName())));
        dag.addVertex(stage1Vertex).addVertex(stage2Vertex).addEdge(edge);
        LOG.info((Object)"Submitting DAG to Tez Session");
        DAGClient dagClient = tezSession.submitDAG(dag);
        LOG.info((Object)"Submitted DAG to Tez Session");
        DAGStatus dagStatus = null;
        String[] vNames = new String[]{"stage1", "stage2"};
        try {
            while ((dagStatus = dagClient.getDAGStatus(null)).getState() != DAGStatus.State.RUNNING && dagStatus.getState() != DAGStatus.State.SUCCEEDED && dagStatus.getState() != DAGStatus.State.FAILED && dagStatus.getState() != DAGStatus.State.KILLED && dagStatus.getState() != DAGStatus.State.ERROR) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            while (dagStatus.getState() == DAGStatus.State.RUNNING) {
                try {
                    ExampleDriver.printDAGStatus(dagClient, vNames);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    dagStatus = dagClient.getDAGStatus(null);
                }
                catch (TezException e) {
                    LOG.fatal((Object)"Failed to get application progress. Exiting");
                    System.exit(-1);
                }
            }
        }
        finally {
            fs.delete(stagingDir, true);
            tezSession.stop();
        }
        ExampleDriver.printDAGStatus(dagClient, vNames);
        LOG.info((Object)("Application completed. FinalState=" + dagStatus.getState()));
        System.exit(dagStatus.getState() == DAGStatus.State.SUCCEEDED ? 0 : 1);
    }

    public static class TextLongPair
    implements Writable {
        private Text text;
        private LongWritable longWritable;

        public TextLongPair() {
        }

        public TextLongPair(Text text, LongWritable longWritable) {
            this.text = text;
            this.longWritable = longWritable;
        }

        public void write(DataOutput out) throws IOException {
            this.text.write(out);
            this.longWritable.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.text = new Text();
            this.longWritable = new LongWritable();
            this.text.readFields(in);
            this.longWritable.readFields(in);
        }

        public String toString() {
            return this.text.toString() + "\t" + this.longWritable.get();
        }
    }
}

