/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.node;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.rm.node.AMNode;
import org.apache.tez.dag.app.rm.node.AMNodeEvent;
import org.apache.tez.dag.app.rm.node.AMNodeEventNodeCountUpdated;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.AMNodeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerSourceNodeTracker {
    static final Logger LOG = LoggerFactory.getLogger(PerSourceNodeTracker.class);
    private final int sourceId;
    private final ConcurrentHashMap<NodeId, AMNode> nodeMap;
    private final ConcurrentHashMap<String, Set<NodeId>> blacklistMap;
    private final EventHandler eventHandler;
    private final AppContext appContext;
    private final int maxTaskFailuresPerNode;
    private final boolean nodeBlacklistingEnabled;
    private final int blacklistDisablePercent;
    private final boolean nodeUpdatesRescheduleEnabled;
    private int numClusterNodes;
    float currentIgnoreBlacklistingCountThreshold = 0.0f;
    private boolean ignoreBlacklisting = false;

    public PerSourceNodeTracker(int sourceId, EventHandler eventHandler, AppContext appContext, int maxTaskFailuresPerNode, boolean nodeBlacklistingEnabled, int blacklistDisablePercent, boolean nodeUpdatesRescheduleEnabled) {
        this.sourceId = sourceId;
        this.nodeMap = new ConcurrentHashMap();
        this.blacklistMap = new ConcurrentHashMap();
        this.eventHandler = eventHandler;
        this.appContext = appContext;
        this.maxTaskFailuresPerNode = maxTaskFailuresPerNode;
        this.nodeBlacklistingEnabled = nodeBlacklistingEnabled;
        this.blacklistDisablePercent = blacklistDisablePercent;
        this.nodeUpdatesRescheduleEnabled = nodeUpdatesRescheduleEnabled;
    }

    public void nodeSeen(NodeId nodeId) {
        if (this.nodeMap.putIfAbsent(nodeId, new AMNodeImpl(nodeId, this.sourceId, this.maxTaskFailuresPerNode, this.eventHandler, this.nodeBlacklistingEnabled, this.nodeUpdatesRescheduleEnabled, this.appContext)) == null) {
            LOG.info("Adding new node {} to nodeTracker {}", (Object)nodeId, (Object)this.sourceId);
        }
    }

    public AMNode get(NodeId nodeId) {
        return this.nodeMap.get(nodeId);
    }

    public int getNumNodes() {
        return this.nodeMap.size();
    }

    public void handle(AMNodeEvent rEvent) {
        NodeId nodeId = rEvent.getNodeId();
        switch ((AMNodeEventType)rEvent.getType()) {
            case N_NODE_COUNT_UPDATED: {
                AMNodeEventNodeCountUpdated event = (AMNodeEventNodeCountUpdated)rEvent;
                this.numClusterNodes = event.getNodeCount();
                LOG.info("Num cluster nodes = " + this.numClusterNodes);
                this.recomputeCurrentIgnoreBlacklistingThreshold();
                this.computeIgnoreBlacklisting();
                break;
            }
            case N_TURNED_UNHEALTHY: 
            case N_TURNED_HEALTHY: {
                AMNode amNode = this.nodeMap.get(nodeId);
                if (amNode == null) {
                    LOG.info("Ignoring RM Health Update for unknown node: " + nodeId);
                    break;
                }
                amNode.handle((Event)rEvent);
                break;
            }
            default: {
                this.nodeMap.get(nodeId).handle((Event)rEvent);
            }
        }
    }

    boolean registerBadNodeAndShouldBlacklist(AMNode amNode) {
        if (this.nodeBlacklistingEnabled) {
            this.addToBlackList(amNode.getNodeId());
            this.computeIgnoreBlacklisting();
            return !this.ignoreBlacklisting;
        }
        return false;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isBlacklistingIgnored() {
        return this.ignoreBlacklisting;
    }

    private void recomputeCurrentIgnoreBlacklistingThreshold() {
        if (this.nodeBlacklistingEnabled && this.blacklistDisablePercent != -1) {
            this.currentIgnoreBlacklistingCountThreshold = (float)this.numClusterNodes * (float)this.blacklistDisablePercent / 100.0f;
        }
    }

    protected void computeIgnoreBlacklisting() {
        boolean stateChanged = false;
        if (!this.nodeBlacklistingEnabled || this.blacklistDisablePercent == -1 || this.blacklistMap.size() == 0) {
            return;
        }
        if ((float)this.blacklistMap.size() >= this.currentIgnoreBlacklistingCountThreshold) {
            if (!this.ignoreBlacklisting) {
                this.ignoreBlacklisting = true;
                LOG.info("Ignore Blacklisting set to true. Known: " + this.numClusterNodes + ", Blacklisted: " + this.blacklistMap.size());
                stateChanged = true;
            }
        } else if (this.ignoreBlacklisting) {
            this.ignoreBlacklisting = false;
            LOG.info("Ignore blacklisting set to false. Known: " + this.numClusterNodes + ", Blacklisted: " + this.blacklistMap.size());
            stateChanged = true;
        }
        if (stateChanged) {
            this.sendIngoreBlacklistingStateToNodes();
        }
    }

    private void addToBlackList(NodeId nodeId) {
        Set<NodeId> nodes;
        String host = nodeId.getHost();
        if (!this.blacklistMap.containsKey(host)) {
            this.blacklistMap.putIfAbsent(host, new HashSet());
        }
        if (!(nodes = this.blacklistMap.get(host)).contains(nodeId)) {
            nodes.add(nodeId);
        }
    }

    private void sendIngoreBlacklistingStateToNodes() {
        AMNodeEventType eventType = this.ignoreBlacklisting ? AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED : AMNodeEventType.N_IGNORE_BLACKLISTING_DISABLED;
        for (NodeId nodeId : this.nodeMap.keySet()) {
            this.sendEvent((Event<?>)new AMNodeEvent(nodeId, this.sourceId, eventType));
        }
    }

    private void sendEvent(Event<?> event) {
        this.eventHandler.handle(event);
    }
}

