/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import java.net.InetSocketAddress;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.serviceplugins.api.ContainerEndReason;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskCommunicator;

public class TaskCommunicatorWrapper {
    private final TaskCommunicator real;

    public TaskCommunicatorWrapper(TaskCommunicator real) {
        this.real = real;
    }

    public void registerRunningContainer(ContainerId containerId, String hostname, int port) throws Exception {
        this.real.registerRunningContainer(containerId, hostname, port);
    }

    public void registerContainerEnd(ContainerId containerId, ContainerEndReason endReason, @Nullable String diagnostics) throws Exception {
        this.real.registerContainerEnd(containerId, endReason, diagnostics);
    }

    public void registerRunningTaskAttempt(ContainerId containerId, TaskSpec taskSpec, Map<String, LocalResource> additionalResources, Credentials credentials, boolean credentialsChanged, int priority) throws Exception {
        this.real.registerRunningTaskAttempt(containerId, taskSpec, additionalResources, credentials, credentialsChanged, priority);
    }

    public void unregisterRunningTaskAttempt(TezTaskAttemptID taskAttemptID, TaskAttemptEndReason endReason, @Nullable String diagnostics) throws Exception {
        this.real.unregisterRunningTaskAttempt(taskAttemptID, endReason, diagnostics);
    }

    public InetSocketAddress getAddress() throws Exception {
        return this.real.getAddress();
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) throws Exception {
        this.real.onVertexStateUpdated(stateUpdate);
    }

    public void dagComplete(int dagIdentifier) throws Exception {
        this.real.dagComplete(dagIdentifier);
    }

    public Object getMetaInfo() throws Exception {
        return this.real.getMetaInfo();
    }

    public TaskCommunicator getTaskCommunicator() {
        return this.real;
    }
}

