/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.serviceplugins.api;

import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskHeartbeatRequest;
import org.apache.tez.serviceplugins.api.TaskHeartbeatResponse;

public interface TaskCommunicatorContext {
    public UserPayload getInitialUserPayload();

    public ApplicationAttemptId getApplicationAttemptId();

    public Credentials getCredentials();

    public boolean canCommit(TezTaskAttemptID var1) throws IOException;

    public TaskHeartbeatResponse heartbeat(TaskHeartbeatRequest var1) throws IOException, TezException;

    public boolean isKnownContainer(ContainerId var1);

    public void taskAlive(TezTaskAttemptID var1);

    public void containerAlive(ContainerId var1);

    public void taskStartedRemotely(TezTaskAttemptID var1, ContainerId var2);

    public void taskKilled(TezTaskAttemptID var1, TaskAttemptEndReason var2, @Nullable String var3);

    public void taskFailed(TezTaskAttemptID var1, TaskAttemptEndReason var2, @Nullable String var3);

    public void registerForVertexStateUpdates(String var1, @Nullable Set<VertexState> var2);

    public String getCurrentDagName();

    public String getCurrentAppIdentifier();

    public int getCurrentDagIdenitifer();

    public Iterable<String> getInputVertexNames(String var1);

    public int getVertexTotalTaskCount(String var1);

    public int getVertexCompletedTaskCount(String var1);

    public int getVertexRunningTaskCount(String var1);

    public long getFirstAttemptStartTime(String var1, int var2);

    public long getDagStartTime();
}

