/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.utils.TezEventUtils;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAttemptFinishedEvent
implements HistoryEvent {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAttemptFinishedEvent.class);
    private TezTaskAttemptID taskAttemptId;
    private String vertexName;
    private long creationTime;
    private long allocationTime;
    private long startTime;
    private long finishTime;
    private TezTaskAttemptID creationCausalTA;
    private TaskAttemptState state;
    private String diagnostics;
    private TezCounters tezCounters;
    private TaskAttemptTerminationCause error;
    private List<TaskAttemptImpl.DataEventDependencyInfo> dataEvents;
    private List<TezEvent> taGeneratedEvents;

    public TaskAttemptFinishedEvent(TezTaskAttemptID taId, String vertexName, long startTime, long finishTime, TaskAttemptState state, TaskAttemptTerminationCause error, String diagnostics, TezCounters counters, List<TaskAttemptImpl.DataEventDependencyInfo> dataEvents, List<TezEvent> taGeneratedEvents, long creationTime, TezTaskAttemptID creationCausalTA, long allocationTime) {
        this.taskAttemptId = taId;
        this.vertexName = vertexName;
        this.creationCausalTA = creationCausalTA;
        this.creationTime = creationTime;
        this.allocationTime = allocationTime;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
        this.error = error;
        this.dataEvents = dataEvents;
        this.taGeneratedEvents = taGeneratedEvents;
    }

    public TaskAttemptFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_FINISHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public List<TaskAttemptImpl.DataEventDependencyInfo> getDataEvents() {
        return this.dataEvents;
    }

    public RecoveryProtos.TaskAttemptFinishedProto toProto() throws IOException {
        RecoveryProtos.TaskAttemptFinishedProto.Builder builder = RecoveryProtos.TaskAttemptFinishedProto.newBuilder();
        builder.setTaskAttemptId(this.taskAttemptId.toString()).setState(this.state.ordinal()).setCreationTime(this.creationTime).setAllocationTime(this.allocationTime).setStartTime(this.startTime).setFinishTime(this.finishTime);
        if (this.creationCausalTA != null) {
            builder.setCreationCausalTA(this.creationCausalTA.toString());
        }
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        if (this.error != null) {
            builder.setErrorEnum(this.error.name());
        }
        if (this.tezCounters != null) {
            builder.setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters));
        }
        if (this.dataEvents != null && !this.dataEvents.isEmpty()) {
            for (TaskAttemptImpl.DataEventDependencyInfo info : this.dataEvents) {
                builder.addDataEvents(TaskAttemptImpl.DataEventDependencyInfo.toProto(info));
            }
        }
        if (this.taGeneratedEvents != null && !this.taGeneratedEvents.isEmpty()) {
            for (TezEvent event : this.taGeneratedEvents) {
                builder.addTaGeneratedEvents(TezEventUtils.toProto(event));
            }
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.TaskAttemptFinishedProto proto) throws IOException {
        this.taskAttemptId = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        this.state = TaskAttemptState.values()[proto.getState()];
        this.creationTime = proto.getCreationTime();
        this.allocationTime = proto.getAllocationTime();
        this.startTime = proto.getStartTime();
        this.finishTime = proto.getFinishTime();
        if (proto.hasCreationCausalTA()) {
            this.creationCausalTA = TezTaskAttemptID.fromString((String)proto.getCreationCausalTA());
        }
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
        if (proto.hasErrorEnum()) {
            this.error = TaskAttemptTerminationCause.valueOf((String)proto.getErrorEnum());
        }
        if (proto.hasCounters()) {
            this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
        }
        if (proto.getDataEventsCount() > 0) {
            this.dataEvents = Lists.newArrayListWithCapacity((int)proto.getDataEventsCount());
            for (RecoveryProtos.DataEventDependencyInfoProto protoEvent : proto.getDataEventsList()) {
                this.dataEvents.add(TaskAttemptImpl.DataEventDependencyInfo.fromProto(protoEvent));
            }
        }
        if (proto.getTaGeneratedEventsCount() > 0) {
            this.taGeneratedEvents = Lists.newArrayListWithCapacity((int)proto.getTaGeneratedEventsCount());
            for (RecoveryProtos.TezEventProto eventProto : proto.getTaGeneratedEventsList()) {
                this.taGeneratedEvents.add(TezEventUtils.fromProto(eventProto));
            }
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskAttemptFinishedProto proto = RecoveryProtos.TaskAttemptFinishedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        String counterStr = "";
        if (this.state != TaskAttemptState.SUCCEEDED) {
            counterStr = ", counters=" + (this.tezCounters == null ? "null" : this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " "));
        }
        return "vertexName=" + this.vertexName + ", taskAttemptId=" + this.taskAttemptId + ", creationTime=" + this.creationTime + ", allocationTime=" + this.allocationTime + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", errorEnum=" + (this.error != null ? this.error.name() : "") + ", diagnostics=" + this.diagnostics + counterStr;
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public TezCounters getCounters() {
        return this.tezCounters;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public TaskAttemptTerminationCause getTaskAttemptError() {
        return this.error;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public TaskAttemptState getState() {
        return this.state;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getAllocationTime() {
        return this.allocationTime;
    }

    public TezTaskAttemptID getCreationCausalTA() {
        return this.creationCausalTA;
    }

    public List<TezEvent> getTAGeneratedEvents() {
        return this.taGeneratedEvents;
    }
}

