/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Queue;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.records.TezVertexID;

public abstract class DAGScheduler {
    Map<TezVertexID, VertexInfo> vertexInfo = null;

    public void addVertexConcurrencyLimit(TezVertexID vId, int concurrency) {
        if (this.vertexInfo == null) {
            this.vertexInfo = Maps.newHashMap();
        }
        if (concurrency > 0) {
            this.vertexInfo.put(vId, new VertexInfo(concurrency));
        }
    }

    public void scheduleTask(DAGEventSchedulerUpdate event) {
        VertexInfo vInfo = null;
        if (this.vertexInfo != null) {
            vInfo = this.vertexInfo.get(event.getAttempt().getID().getTaskID().getVertexID());
        }
        this.scheduleTaskWithLimit(event, vInfo);
    }

    private void scheduleTaskWithLimit(DAGEventSchedulerUpdate event, VertexInfo vInfo) {
        if (vInfo != null) {
            if (vInfo.concurrency >= vInfo.concurrencyLimit) {
                vInfo.pendingAttempts.add(event);
                return;
            }
            ++vInfo.concurrency;
        }
        this.scheduleTaskEx(event);
    }

    public void taskCompleted(DAGEventSchedulerUpdate event) {
        VertexInfo vInfo;
        this.taskCompletedEx(event);
        if (this.vertexInfo != null && (vInfo = this.vertexInfo.get(event.getAttempt().getID().getTaskID().getVertexID())) != null) {
            --vInfo.concurrency;
            if (!vInfo.pendingAttempts.isEmpty()) {
                this.scheduleTaskWithLimit(vInfo.pendingAttempts.poll(), vInfo);
            }
        }
    }

    public abstract void scheduleTaskEx(DAGEventSchedulerUpdate var1);

    public abstract void taskCompletedEx(DAGEventSchedulerUpdate var1);

    private static class VertexInfo {
        int concurrencyLimit;
        int concurrency;
        Queue<DAGEventSchedulerUpdate> pendingAttempts = Lists.newLinkedList();

        VertexInfo(int limit) {
            this.concurrencyLimit = limit;
        }
    }
}

