/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;
import org.apache.tez.serviceplugins.api.TaskScheduler;
import org.apache.tez.serviceplugins.api.TaskSchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTaskSchedulerService
extends TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTaskSchedulerService.class);
    final ContainerSignatureMatcher containerSignatureMatcher;
    final PriorityBlockingQueue<TaskRequest> taskRequestQueue = new PriorityBlockingQueue();
    final Configuration conf;
    AsyncDelegateRequestHandler taskRequestHandler;
    Thread asyncDelegateRequestThread;
    final HashMap<Object, Container> taskAllocations = new LinkedHashMap<Object, Container>();
    final String appTrackingUrl;
    final long customContainerAppId;

    public LocalTaskSchedulerService(TaskSchedulerContext taskSchedulerContext) {
        super(taskSchedulerContext);
        this.appTrackingUrl = taskSchedulerContext.getAppTrackingUrl();
        this.containerSignatureMatcher = taskSchedulerContext.getContainerSignatureMatcher();
        this.customContainerAppId = taskSchedulerContext.getCustomClusterIdentifier();
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)taskSchedulerContext.getInitialUserPayload());
        }
        catch (IOException e) {
            throw new TezUncheckedException("Failed to deserialize payload for " + LocalTaskSchedulerService.class.getSimpleName(), (Throwable)e);
        }
    }

    public Resource getAvailableResources() {
        long memory = Runtime.getRuntime().freeMemory();
        int cores = Runtime.getRuntime().availableProcessors();
        return LocalTaskSchedulerService.createResource(memory, cores);
    }

    static Resource createResource(long runtimeMemory, int core) {
        if (runtimeMemory < 0L || core < 0) {
            throw new IllegalArgumentException("Negative Memory or Core provided!mem: " + runtimeMemory + " core:" + core);
        }
        return Resource.newInstance((int)Ints.checkedCast((long)(runtimeMemory / 0x100000L)), (int)core);
    }

    public int getClusterNodeCount() {
        return 1;
    }

    public void dagComplete() {
    }

    public Resource getTotalResources() {
        long memory = Runtime.getRuntime().maxMemory();
        int cores = Runtime.getRuntime().availableProcessors();
        return LocalTaskSchedulerService.createResource(memory, cores);
    }

    public void blacklistNode(NodeId nodeId) {
    }

    public void unblacklistNode(NodeId nodeId) {
    }

    public void allocateTask(Object task, Resource capability, String[] hosts, String[] racks, Priority priority, Object containerSignature, Object clientCookie) {
        this.taskRequestHandler.addAllocateTaskRequest(task, capability, priority, clientCookie);
    }

    public synchronized void allocateTask(Object task, Resource capability, ContainerId containerId, Priority priority, Object containerSignature, Object clientCookie) {
        this.taskRequestHandler.addAllocateTaskRequest(task, capability, priority, clientCookie);
    }

    public boolean deallocateTask(Object task, boolean taskSucceeded, TaskAttemptEndReason endReason, String diagnostics) {
        return this.taskRequestHandler.addDeallocateTaskRequest(task);
    }

    public Object deallocateContainer(ContainerId containerId) {
        return null;
    }

    public void initialize() {
        this.taskRequestHandler = this.createRequestHandler(this.conf);
        this.asyncDelegateRequestThread = new Thread(this.taskRequestHandler);
        this.asyncDelegateRequestThread.setDaemon(true);
    }

    protected AsyncDelegateRequestHandler createRequestHandler(Configuration conf) {
        return new AsyncDelegateRequestHandler(this.taskRequestQueue, new LocalContainerFactory(this.getContext().getApplicationAttemptId(), this.customContainerAppId), this.taskAllocations, this.getContext(), conf);
    }

    public void start() {
        this.asyncDelegateRequestThread.start();
    }

    public void shutdown() throws InterruptedException {
        if (this.asyncDelegateRequestThread != null) {
            this.asyncDelegateRequestThread.interrupt();
        }
    }

    public void setShouldUnregister() {
    }

    public boolean hasUnregistered() {
        return true;
    }

    public void initiateStop() {
    }

    static class AsyncDelegateRequestHandler
    implements Runnable {
        final BlockingQueue<TaskRequest> taskRequestQueue;
        final LocalContainerFactory localContainerFactory;
        final HashMap<Object, Container> taskAllocations;
        final TaskSchedulerContext taskSchedulerContext;
        final int MAX_TASKS;

        AsyncDelegateRequestHandler(BlockingQueue<TaskRequest> taskRequestQueue, LocalContainerFactory localContainerFactory, HashMap<Object, Container> taskAllocations, TaskSchedulerContext taskSchedulerContext, Configuration conf) {
            this.taskRequestQueue = taskRequestQueue;
            this.localContainerFactory = localContainerFactory;
            this.taskAllocations = taskAllocations;
            this.taskSchedulerContext = taskSchedulerContext;
            this.MAX_TASKS = conf.getInt("tez.am.inline.task.execution.max-tasks", 1);
        }

        public void addAllocateTaskRequest(Object task, Resource capability, Priority priority, Object clientCookie) {
            try {
                this.taskRequestQueue.put(new AllocateTaskRequest(task, capability, priority, clientCookie));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addDeallocateTaskRequest(Object task) {
            try {
                this.taskRequestQueue.put(new DeallocateTaskRequest(task));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            BlockingQueue<TaskRequest> blockingQueue = this.taskRequestQueue;
            synchronized (blockingQueue) {
                this.taskRequestQueue.notify();
            }
            return true;
        }

        boolean shouldWait() {
            return this.taskAllocations.size() >= this.MAX_TASKS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                BlockingQueue<TaskRequest> blockingQueue = this.taskRequestQueue;
                synchronized (blockingQueue) {
                    try {
                        if (this.shouldWait()) {
                            this.taskRequestQueue.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.processRequest();
            }
        }

        void processRequest() {
            try {
                TaskRequest request = this.taskRequestQueue.take();
                if (request instanceof AllocateTaskRequest) {
                    this.allocateTask((AllocateTaskRequest)request);
                } else if (request instanceof DeallocateTaskRequest) {
                    this.deallocateTask((DeallocateTaskRequest)request);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (NullPointerException e) {
                LOG.warn("Task request was badly constructed");
            }
        }

        void allocateTask(AllocateTaskRequest request) {
            Container container = this.localContainerFactory.createContainer(request.capability, request.priority);
            this.taskAllocations.put(request.task, container);
            this.taskSchedulerContext.taskAllocated(request.task, request.clientCookie, container);
        }

        void deallocateTask(DeallocateTaskRequest request) {
            Container container = this.taskAllocations.remove(request.task);
            if (container != null) {
                this.taskSchedulerContext.containerBeingReleased(container.getId());
            } else {
                boolean deallocationBeforeAllocation = false;
                Iterator iter = this.taskRequestQueue.iterator();
                while (iter.hasNext()) {
                    TaskRequest taskRequest = (TaskRequest)iter.next();
                    if (!(taskRequest instanceof AllocateTaskRequest) || !taskRequest.task.equals(request.task)) continue;
                    iter.remove();
                    deallocationBeforeAllocation = true;
                    LOG.info("deallcation happen before allocation for task:" + request.task);
                    break;
                }
                if (!deallocationBeforeAllocation) {
                    throw new TezUncheckedException("Unable to find and remove task " + request.task + " from task allocations");
                }
            }
        }
    }

    static class DeallocateTaskRequest
    extends TaskRequest {
        static final Priority DEALLOCATE_PRIORITY = Priority.newInstance((int)-2);

        public DeallocateTaskRequest(Object task) {
            super(task, DEALLOCATE_PRIORITY);
        }
    }

    static class AllocateTaskRequest
    extends TaskRequest {
        Resource capability;
        Object clientCookie;

        public AllocateTaskRequest(Object task, Resource capability, Priority priority, Object clientCookie) {
            super(task, priority);
            this.capability = capability;
            this.clientCookie = clientCookie;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AllocateTaskRequest that = (AllocateTaskRequest)o;
            if (this.capability != null ? !this.capability.equals((Object)that.capability) : that.capability != null) {
                return false;
            }
            return !(this.clientCookie != null ? !this.clientCookie.equals(that.clientCookie) : that.clientCookie != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 12329 * result + (this.capability != null ? this.capability.hashCode() : 0);
            result = 12329 * result + (this.clientCookie != null ? this.clientCookie.hashCode() : 0);
            return result;
        }
    }

    static class TaskRequest
    implements Comparable<TaskRequest> {
        static final int HIGHEST_PRIORITY = -2;
        Object task;
        Priority priority;

        public TaskRequest(Object task, Priority priority) {
            this.task = task;
            this.priority = priority;
        }

        @Override
        public int compareTo(TaskRequest request) {
            return request.priority.compareTo(this.priority);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskRequest that = (TaskRequest)o;
            if (this.priority != null ? !this.priority.equals((Object)that.priority) : that.priority != null) {
                return false;
            }
            return !(this.task != null ? !this.task.equals(that.task) : that.task != null);
        }

        public int hashCode() {
            int result = 1;
            result = 7841 * result + (this.task != null ? this.task.hashCode() : 0);
            result = 7841 * result + (this.priority != null ? this.priority.hashCode() : 0);
            return result;
        }
    }

    static class LocalContainerFactory {
        AtomicInteger nextId = new AtomicInteger(1);
        final ApplicationAttemptId customAppAttemptId;

        public LocalContainerFactory(ApplicationAttemptId appAttemptId, long customAppId) {
            ApplicationId appId = ApplicationId.newInstance((long)customAppId, (int)appAttemptId.getApplicationId().getId());
            this.customAppAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)appAttemptId.getAttemptId());
        }

        public Container createContainer(Resource capability, Priority priority) {
            ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)this.customAppAttemptId, (int)this.nextId.getAndIncrement());
            NodeId nodeId = NodeId.newInstance((String)"127.0.0.1", (int)0);
            String nodeHttpAddress = "127.0.0.1:0";
            Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)nodeHttpAddress, (Resource)capability, (Priority)priority, null);
            return container;
        }
    }
}

