/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerLauncherContextImpl;
import org.apache.tez.dag.app.ServicePluginLifecycleAbstractService;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.launcher.LocalContainerLauncher;
import org.apache.tez.dag.app.launcher.TezContainerLauncherImpl;
import org.apache.tez.dag.app.rm.ContainerLauncherEvent;
import org.apache.tez.dag.app.rm.ContainerLauncherEventType;
import org.apache.tez.dag.app.rm.ContainerLauncherLaunchRequestEvent;
import org.apache.tez.serviceplugins.api.ContainerLaunchRequest;
import org.apache.tez.serviceplugins.api.ContainerLauncher;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;
import org.apache.tez.serviceplugins.api.ContainerStopRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLauncherManager
extends AbstractService
implements EventHandler<ContainerLauncherEvent> {
    static final Logger LOG = LoggerFactory.getLogger(TezContainerLauncherImpl.class);
    @VisibleForTesting
    final ContainerLauncher[] containerLaunchers;
    @VisibleForTesting
    final ContainerLauncherContext[] containerLauncherContexts;
    protected final ServicePluginLifecycleAbstractService[] containerLauncherServiceWrappers;
    private final AppContext appContext;

    @VisibleForTesting
    public ContainerLauncherManager(ContainerLauncher containerLauncher, AppContext context) {
        super(ContainerLauncherManager.class.getName());
        this.appContext = context;
        this.containerLaunchers = new ContainerLauncher[]{containerLauncher};
        this.containerLauncherContexts = new ContainerLauncherContext[]{containerLauncher.getContext()};
        this.containerLauncherServiceWrappers = new ServicePluginLifecycleAbstractService[]{new ServicePluginLifecycleAbstractService<ContainerLauncher>(containerLauncher)};
    }

    public ContainerLauncherManager(AppContext context, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, List<NamedEntityDescriptor> containerLauncherDescriptors, boolean isPureLocalMode) {
        super(ContainerLauncherManager.class.getName());
        this.appContext = context;
        Preconditions.checkArgument((containerLauncherDescriptors != null && !containerLauncherDescriptors.isEmpty() ? 1 : 0) != 0, (Object)"ContainerLauncherDescriptors must be specified");
        this.containerLauncherContexts = new ContainerLauncherContext[containerLauncherDescriptors.size()];
        this.containerLaunchers = new ContainerLauncher[containerLauncherDescriptors.size()];
        this.containerLauncherServiceWrappers = new ServicePluginLifecycleAbstractService[containerLauncherDescriptors.size()];
        for (int i = 0; i < containerLauncherDescriptors.size(); ++i) {
            UserPayload userPayload = containerLauncherDescriptors.get(i).getUserPayload();
            ContainerLauncherContextImpl containerLauncherContext = new ContainerLauncherContextImpl(context, taskCommunicatorManagerInterface, userPayload);
            this.containerLauncherContexts[i] = containerLauncherContext;
            this.containerLaunchers[i] = this.createContainerLauncher(containerLauncherDescriptors.get(i), context, containerLauncherContext, taskCommunicatorManagerInterface, workingDirectory, i, isPureLocalMode);
            this.containerLauncherServiceWrappers[i] = new ServicePluginLifecycleAbstractService<ContainerLauncher>(this.containerLaunchers[i]);
        }
    }

    @VisibleForTesting
    ContainerLauncher createContainerLauncher(NamedEntityDescriptor containerLauncherDescriptor, AppContext context, ContainerLauncherContext containerLauncherContext, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, int containerLauncherIndex, boolean isPureLocalMode) {
        if (containerLauncherDescriptor.getEntityName().equals(TezConstants.getTezYarnServicePluginName())) {
            return this.createYarnContainerLauncher(containerLauncherContext);
        }
        if (containerLauncherDescriptor.getEntityName().equals(TezConstants.getTezUberServicePluginName())) {
            return this.createUberContainerLauncher(containerLauncherContext, context, taskCommunicatorManagerInterface, workingDirectory, isPureLocalMode);
        }
        return this.createCustomContainerLauncher(containerLauncherContext, containerLauncherDescriptor);
    }

    @VisibleForTesting
    ContainerLauncher createYarnContainerLauncher(ContainerLauncherContext containerLauncherContext) {
        LOG.info("Creating DefaultContainerLauncher");
        return new TezContainerLauncherImpl(containerLauncherContext);
    }

    @VisibleForTesting
    ContainerLauncher createUberContainerLauncher(ContainerLauncherContext containerLauncherContext, AppContext context, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, boolean isPureLocalMode) {
        LOG.info("Creating LocalContainerLauncher");
        try {
            return new LocalContainerLauncher(containerLauncherContext, context, taskCommunicatorManagerInterface, workingDirectory, isPureLocalMode);
        }
        catch (UnknownHostException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    @VisibleForTesting
    ContainerLauncher createCustomContainerLauncher(ContainerLauncherContext containerLauncherContext, NamedEntityDescriptor containerLauncherDescriptor) {
        LOG.info("Creating container launcher {}:{} ", (Object)containerLauncherDescriptor.getEntityName(), (Object)containerLauncherDescriptor.getClassName());
        Class containerLauncherClazz = ReflectionUtils.getClazz((String)containerLauncherDescriptor.getClassName());
        try {
            Constructor ctor = containerLauncherClazz.getConstructor(ContainerLauncherContext.class);
            return (ContainerLauncher)ctor.newInstance(containerLauncherContext);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    public void serviceInit(Configuration conf) {
        for (int i = 0; i < this.containerLaunchers.length; ++i) {
            this.containerLauncherServiceWrappers[i].init(conf);
        }
    }

    public void serviceStart() {
        for (int i = 0; i < this.containerLaunchers.length; ++i) {
            this.containerLauncherServiceWrappers[i].start();
        }
    }

    public void serviceStop() {
        for (int i = 0; i < this.containerLaunchers.length; ++i) {
            this.containerLauncherServiceWrappers[i].stop();
        }
    }

    public void dagComplete(DAG dag) {
    }

    public void dagSubmitted() {
    }

    public void handle(ContainerLauncherEvent event) {
        int launcherId = event.getLauncherId();
        String schedulerName = this.appContext.getTaskSchedulerName(event.getSchedulerId());
        String taskCommName = this.appContext.getTaskCommunicatorName(event.getTaskCommId());
        switch ((ContainerLauncherEventType)event.getType()) {
            case CONTAINER_LAUNCH_REQUEST: {
                ContainerLauncherLaunchRequestEvent launchEvent = (ContainerLauncherLaunchRequestEvent)event;
                ContainerLaunchRequest launchRequest = new ContainerLaunchRequest(launchEvent.getNodeId(), launchEvent.getContainerId(), launchEvent.getContainerToken(), launchEvent.getContainerLaunchContext(), launchEvent.getContainer(), schedulerName, taskCommName);
                this.containerLaunchers[launcherId].launchContainer(launchRequest);
                break;
            }
            case CONTAINER_STOP_REQUEST: {
                ContainerStopRequest stopRequest = new ContainerStopRequest(event.getNodeId(), event.getContainerId(), event.getContainerToken(), schedulerName, taskCommName);
                this.containerLaunchers[launcherId].stopContainer(stopRequest);
            }
        }
    }
}

