/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventCompleted;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunchFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventLaunched;
import org.apache.tez.dag.app.rm.container.AMContainerEventStopFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;
import org.apache.tez.serviceplugins.api.TaskAttemptEndReason;

public class ContainerLauncherContextImpl
implements ContainerLauncherContext {
    private final AppContext context;
    private final TaskCommunicatorManagerInterface tal;
    private final UserPayload initialUserPayload;

    public ContainerLauncherContextImpl(AppContext appContext, TaskCommunicatorManagerInterface tal, UserPayload initialUserPayload) {
        this.context = appContext;
        this.tal = tal;
        this.initialUserPayload = initialUserPayload;
    }

    public void containerLaunched(ContainerId containerId) {
        this.context.getEventHandler().handle((Event)new AMContainerEventLaunched(containerId));
        ContainerLaunchedEvent lEvt = new ContainerLaunchedEvent(containerId, this.context.getClock().getTime(), this.context.getApplicationAttemptId());
        this.context.getHistoryHandler().handle(new DAGHistoryEvent(null, lEvt));
    }

    public void containerLaunchFailed(ContainerId containerId, String diagnostics) {
        this.context.getEventHandler().handle((Event)new AMContainerEventLaunchFailed(containerId, diagnostics));
    }

    public void containerStopRequested(ContainerId containerId) {
        this.context.getEventHandler().handle((Event)new AMContainerEvent(containerId, AMContainerEventType.C_NM_STOP_SENT));
    }

    public void containerStopFailed(ContainerId containerId, String diagnostics) {
        this.context.getEventHandler().handle((Event)new AMContainerEventStopFailed(containerId, diagnostics));
    }

    public void containerCompleted(ContainerId containerId, int exitStatus, String diagnostics, TaskAttemptEndReason endReason) {
        this.context.getEventHandler().handle((Event)new AMContainerEventCompleted(containerId, exitStatus, diagnostics, TezUtilsInternal.fromTaskAttemptEndReason((TaskAttemptEndReason)endReason)));
    }

    public UserPayload getInitialUserPayload() {
        return this.initialUserPayload;
    }

    public int getNumNodes(String sourceName) {
        int sourceIndex = this.context.getTaskScheduerIdentifier(sourceName);
        int numNodes = this.context.getNodeTracker().getNumNodes(sourceIndex);
        return numNodes;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.context.getApplicationAttemptId();
    }

    public Object getTaskCommunicatorMetaInfo(String taskCommName) {
        int taskCommId = this.context.getTaskCommunicatorIdentifier(taskCommName);
        return this.tal.getTaskCommunicator(taskCommId).getMetaInfo();
    }
}

