/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.InputSpecUpdate;

public class VertexParallelismUpdatedEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private int numTasks;
    private int oldNumTasks;
    private VertexLocationHint vertexLocationHint;
    private Map<String, EdgeProperty> sourceEdgeProperties;
    private Map<String, InputSpecUpdate> rootInputSpecUpdates;
    private long updateTime;

    public VertexParallelismUpdatedEvent() {
    }

    public VertexParallelismUpdatedEvent(TezVertexID vertexID, int numTasks, VertexLocationHint vertexLocationHint, Map<String, EdgeProperty> sourceEdgeProperties, Map<String, InputSpecUpdate> rootInputSpecUpdates, int oldNumTasks) {
        this.vertexID = vertexID;
        this.numTasks = numTasks;
        this.vertexLocationHint = vertexLocationHint;
        this.sourceEdgeProperties = sourceEdgeProperties;
        this.rootInputSpecUpdates = rootInputSpecUpdates;
        this.updateTime = System.currentTimeMillis();
        this.oldNumTasks = oldNumTasks;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_PARALLELISM_UPDATED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexParallelismUpdatedProto toProto() {
        RecoveryProtos.VertexParallelismUpdatedProto.Builder builder = RecoveryProtos.VertexParallelismUpdatedProto.newBuilder();
        builder.setVertexId(this.vertexID.toString()).setNumTasks(this.numTasks);
        if (this.vertexLocationHint != null) {
            builder.setVertexLocationHint(DagTypeConverters.convertVertexLocationHintToProto((VertexLocationHint)this.vertexLocationHint));
        }
        if (this.sourceEdgeProperties != null) {
            for (Map.Entry<String, EdgeProperty> entry : this.sourceEdgeProperties.entrySet()) {
                RecoveryProtos.EdgeManagerDescriptorProto.Builder edgeMgrBuilder = RecoveryProtos.EdgeManagerDescriptorProto.newBuilder();
                edgeMgrBuilder.setEdgeName(entry.getKey());
                edgeMgrBuilder.setEdgeProperty(DagTypeConverters.convertToProto((EdgeProperty)entry.getValue()));
                builder.addEdgeManagerDescriptors(edgeMgrBuilder.build());
            }
        }
        if (this.rootInputSpecUpdates != null) {
            for (Map.Entry<String, EdgeProperty> entry : this.rootInputSpecUpdates.entrySet()) {
                RecoveryProtos.RootInputSpecUpdateProto.Builder rootInputSpecUpdateBuilder = RecoveryProtos.RootInputSpecUpdateProto.newBuilder();
                rootInputSpecUpdateBuilder.setInputName(entry.getKey());
                rootInputSpecUpdateBuilder.setForAllWorkUnits(((InputSpecUpdate)entry.getValue()).isForAllWorkUnits());
                rootInputSpecUpdateBuilder.addAllNumPhysicalInputs(((InputSpecUpdate)entry.getValue()).getAllNumPhysicalInputs());
                builder.addRootInputSpecUpdates(rootInputSpecUpdateBuilder.build());
            }
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.VertexParallelismUpdatedProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.numTasks = proto.getNumTasks();
        if (proto.hasVertexLocationHint()) {
            this.vertexLocationHint = DagTypeConverters.convertVertexLocationHintFromProto((DAGProtos.VertexLocationHintProto)proto.getVertexLocationHint());
        }
        if (proto.getEdgeManagerDescriptorsCount() > 0) {
            this.sourceEdgeProperties = new HashMap<String, EdgeProperty>(proto.getEdgeManagerDescriptorsCount());
            for (RecoveryProtos.EdgeManagerDescriptorProto edgeManagerProto : proto.getEdgeManagerDescriptorsList()) {
                EdgeProperty edgeProperty = DagTypeConverters.convertFromProto((DAGProtos.PlanEdgeProperty)edgeManagerProto.getEdgeProperty());
                this.sourceEdgeProperties.put(edgeManagerProto.getEdgeName(), edgeProperty);
            }
        }
        if (proto.getRootInputSpecUpdatesCount() > 0) {
            this.rootInputSpecUpdates = Maps.newHashMap();
            for (RecoveryProtos.RootInputSpecUpdateProto rootInputSpecUpdateProto : proto.getRootInputSpecUpdatesList()) {
                InputSpecUpdate specUpdate = rootInputSpecUpdateProto.getForAllWorkUnits() ? InputSpecUpdate.createAllTaskInputSpecUpdate((int)rootInputSpecUpdateProto.getNumPhysicalInputs(0)) : InputSpecUpdate.createPerTaskInputSpecUpdate(rootInputSpecUpdateProto.getNumPhysicalInputsList());
                this.rootInputSpecUpdates.put(rootInputSpecUpdateProto.getInputName(), specUpdate);
            }
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.VertexParallelismUpdatedProto proto = RecoveryProtos.VertexParallelismUpdatedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID + ", numTasks=" + this.numTasks + ", vertexLocationHint=" + (this.vertexLocationHint == null ? "null" : this.vertexLocationHint) + ", edgeManagersCount=" + (this.sourceEdgeProperties == null ? "null" : this.sourceEdgeProperties.size() + ", rootInputSpecUpdateCount=" + (this.rootInputSpecUpdates == null ? "null" : Integer.valueOf(this.rootInputSpecUpdates.size())));
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public VertexLocationHint getVertexLocationHint() {
        return this.vertexLocationHint;
    }

    public Map<String, EdgeProperty> getSourceEdgeProperties() {
        return this.sourceEdgeProperties;
    }

    public Map<String, InputSpecUpdate> getRootInputSpecUpdates() {
        return this.rootInputSpecUpdates;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public int getOldNumTasks() {
        return this.oldNumTasks;
    }
}

