/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.web;

import com.google.common.base.Preconditions;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.web.AMWebController;

public class WebUIService
extends AbstractService {
    private static final String WS_PREFIX = "/ui/ws/v1/tez/";
    public static final String VERTEX_ID = "vertexID";
    public static final String DAG_ID = "dagID";
    private static final Log LOG = LogFactory.getLog(WebUIService.class);
    private final AppContext context;
    private TezAMWebApp tezAMWebApp;
    private WebApp webApp;
    private String trackingUrl = "";
    private String historyUrl = "";

    public WebUIService(AppContext context) {
        super(WebUIService.class.getName());
        this.context = context;
        this.tezAMWebApp = new TezAMWebApp(context);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        Configuration config = new Configuration(conf);
        if (this.historyUrl == null || this.historyUrl.isEmpty()) {
            LOG.error((Object)"Tez UI History URL is not set");
        } else {
            LOG.info((Object)("Tez UI History URL: " + this.historyUrl));
        }
        if (this.tezAMWebApp != null) {
            this.tezAMWebApp.setHistoryUrl(this.historyUrl);
        }
        super.serviceInit(config);
    }

    protected void serviceStart() throws Exception {
        if (this.tezAMWebApp != null) {
            Configuration conf = this.getConfig();
            conf.set("hadoop.http.filter.initializers", "org.apache.hadoop.yarn.server.webproxy.amfilter.AmFilterInitializer");
            try {
                conf.set("yarn.http.policy", "HTTP_ONLY");
                this.webApp = WebApps.$for((Object)((Object)this.tezAMWebApp)).with(conf).start((WebApp)this.tezAMWebApp);
                InetSocketAddress address = this.webApp.getListenerAddress();
                if (address != null) {
                    InetSocketAddress bindAddress = NetUtils.createSocketAddrForHost((String)this.context.getAppMaster().getAppNMHost(), (int)address.getPort());
                    this.trackingUrl = "http://" + bindAddress.getAddress().getCanonicalHostName() + ":" + bindAddress.getPort() + "/ui/";
                    LOG.info((Object)("Instantiated WebUIService at " + this.trackingUrl));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Tez UI WebService failed to start.", (Throwable)e);
                throw new TezUncheckedException((Throwable)e);
            }
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Stopping WebApp");
            }
            this.webApp.stop();
        }
        super.serviceStop();
    }

    public String getTrackingURL() {
        return this.trackingUrl;
    }

    public String getHistoryUrl() {
        return this.historyUrl;
    }

    public void setHistoryUrl(String historyUrl) {
        this.historyUrl = historyUrl;
    }

    private static class TezAMWebApp
    extends WebApp
    implements YarnWebParams {
        private String historyUrl;
        AppContext context;

        public TezAMWebApp(AppContext context) {
            this.context = context;
        }

        public void setHistoryUrl(String historyUrl) {
            this.historyUrl = historyUrl;
        }

        public void setup() {
            Preconditions.checkArgument((this.historyUrl != null ? 1 : 0) != 0);
            this.bind(AppContext.class).toInstance((Object)this.context);
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"TezUIHistoryURL")).toInstance((Object)this.historyUrl);
            this.route("/", AMWebController.class, "ui");
            this.route("/ui", AMWebController.class, "ui");
            this.route("/main", AMWebController.class, "main");
            this.route("/ui/ws/v1/tez/about", AMWebController.class, "about");
            this.route(WebUIService.WS_PREFIX + StringHelper.pajoin((Object[])new Object[]{"dagProgress", WebUIService.DAG_ID}), AMWebController.class, "getDagProgress");
            this.route(WebUIService.WS_PREFIX + StringHelper.pajoin((Object[])new Object[]{"vertexProgress", WebUIService.VERTEX_ID}), AMWebController.class, "getVertexProgress");
            this.route(WebUIService.WS_PREFIX + StringHelper.pajoin((Object[])new Object[]{"vertexProgresses", WebUIService.VERTEX_ID, WebUIService.DAG_ID}), AMWebController.class, "getVertexProgresses");
        }
    }
}

