/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.TaskStateUpdateListener;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexStateUpdateListener;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;

@InterfaceAudience.Private
public class StateChangeNotifier {
    private final DAG dag;
    private final SetMultimap<TezVertexID, ListenerContainer> vertexListeners;
    private final ListMultimap<TezVertexID, VertexStateUpdate> lastKnowStatesMap;
    private final ReentrantReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.listenersLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.listenersLock.writeLock();
    private final SetMultimap<TezVertexID, TaskStateUpdateListener> taskListeners = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final ReentrantReadWriteLock taskListenerLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock taskReadLock = this.taskListenerLock.readLock();
    private final ReentrantReadWriteLock.WriteLock taskWriteLock = this.taskListenerLock.writeLock();

    public StateChangeNotifier(DAG dag) {
        this.dag = dag;
        this.vertexListeners = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
        this.lastKnowStatesMap = LinkedListMultimap.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForVertexUpdates(String vertexName, Set<VertexState> stateSet, VertexStateUpdateListener listener) {
        block6: {
            TezVertexID vertexId = this.validateAndGetVertexId(vertexName);
            this.writeLock.lock();
            List previousUpdates = this.lastKnowStatesMap.get((Object)vertexId);
            try {
                ListenerContainer listenerContainer = new ListenerContainer(listener, stateSet);
                Set listenerContainers = this.vertexListeners.get((Object)vertexId);
                if (listenerContainers == null || !listenerContainers.contains(listenerContainer)) {
                    this.vertexListeners.put((Object)vertexId, (Object)listenerContainer);
                    if (previousUpdates != null && !previousUpdates.isEmpty()) {
                        for (VertexStateUpdate update : previousUpdates) {
                            listenerContainer.sendStateUpdate(update);
                        }
                    }
                    break block6;
                }
                throw new TezUncheckedException("Only allowed to register once for a listener. CurrentContext: vertexName=" + vertexName + ", Listener: " + listener);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForVertexUpdates(String vertexName, VertexStateUpdateListener listener) {
        TezVertexID vertexId = this.validateAndGetVertexId(vertexName);
        this.writeLock.lock();
        try {
            ListenerContainer listenerContainer = new ListenerContainer(listener, null);
            this.vertexListeners.remove((Object)vertexId, (Object)listenerContainer);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(TezVertexID vertexId, VertexStateUpdate vertexStateUpdate) {
        this.readLock.lock();
        try {
            this.lastKnowStatesMap.put((Object)vertexId, (Object)vertexStateUpdate);
            if (this.vertexListeners.containsKey((Object)vertexId)) {
                this.sendStateUpdate(vertexId, vertexStateUpdate);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void sendStateUpdate(TezVertexID vertexId, VertexStateUpdate event) {
        for (ListenerContainer listenerContainer : this.vertexListeners.get((Object)vertexId)) {
            listenerContainer.sendStateUpdate(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForTaskSuccessUpdates(String vertexName, TaskStateUpdateListener listener) {
        TezVertexID vertexId = this.validateAndGetVertexId(vertexName);
        Preconditions.checkNotNull((Object)listener, (Object)"listener cannot be null");
        this.taskWriteLock.lock();
        try {
            this.taskListeners.put((Object)vertexId, (Object)listener);
        }
        finally {
            this.taskWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForTaskSuccessUpdates(String vertexName, TaskStateUpdateListener listener) {
        TezVertexID vertexId = this.validateAndGetVertexId(vertexName);
        Preconditions.checkNotNull((Object)listener, (Object)"listener cannot be null");
        this.taskWriteLock.lock();
        try {
            this.taskListeners.remove((Object)vertexId, (Object)listener);
        }
        finally {
            this.taskWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskSucceeded(String vertexName, TezTaskID taskId, int attemptId) {
        this.taskReadLock.lock();
        try {
            for (TaskStateUpdateListener listener : this.taskListeners.get((Object)taskId.getVertexID())) {
                listener.onTaskSucceeded(vertexName, taskId, attemptId);
            }
        }
        finally {
            this.taskReadLock.unlock();
        }
    }

    private TezVertexID validateAndGetVertexId(String vertexName) {
        Preconditions.checkNotNull((Object)vertexName, (Object)"VertexName cannot be null");
        Vertex vertex = this.dag.getVertex(vertexName);
        Preconditions.checkNotNull((Object)vertex, (Object)("Vertex does not exist: " + vertexName));
        return vertex.getVertexId();
    }

    private static final class ListenerContainer {
        final VertexStateUpdateListener listener;
        final Set<VertexState> states;

        private ListenerContainer(VertexStateUpdateListener listener, Set<VertexState> states) {
            this.listener = listener;
            this.states = states == null ? EnumSet.allOf(VertexState.class) : states;
        }

        private void sendStateUpdate(VertexStateUpdate stateUpdate) {
            if (this.states.contains(stateUpdate.getVertexState())) {
                this.listener.onStateUpdated(stateUpdate);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListenerContainer that = (ListenerContainer)o;
            return this.listener == that.listener;
        }

        public int hashCode() {
            return System.identityHashCode(this.listener);
        }
    }
}

