/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.tez.common.counters.AbstractCounters;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskReport;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.TaskStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventDiagnosticsUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventKillRequest;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventRecoverTask;
import org.apache.tez.dag.app.dag.event.TaskEventTAUpdate;
import org.apache.tez.dag.app.dag.event.TaskEventTermination;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEventTaskAttemptCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskReschedule;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.TaskReportImpl;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.node.AMNodeEventTaskAttemptEnded;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.OutputCommitter;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.state.OnStateChangedCallback;
import org.apache.tez.state.StateMachineTez;

public class TaskImpl
implements Task,
EventHandler<TaskEvent> {
    private static final Log LOG = LogFactory.getLog(TaskImpl.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected final Configuration conf;
    protected final TaskAttemptListener taskAttemptListener;
    protected final TaskHeartbeatHandler taskHeartbeatHandler;
    protected final EventHandler eventHandler;
    private final TezTaskID taskId;
    private Map<TezTaskAttemptID, TaskAttempt> attempts;
    protected final int maxFailedAttempts;
    protected final Clock clock;
    private final Lock readLock;
    private final Lock writeLock;
    private final List<String> diagnostics = new ArrayList<String>();
    private TezCounters counters = new TezCounters();
    protected final AppContext appContext;
    private final Resource taskResource;
    private final ContainerContext containerContext;
    @VisibleForTesting
    long scheduledTime;
    final StateChangeNotifier stateChangeNotifier;
    private final List<TezEvent> tezEventsForTaskAttempts = new ArrayList<TezEvent>();
    private static final List<TezEvent> EMPTY_TASK_ATTEMPT_TEZ_EVENTS = new ArrayList<TezEvent>(0);
    private final Map<Integer, Boolean> taskAttemptStatus = new HashMap<Integer, Boolean>();
    private boolean historyTaskStartGenerated = false;
    private static final SingleArcTransition<TaskImpl, TaskEvent> ATTEMPT_KILLED_TRANSITION = new AttemptKilledTransition();
    private static final SingleArcTransition<TaskImpl, TaskEvent> KILL_TRANSITION = new KillTransition();
    boolean recoveryStartEventSeen = false;
    private static final TaskStateChangedCallback STATE_CHANGED_CALLBACK = new TaskStateChangedCallback();
    private static final StateMachineFactory<TaskImpl, TaskStateInternal, TaskEventType, TaskEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskStateInternal.NEW).addTransition((Enum)TaskStateInternal.NEW, (Enum)TaskStateInternal.SCHEDULED, (Enum)TaskEventType.T_SCHEDULE, (SingleArcTransition)new InitialScheduleTransition()).addTransition((Enum)TaskStateInternal.NEW, (Enum)TaskStateInternal.KILLED, (Enum)TaskEventType.T_TERMINATE, (SingleArcTransition)new KillNewTransition()).addTransition((Enum)TaskStateInternal.NEW, EnumSet.of(TaskStateInternal.NEW, new TaskStateInternal[]{TaskStateInternal.SCHEDULED, TaskStateInternal.RUNNING, TaskStateInternal.SUCCEEDED, TaskStateInternal.FAILED, TaskStateInternal.KILLED}), (Enum)TaskEventType.T_RECOVER, (MultipleArcTransition)new RecoverTransition()).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskEventType.T_TERMINATE, KILL_TRANSITION).addTransition((Enum)TaskStateInternal.SCHEDULED, (Enum)TaskStateInternal.SCHEDULED, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskStateInternal.SCHEDULED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_LAUNCHED).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ADD_SPEC_ATTEMPT, (SingleArcTransition)new RedundantScheduleTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (SingleArcTransition)new AttemptSucceededTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_ATTEMPT_KILLED, ATTEMPT_KILLED_TRANSITION).addTransition((Enum)TaskStateInternal.RUNNING, EnumSet.of(TaskStateInternal.RUNNING, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition()).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskEventType.T_TERMINATE, KILL_TRANSITION).addTransition((Enum)TaskStateInternal.RUNNING, (Enum)TaskStateInternal.RUNNING, (Enum)TaskEventType.T_SCHEDULE).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new KillWaitAttemptCompletedTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new KillWaitAttemptCompletedTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskStateInternal.KILL_WAIT, TaskStateInternal.KILLED), (Enum)TaskEventType.T_ATTEMPT_SUCCEEDED, (MultipleArcTransition)new KillWaitAttemptCompletedTransition()).addTransition((Enum)TaskStateInternal.KILL_WAIT, (Enum)TaskStateInternal.KILL_WAIT, EnumSet.of(TaskEventType.T_TERMINATE, TaskEventType.T_ATTEMPT_LAUNCHED, TaskEventType.T_ADD_SPEC_ATTEMPT)).addTransition((Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED, TaskStateInternal.FAILED), (Enum)TaskEventType.T_ATTEMPT_FAILED, (MultipleArcTransition)new TaskRetroactiveFailureTransition()).addTransition((Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskStateInternal.SCHEDULED, TaskStateInternal.SUCCEEDED), (Enum)TaskEventType.T_ATTEMPT_KILLED, (MultipleArcTransition)new TaskRetroactiveKilledTransition()).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, EnumSet.of(TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_TERMINATE, TaskEventType.T_ATTEMPT_SUCCEEDED, TaskEventType.T_ATTEMPT_LAUNCHED)).addTransition((Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskStateInternal.SUCCEEDED, (Enum)TaskEventType.T_SCHEDULE).addTransition((Enum)TaskStateInternal.FAILED, (Enum)TaskStateInternal.FAILED, EnumSet.of(TaskEventType.T_TERMINATE, TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_KILLED)).addTransition((Enum)TaskStateInternal.KILLED, (Enum)TaskStateInternal.KILLED, EnumSet.of(TaskEventType.T_TERMINATE, TaskEventType.T_ADD_SPEC_ATTEMPT, TaskEventType.T_ATTEMPT_KILLED)).addTransition((Enum)TaskStateInternal.FAILED, (Enum)TaskStateInternal.FAILED, (Enum)TaskEventType.T_SCHEDULE).installTopology();
    private final StateMachineTez<TaskStateInternal, TaskEventType, TaskEvent, TaskImpl> stateMachine;
    private TezTaskAttemptID commitAttempt;
    @VisibleForTesting
    TezTaskAttemptID successfulAttempt;
    @VisibleForTesting
    int failedAttempts;
    private final boolean leafVertex;
    private TaskState recoveredState = TaskState.NEW;

    private void augmentStateMachine() {
        this.stateMachine.registerStateEnteredCallback(TaskStateInternal.SUCCEEDED, STATE_CHANGED_CALLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskState getState() {
        this.readLock.lock();
        try {
            TaskState taskState = TaskImpl.getExternalState(this.getInternalState());
            return taskState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public TaskImpl(TezVertexID vertexId, int taskIndex, EventHandler eventHandler, Configuration conf, TaskAttemptListener taskAttemptListener, Clock clock, TaskHeartbeatHandler thh, AppContext appContext, boolean leafVertex, Resource resource, ContainerContext containerContext, StateChangeNotifier stateChangeNotifier) {
        this.conf = conf;
        this.clock = clock;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.attempts = Collections.emptyMap();
        this.maxFailedAttempts = this.conf.getInt("tez.am.task.max.failed.attempts", 4);
        this.taskId = TezTaskID.getInstance((TezVertexID)vertexId, (int)taskIndex);
        this.taskAttemptListener = taskAttemptListener;
        this.taskHeartbeatHandler = thh;
        this.eventHandler = eventHandler;
        this.appContext = appContext;
        this.stateChangeNotifier = stateChangeNotifier;
        this.leafVertex = leafVertex;
        this.taskResource = resource;
        this.containerContext = containerContext;
        this.stateMachine = new StateMachineTez(stateMachineFactory.make((Object)this), this);
        this.augmentStateMachine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TezTaskAttemptID, TaskAttempt> getAttempts() {
        this.readLock.lock();
        try {
            if (this.attempts.size() <= 1) {
                Map<TezTaskAttemptID, TaskAttempt> map = this.attempts;
                return map;
            }
            LinkedHashMap<TezTaskAttemptID, TaskAttempt> result = new LinkedHashMap<TezTaskAttemptID, TaskAttempt>();
            result.putAll(this.attempts);
            LinkedHashMap<TezTaskAttemptID, TaskAttempt> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttempt getAttempt(TezTaskAttemptID attemptID) {
        this.readLock.lock();
        try {
            TaskAttempt taskAttempt = this.attempts.get(attemptID);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Vertex getVertex() {
        return this.appContext.getCurrentDAG().getVertex(this.taskId.getVertexID());
    }

    @Override
    public TezTaskID getTaskId() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.getInternalState() == TaskStateInternal.SUCCEEDED || this.getInternalState() == TaskStateInternal.FAILED || this.getInternalState() == TaskStateInternal.KILLED || this.getInternalState() == TaskStateInternal.KILL_WAIT;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskReport getReport() {
        TaskReportImpl report = new TaskReportImpl();
        this.readLock.lock();
        try {
            report.setTaskId(this.taskId);
            report.setStartTime(this.getLaunchTime());
            report.setFinishTime(this.getFinishTime());
            report.setTaskState(this.getState());
            report.setProgress(this.getProgress());
            TaskReportImpl taskReportImpl = report;
            return taskReportImpl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TezCounters getCounters() {
        TezCounters counters = new TezCounters();
        counters.incrAllCounters((AbstractCounters)this.counters);
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            if (bestAttempt != null) {
                counters.incrAllCounters((AbstractCounters)bestAttempt.getCounters());
            }
            TezCounters tezCounters = counters;
            return tezCounters;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            TaskAttempt bestAttempt = this.selectBestAttempt();
            if (bestAttempt == null) {
                float f = 0.0f;
                return f;
            }
            float f = bestAttempt.getProgress();
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TezEvent> getTaskAttemptTezEvents(TezTaskAttemptID attemptID, int fromEventId, int maxEvents) {
        List<TezEvent> events = EMPTY_TASK_ATTEMPT_TEZ_EVENTS;
        this.readLock.lock();
        if (!this.attempts.containsKey(attemptID)) {
            throw new TezUncheckedException("Unknown TA: " + attemptID + " asking for events from task:" + this.getTaskId());
        }
        try {
            if (this.tezEventsForTaskAttempts.size() > fromEventId) {
                int actualMax = Math.min(maxEvents, this.tezEventsForTaskAttempts.size() - fromEventId);
                int toEventId = actualMax + fromEventId;
                events = Collections.unmodifiableList(new ArrayList<TezEvent>(this.tezEventsForTaskAttempts.subList(fromEventId, toEventId)));
                LOG.info((Object)("TaskAttempt:" + attemptID + " sent events: (" + fromEventId + "-" + toEventId + ")"));
            }
            List<TezEvent> list = events;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDiagnostics() {
        this.readLock.lock();
        try {
            List<String> list = this.diagnostics;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private TaskAttempt createRecoveredTaskAttempt(TezTaskAttemptID tezTaskAttemptID) {
        TaskAttemptImpl taskAttempt = this.createAttempt(tezTaskAttemptID.getId());
        return taskAttempt;
    }

    @Override
    public TaskState restoreFromEvent(HistoryEvent historyEvent) {
        this.writeLock.lock();
        try {
            switch (historyEvent.getEventType()) {
                case TASK_STARTED: {
                    TaskStartedEvent tEvent = (TaskStartedEvent)historyEvent;
                    this.recoveryStartEventSeen = true;
                    this.scheduledTime = tEvent.getScheduledTime();
                    if (this.attempts == null || this.attempts.isEmpty()) {
                        this.attempts = new LinkedHashMap<TezTaskAttemptID, TaskAttempt>();
                    }
                    this.recoveredState = TaskState.SCHEDULED;
                    this.historyTaskStartGenerated = true;
                    this.taskAttemptStatus.clear();
                    TaskState taskState = this.recoveredState;
                    return taskState;
                }
                case TASK_FINISHED: {
                    TaskFinishedEvent tEvent = (TaskFinishedEvent)historyEvent;
                    if (!this.recoveryStartEventSeen && !tEvent.getState().equals((Object)TaskState.KILLED)) {
                        throw new TezUncheckedException("Finished Event seen but no Started Event was encountered earlier, taskId=" + this.taskId + ", finishState=" + (Object)((Object)tEvent.getState()));
                    }
                    this.recoveredState = tEvent.getState();
                    if (tEvent.getState() == TaskState.SUCCEEDED && tEvent.getSuccessfulAttemptID() != null) {
                        this.successfulAttempt = tEvent.getSuccessfulAttemptID();
                    }
                    TaskState taskState = this.recoveredState;
                    return taskState;
                }
                case TASK_ATTEMPT_STARTED: {
                    TaskAttemptStartedEvent taskAttemptStartedEvent = (TaskAttemptStartedEvent)historyEvent;
                    TaskAttempt recoveredAttempt = this.createRecoveredTaskAttempt(taskAttemptStartedEvent.getTaskAttemptID());
                    recoveredAttempt.restoreFromEvent(taskAttemptStartedEvent);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding restored attempt into known attempts map, taskAttemptId=" + taskAttemptStartedEvent.getTaskAttemptID()));
                    }
                    this.attempts.put(taskAttemptStartedEvent.getTaskAttemptID(), recoveredAttempt);
                    this.taskAttemptStatus.put(taskAttemptStartedEvent.getTaskAttemptID().getId(), false);
                    TaskState taskState = this.recoveredState = TaskState.RUNNING;
                    return taskState;
                }
                case TASK_ATTEMPT_FINISHED: {
                    TaskAttemptFinishedEvent taskAttemptFinishedEvent = (TaskAttemptFinishedEvent)historyEvent;
                    TaskAttempt taskAttempt = this.attempts.get(taskAttemptFinishedEvent.getTaskAttemptID());
                    this.taskAttemptStatus.put(taskAttemptFinishedEvent.getTaskAttemptID().getId(), true);
                    if (taskAttempt == null) {
                        LOG.warn((Object)("Received an attempt finished event for an attempt that  never started or does not exist, taskAttemptId=" + taskAttemptFinishedEvent.getTaskAttemptID() + ", taskAttemptFinishState=" + (Object)((Object)taskAttemptFinishedEvent.getState())));
                        TaskAttempt recoveredAttempt = this.createRecoveredTaskAttempt(taskAttemptFinishedEvent.getTaskAttemptID());
                        this.attempts.put(taskAttemptFinishedEvent.getTaskAttemptID(), recoveredAttempt);
                        if (!taskAttemptFinishedEvent.getState().equals((Object)TaskAttemptState.KILLED)) {
                            throw new TezUncheckedException("Could not find task attempt when trying to recover, taskAttemptId=" + taskAttemptFinishedEvent.getTaskAttemptID() + ", taskAttemptFinishState" + (Object)((Object)taskAttemptFinishedEvent.getState()));
                        }
                        TaskState taskState = this.recoveredState;
                        return taskState;
                    }
                    if (this.getUncompletedAttemptsCount() < 0) {
                        throw new TezUncheckedException("Invalid recovery event for attempt finished, more completions than starts encountered, taskId=" + this.taskId + ", finishedAttempts=" + this.getFinishedAttemptsCount() + ", incompleteAttempts=" + this.getUncompletedAttemptsCount());
                    }
                    TaskAttemptState taskAttemptState = taskAttempt.restoreFromEvent(taskAttemptFinishedEvent);
                    if (taskAttemptState.equals((Object)TaskAttemptState.SUCCEEDED)) {
                        this.recoveredState = TaskState.SUCCEEDED;
                        this.successfulAttempt = taskAttempt.getID();
                    } else if (taskAttemptState.equals((Object)TaskAttemptState.FAILED)) {
                        ++this.failedAttempts;
                        this.getVertex().incrementFailedTaskAttemptCount();
                        this.successfulAttempt = null;
                        this.recoveredState = TaskState.RUNNING;
                    } else if (taskAttemptState.equals((Object)TaskAttemptState.KILLED)) {
                        this.successfulAttempt = null;
                        this.getVertex().incrementKilledTaskAttemptCount();
                        this.recoveredState = TaskState.RUNNING;
                    }
                    TaskState taskState = this.recoveredState;
                    return taskState;
                }
            }
            throw new RuntimeException("Unexpected event received for restoring state, eventType=" + (Object)((Object)historyEvent.getEventType()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TaskStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskStateInternal taskStateInternal = this.stateMachine.getCurrentState();
            return taskStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static TaskState getExternalState(TaskStateInternal smState) {
        if (smState == TaskStateInternal.KILL_WAIT) {
            return TaskState.KILLED;
        }
        return TaskState.valueOf(smState.name());
    }

    private long getLaunchTime() {
        long taskLaunchTime = 0L;
        boolean launchTimeSet = false;
        for (TaskAttempt at : this.attempts.values()) {
            long attemptLaunchTime = at.getLaunchTime();
            if (attemptLaunchTime != 0L && !launchTimeSet) {
                launchTimeSet = true;
                taskLaunchTime = attemptLaunchTime;
                continue;
            }
            if (attemptLaunchTime == 0L || taskLaunchTime <= attemptLaunchTime) continue;
            taskLaunchTime = attemptLaunchTime;
        }
        if (!launchTimeSet) {
            return this.scheduledTime;
        }
        return taskLaunchTime;
    }

    private long getFinishTime() {
        if (!this.isFinished()) {
            return 0L;
        }
        long finishTime = 0L;
        for (TaskAttempt at : this.attempts.values()) {
            if (finishTime >= at.getFinishTime()) continue;
            finishTime = at.getFinishTime();
        }
        return finishTime;
    }

    private TaskStateInternal finished(TaskStateInternal finalState) {
        if (this.getInternalState() == TaskStateInternal.RUNNING) {
            // empty if block
        }
        return finalState;
    }

    private TaskAttempt selectBestAttempt() {
        float progress = 0.0f;
        TaskAttempt result = null;
        block3: for (TaskAttempt at : this.attempts.values()) {
            float attemptProgress;
            switch (at.getState()) {
                case FAILED: 
                case KILLED: {
                    continue block3;
                }
            }
            if (result == null) {
                result = at;
            }
            if (!((attemptProgress = at.getProgress()) > progress)) continue;
            result = at;
            progress = attemptProgress;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canCommit(TezTaskAttemptID taskAttemptID) {
        this.writeLock.lock();
        try {
            TaskState state = this.getState();
            if (state == TaskState.SCHEDULED && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Event processing delay. Attempt committing before state machine transitioned to running : Task:" + this.taskId));
                boolean bl = false;
                return bl;
            }
            if (state != TaskState.RUNNING) {
                LOG.info((Object)("Task not running. Issuing kill to bad commit attempt " + taskAttemptID));
                this.eventHandler.handle((Event)new TaskAttemptEventKillRequest(taskAttemptID, "Task not running. Bad attempt.", TaskAttemptTerminationCause.TERMINATED_ORPHANED));
                boolean bl = false;
                return bl;
            }
            if (this.commitAttempt == null) {
                TaskAttempt ta = this.getAttempt(taskAttemptID);
                if (ta == null) {
                    throw new TezUncheckedException("Unknown task for commit: " + taskAttemptID);
                }
                TaskAttemptState taState = ta.getStateNoLock();
                if (taState == TaskAttemptState.RUNNING) {
                    this.commitAttempt = taskAttemptID;
                    LOG.info((Object)(taskAttemptID + " given a go for committing the task output."));
                    boolean bl = true;
                    return bl;
                }
                LOG.info((Object)(taskAttemptID + " with state: " + (Object)((Object)taState) + " given a no-go for commit because its not running."));
                boolean bl = false;
                return bl;
            }
            if (this.commitAttempt.equals((Object)taskAttemptID)) {
                LOG.info((Object)(taskAttemptID + " given a go for committing the task output."));
                boolean bl = true;
                return bl;
            }
            LOG.info((Object)(this.commitAttempt + " is current committer. Commit waiting for:  " + taskAttemptID));
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    TaskAttemptImpl createAttempt(int attemptNumber) {
        return new TaskAttemptImpl(this.getTaskId(), attemptNumber, this.eventHandler, this.taskAttemptListener, this.conf, this.clock, this.taskHeartbeatHandler, this.appContext, this.failedAttempts > 0, this.taskResource, this.containerContext, this.leafVertex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttempt getSuccessfulAttempt() {
        this.readLock.lock();
        try {
            if (null == this.successfulAttempt) {
                TaskAttempt taskAttempt = null;
                return taskAttempt;
            }
            TaskAttempt taskAttempt = this.attempts.get(this.successfulAttempt);
            return taskAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addAndScheduleAttempt() {
        TaskAttemptImpl attempt = this.createAttempt(this.attempts.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created attempt " + attempt.getID()));
        }
        switch (this.attempts.size()) {
            case 0: {
                this.attempts = Collections.singletonMap(attempt.getID(), attempt);
                break;
            }
            case 1: {
                LinkedHashMap<TezTaskAttemptID, TaskAttempt> newAttempts = new LinkedHashMap<TezTaskAttemptID, TaskAttempt>(this.maxFailedAttempts);
                newAttempts.putAll(this.attempts);
                this.attempts = newAttempts;
                this.attempts.put(attempt.getID(), attempt);
                break;
            }
            default: {
                this.attempts.put(attempt.getID(), attempt);
            }
        }
        this.taskAttemptStatus.put(attempt.getID().getId(), false);
        this.eventHandler.handle((Event)new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, attempt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing TaskEvent " + event.getTaskID() + " of type " + event.getType() + " while in state " + (Object)((Object)this.getInternalState()) + ". Event: " + (Object)((Object)event)));
        }
        try {
            this.writeLock.lock();
            TaskStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition((TaskEventType)event.getType(), event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.taskId), (Throwable)e);
                this.internalError((TaskEventType)event.getType());
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.taskId + " Task Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState()) + " due to event " + event.getType()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void internalError(TaskEventType type) {
        LOG.error((Object)("Invalid event " + (Object)((Object)type) + " on Task " + this.taskId + " in state:" + (Object)((Object)this.getInternalState())));
        this.eventHandler.handle((Event)new DAGEventDiagnosticsUpdate(this.taskId.getVertexID().getDAGId(), "Invalid event " + (Object)((Object)type) + " on Task " + this.taskId));
        this.eventHandler.handle((Event)new DAGEvent(this.taskId.getVertexID().getDAGId(), DAGEventType.INTERNAL_ERROR));
    }

    private void sendTaskAttemptCompletionEvent(TezTaskAttemptID attemptId, TaskAttemptStateInternal attemptState) {
        this.eventHandler.handle((Event)new VertexEventTaskAttemptCompleted(attemptId, attemptState));
    }

    private void handleTaskAttemptCompletion(TezTaskAttemptID attemptId, TaskAttemptStateInternal attemptState) {
        this.sendTaskAttemptCompletionEvent(attemptId, attemptState);
    }

    private static void unSucceed(TaskImpl task) {
        task.commitAttempt = null;
        task.successfulAttempt = null;
    }

    protected String getSplitsAsString() {
        return "";
    }

    protected void logJobHistoryTaskStartedEvent() {
        TaskStartedEvent startEvt = new TaskStartedEvent(this.taskId, this.getVertex().getName(), this.scheduledTime, this.getLaunchTime());
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.taskId.getVertexID().getDAGId(), startEvt));
    }

    protected void logJobHistoryTaskFinishedEvent() {
        TaskFinishedEvent finishEvt = new TaskFinishedEvent(this.taskId, this.getVertex().getName(), this.getLaunchTime(), this.clock.getTime(), this.successfulAttempt, TaskState.SUCCEEDED, "", this.getCounters());
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.taskId.getVertexID().getDAGId(), finishEvt));
    }

    protected void logJobHistoryTaskFailedEvent(TaskState finalState) {
        TaskFinishedEvent finishEvt = new TaskFinishedEvent(this.taskId, this.getVertex().getName(), this.getLaunchTime(), this.clock.getTime(), null, finalState, StringUtils.join(this.getDiagnostics(), (String)LINE_SEPARATOR), this.getCounters());
        this.appContext.getHistoryHandler().handle(new DAGHistoryEvent(this.taskId.getVertexID().getDAGId(), finishEvt));
    }

    private void addDiagnosticInfo(String diag) {
        if (diag != null && !diag.equals("")) {
            this.diagnostics.add(diag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getUncompletedAttemptsCount() {
        try {
            this.readLock.lock();
            int n = Maps.filterValues(this.taskAttemptStatus, (Predicate)new Predicate<Boolean>(){

                public boolean apply(Boolean state) {
                    return state == false;
                }
            }).size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getFinishedAttemptsCount() {
        try {
            this.readLock.lock();
            int n = Maps.filterValues(this.taskAttemptStatus, (Predicate)new Predicate<Boolean>(){

                public boolean apply(Boolean state) {
                    return state;
                }
            }).size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void killUnfinishedAttempt(TaskAttempt attempt, String logMsg, TaskAttemptTerminationCause errorCause) {
        if (this.commitAttempt != null && this.commitAttempt.equals((Object)attempt)) {
            LOG.info((Object)("Removing commit attempt: " + this.commitAttempt));
            this.commitAttempt = null;
        }
        if (attempt != null && !attempt.isFinished()) {
            this.eventHandler.handle((Event)new TaskAttemptEventKillRequest(attempt.getID(), logMsg, errorCause));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTezEvent(TezEvent tezEvent) {
        this.writeLock.lock();
        try {
            this.tezEventsForTaskAttempts.add(tezEvent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static class LaunchTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        LaunchTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
        }
    }

    private static class KillTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskEventTermination terminateEvent = (TaskEventTermination)event;
            task.addDiagnosticInfo(terminateEvent.getDiagnosticInfo());
            for (TaskAttempt attempt : task.attempts.values()) {
                task.killUnfinishedAttempt(attempt, "Task KILL is received. Killing attempt. Diagnostics: " + terminateEvent.getDiagnosticInfo(), terminateEvent.getTerminationCause());
            }
        }
    }

    private static class TaskStateChangedCallback
    implements OnStateChangedCallback<TaskStateInternal, TaskImpl> {
        private TaskStateChangedCallback() {
        }

        @Override
        public void onStateChanged(TaskImpl task, TaskStateInternal taskStateInternal) {
            Preconditions.checkState((taskStateInternal == TaskStateInternal.SUCCEEDED ? 1 : 0) != 0);
            TaskAttempt successfulAttempt = task.getSuccessfulAttempt();
            int succesfulAttemptInt = -1;
            if (successfulAttempt != null) {
                succesfulAttemptInt = successfulAttempt.getID().getId();
            }
            task.stateChangeNotifier.taskSucceeded(task.getVertex().getName(), task.getTaskId(), succesfulAttemptInt);
        }
    }

    private static class KillNewTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private KillNewTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskEventTermination terminateEvent = (TaskEventTermination)event;
            task.addDiagnosticInfo(terminateEvent.getDiagnosticInfo());
            if (task.historyTaskStartGenerated) {
                task.logJobHistoryTaskFailedEvent(TaskState.KILLED);
            } else {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getTaskId()));
            }
            task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskState.KILLED));
        }
    }

    private static class TaskRetroactiveKilledTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private TaskRetroactiveKilledTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskEventTAUpdate attemptEvent = (TaskEventTAUpdate)event;
            TezTaskAttemptID attemptId = attemptEvent.getTaskAttemptID();
            if (task.successfulAttempt == attemptId) {
                TaskImpl.unSucceed(task);
                task.handleTaskAttemptCompletion(attemptId, TaskAttemptStateInternal.KILLED);
                task.eventHandler.handle((Event)new VertexEventTaskReschedule(task.taskId));
                task.addAndScheduleAttempt();
                return TaskStateInternal.SCHEDULED;
            }
            LOG.info((Object)("Ignoring kill of attempt: " + attemptId + " because attempt: " + task.successfulAttempt + " is already successful"));
            return TaskStateInternal.SUCCEEDED;
        }
    }

    private static class TaskRetroactiveFailureTransition
    extends AttemptFailedTransition {
        private TaskRetroactiveFailureTransition() {
        }

        @Override
        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            AMContainer amContainer;
            TaskEventTAUpdate castEvent;
            TezTaskAttemptID failedAttemptId;
            TaskAttempt failedAttempt;
            ContainerId containerId;
            if (task.leafVertex) {
                LOG.error((Object)("Unexpected event for task of leaf vertex " + event.getType() + ", taskId: " + task.getTaskId()));
                task.internalError((TaskEventType)event.getType());
            }
            if ((containerId = (failedAttempt = task.getAttempt(failedAttemptId = (castEvent = (TaskEventTAUpdate)event).getTaskAttemptID())).getAssignedContainerID()) != null && (amContainer = task.appContext.getAllContainers().get(containerId)) != null) {
                task.eventHandler.handle((Event)new AMNodeEventTaskAttemptEnded(amContainer.getContainer().getNodeId(), containerId, failedAttemptId, true));
            }
            if (task.getInternalState() == TaskStateInternal.SUCCEEDED && !failedAttemptId.equals((Object)task.successfulAttempt)) {
                return TaskStateInternal.SUCCEEDED;
            }
            TaskImpl.unSucceed(task);
            TaskStateInternal returnState = super.transition(task, event);
            if (returnState == TaskStateInternal.SCHEDULED) {
                task.eventHandler.handle((Event)new VertexEventTaskReschedule(task.taskId));
            }
            return returnState;
        }

        @Override
        protected TaskStateInternal getDefaultState(TaskImpl task) {
            return TaskStateInternal.SCHEDULED;
        }
    }

    private static class AttemptFailedTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private AttemptFailedTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            ++task.failedAttempts;
            task.getVertex().incrementFailedTaskAttemptCount();
            TaskEventTAUpdate castEvent = (TaskEventTAUpdate)event;
            task.addDiagnosticInfo("TaskAttempt " + castEvent.getTaskAttemptID().getId() + " failed," + " info=" + task.getAttempt(castEvent.getTaskAttemptID()).getDiagnostics());
            if (task.commitAttempt != null && castEvent.getTaskAttemptID().equals((Object)task.commitAttempt)) {
                task.commitAttempt = null;
            }
            task.taskAttemptStatus.put(castEvent.getTaskAttemptID().getId(), true);
            if (task.failedAttempts < task.maxFailedAttempts) {
                task.handleTaskAttemptCompletion(((TaskEventTAUpdate)event).getTaskAttemptID(), TaskAttemptStateInternal.FAILED);
                if (task.getUncompletedAttemptsCount() == 0 && task.successfulAttempt == null) {
                    LOG.info((Object)("Scheduling new attempt for task: " + task.getTaskId() + ", currentFailedAttempts: " + task.failedAttempts + ", maxFailedAttempts: " + task.maxFailedAttempts));
                    task.addAndScheduleAttempt();
                }
            } else {
                LOG.info((Object)("Failing task: " + task.getTaskId() + ", currentFailedAttempts: " + task.failedAttempts + ", maxFailedAttempts: " + task.maxFailedAttempts));
                task.handleTaskAttemptCompletion(((TaskEventTAUpdate)event).getTaskAttemptID(), TaskAttemptStateInternal.FAILED);
                if (task.historyTaskStartGenerated) {
                    task.logJobHistoryTaskFailedEvent(TaskState.FAILED);
                } else {
                    LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getTaskId()));
                }
                task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskState.FAILED));
                return task.finished(TaskStateInternal.FAILED);
            }
            return this.getDefaultState(task);
        }

        protected TaskStateInternal getDefaultState(TaskImpl task) {
            return task.getInternalState();
        }
    }

    private static class KillWaitAttemptCompletedTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private KillWaitAttemptCompletedTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent event) {
            TaskEventTAUpdate castEvent = (TaskEventTAUpdate)event;
            task.handleTaskAttemptCompletion(castEvent.getTaskAttemptID(), TaskAttemptStateInternal.KILLED);
            task.taskAttemptStatus.put(castEvent.getTaskAttemptID().getId(), true);
            if (task.getFinishedAttemptsCount() == task.attempts.size()) {
                if (task.historyTaskStartGenerated) {
                    task.logJobHistoryTaskFailedEvent(TaskImpl.getExternalState(TaskStateInternal.KILLED));
                } else {
                    LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for task: " + task.getTaskId()));
                }
                task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskImpl.getExternalState(TaskStateInternal.KILLED)));
                return TaskStateInternal.KILLED;
            }
            return task.getInternalState();
        }
    }

    private static class RecoverTransition
    implements MultipleArcTransition<TaskImpl, TaskEvent, TaskStateInternal> {
        private RecoverTransition() {
        }

        public TaskStateInternal transition(TaskImpl task, TaskEvent taskEvent) {
            TaskEventRecoverTask taskEventRecoverTask;
            if (taskEvent instanceof TaskEventRecoverTask && (taskEventRecoverTask = (TaskEventRecoverTask)taskEvent).getDesiredState() != null && !taskEventRecoverTask.recoverData()) {
                switch (taskEventRecoverTask.getDesiredState()) {
                    case SUCCEEDED: {
                        return TaskStateInternal.SUCCEEDED;
                    }
                    case FAILED: {
                        return TaskStateInternal.FAILED;
                    }
                    case KILLED: {
                        return TaskStateInternal.KILLED;
                    }
                }
            }
            TaskStateInternal endState = TaskStateInternal.NEW;
            if (task.attempts != null) {
                for (TaskAttempt taskAttempt : task.attempts.values()) {
                    task.eventHandler.handle((Event)new TaskAttemptEvent(taskAttempt.getID(), TaskAttemptEventType.TA_RECOVER));
                }
            }
            LOG.info((Object)("Trying to recover task, taskId=" + task.getTaskId() + ", recoveredState=" + (Object)((Object)task.recoveredState)));
            switch (task.recoveredState) {
                case NEW: {
                    endState = TaskStateInternal.NEW;
                    break;
                }
                case SUCCEEDED: 
                case SCHEDULED: 
                case RUNNING: {
                    if (task.successfulAttempt != null) {
                        boolean recoveredData = true;
                        if (task.getVertex().getOutputCommitters() != null && !task.getVertex().getOutputCommitters().isEmpty()) {
                            for (Map.Entry<String, OutputCommitter> entry : task.getVertex().getOutputCommitters().entrySet()) {
                                LOG.info((Object)("Recovering data for task from previous DAG attempt, taskId=" + task.getTaskId() + ", output=" + entry.getKey()));
                                OutputCommitter committer = entry.getValue();
                                if (!committer.isTaskRecoverySupported()) {
                                    LOG.info((Object)("Task recovery not supported by committer, failing task attempt, taskId=" + task.getTaskId() + ", attemptId=" + task.successfulAttempt + ", output=" + entry.getKey()));
                                    recoveredData = false;
                                    break;
                                }
                                try {
                                    committer.recoverTask(task.getTaskId().getId(), task.appContext.getApplicationAttemptId().getAttemptId() - 1);
                                }
                                catch (Exception e) {
                                    LOG.warn((Object)("Task recovery failed by committer, taskId=" + task.getTaskId() + ", attemptId=" + task.successfulAttempt + ", output=" + entry.getKey()), (Throwable)e);
                                    recoveredData = false;
                                    break;
                                }
                            }
                        }
                        if (!recoveredData) {
                            task.successfulAttempt = null;
                        } else {
                            LOG.info((Object)("Recovered a successful attempt, taskAttemptId=" + task.successfulAttempt.toString()));
                            task.logJobHistoryTaskFinishedEvent();
                            task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskImpl.getExternalState(TaskStateInternal.SUCCEEDED)));
                            task.eventHandler.handle((Event)new VertexEventTaskAttemptCompleted(task.successfulAttempt, TaskAttemptStateInternal.SUCCEEDED));
                            endState = TaskStateInternal.SUCCEEDED;
                            break;
                        }
                    }
                    if (endState != TaskStateInternal.SUCCEEDED && task.failedAttempts >= task.maxFailedAttempts) {
                        task.finished(TaskStateInternal.FAILED);
                        endState = TaskStateInternal.FAILED;
                        break;
                    }
                    if (task.attempts.size() == task.getFinishedAttemptsCount()) {
                        task.addAndScheduleAttempt();
                    }
                    endState = TaskStateInternal.RUNNING;
                    break;
                }
                case KILLED: {
                    task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskImpl.getExternalState(TaskStateInternal.KILLED)));
                    endState = TaskStateInternal.KILLED;
                    break;
                }
                case FAILED: {
                    task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskImpl.getExternalState(TaskStateInternal.FAILED)));
                    endState = TaskStateInternal.FAILED;
                }
            }
            return endState;
        }
    }

    private static class AttemptKilledTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptKilledTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TaskEventTAUpdate castEvent = (TaskEventTAUpdate)event;
            task.addDiagnosticInfo("TaskAttempt " + castEvent.getTaskAttemptID().getId() + " killed");
            if (task.commitAttempt != null && castEvent.getTaskAttemptID().equals((Object)task.commitAttempt)) {
                task.commitAttempt = null;
            }
            task.handleTaskAttemptCompletion(castEvent.getTaskAttemptID(), TaskAttemptStateInternal.KILLED);
            task.taskAttemptStatus.put(castEvent.getTaskAttemptID().getId(), true);
            task.getVertex().incrementKilledTaskAttemptCount();
            if (task.getUncompletedAttemptsCount() == 0 && task.successfulAttempt == null) {
                task.addAndScheduleAttempt();
            }
        }
    }

    private static class AttemptSucceededTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private AttemptSucceededTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            TezTaskAttemptID successTaId = ((TaskEventTAUpdate)event).getTaskAttemptID();
            if (task.commitAttempt != null && !task.commitAttempt.equals((Object)successTaId)) {
                throw new TezUncheckedException("TA: " + successTaId + " succeeded but TA: " + task.commitAttempt + " was expected to commit and succeed");
            }
            task.handleTaskAttemptCompletion(successTaId, TaskAttemptStateInternal.SUCCEEDED);
            task.taskAttemptStatus.put(successTaId.getId(), true);
            task.successfulAttempt = successTaId;
            task.eventHandler.handle((Event)new VertexEventTaskCompleted(task.taskId, TaskState.SUCCEEDED));
            LOG.info((Object)("Task succeeded with attempt " + task.successfulAttempt));
            if (task.historyTaskStartGenerated) {
                task.logJobHistoryTaskFinishedEvent();
            }
            TaskAttempt successfulAttempt = (TaskAttempt)task.attempts.get(successTaId);
            for (TaskAttempt attempt : task.attempts.values()) {
                if (attempt.getID() == task.successfulAttempt || attempt.isFinished()) continue;
                LOG.info((Object)("Issuing kill to other attempt " + attempt.getID() + " as attempt: " + task.successfulAttempt + " has succeeded"));
                String diagnostics = null;
                TaskAttemptTerminationCause errCause = null;
                if (attempt.getLaunchTime() < successfulAttempt.getLaunchTime()) {
                    diagnostics = "Killed this attempt as other speculative attempt : " + successTaId + " succeeded";
                    errCause = TaskAttemptTerminationCause.TERMINATED_EFFECTIVE_SPECULATION;
                } else {
                    diagnostics = "Killed this speculative attempt as original attempt: " + successTaId + " succeeded";
                    errCause = TaskAttemptTerminationCause.TERMINATED_INEFFECTIVE_SPECULATION;
                }
                task.eventHandler.handle((Event)new TaskAttemptEventKillRequest(attempt.getID(), diagnostics, errCause));
            }
            task.eventHandler.handle((Event)new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SUCCEEDED, (TaskAttempt)task.attempts.get(task.successfulAttempt)));
            task.finished(TaskStateInternal.SUCCEEDED);
        }
    }

    private static class RedundantScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private RedundantScheduleTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            LOG.info((Object)("Scheduling a redundant attempt for task " + task.taskId));
            task.counters.findCounter((Enum)TaskCounter.NUM_SPECULATIONS).increment(1L);
            task.addAndScheduleAttempt();
        }
    }

    private static class InitialScheduleTransition
    implements SingleArcTransition<TaskImpl, TaskEvent> {
        private InitialScheduleTransition() {
        }

        public void transition(TaskImpl task, TaskEvent event) {
            task.addAndScheduleAttempt();
            task.scheduledTime = task.clock.getTime();
            task.logJobHistoryTaskStartedEvent();
            task.historyTaskStartGenerated = true;
        }
    }
}

