/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezConverterUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.Limits;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.api.client.DAGClientServer;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ClusterInfo;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskAttemptListenerImpTezDag;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.TezDagVersionInfo;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEvent;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventDAGFinished;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventSchedulingServiceError;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventRecoverEvent;
import org.apache.tez.dag.app.dag.event.DAGEventStartDag;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.SpeculatorEvent;
import org.apache.tez.dag.app.dag.event.SpeculatorEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEvent;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.launcher.ContainerLauncher;
import org.apache.tez.dag.app.launcher.ContainerLauncherImpl;
import org.apache.tez.dag.app.launcher.LocalContainerLauncher;
import org.apache.tez.dag.app.rm.AMSchedulerEventType;
import org.apache.tez.dag.app.rm.NMCommunicatorEventType;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.ContainerContextMatcher;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.AMNodeTracker;
import org.apache.tez.dag.app.web.WebUIService;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.Graph;
import org.apache.tez.dag.utils.RelocalizationUtils;
import org.apache.tez.dag.utils.Simple2LevelVersionComparator;
import org.codehaus.jettison.json.JSONException;

public class DAGAppMaster
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(DAGAppMaster.class);
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static Pattern sanitizeLabelPattern = Pattern.compile("[:\\-\\W]+");
    private Clock clock;
    private final boolean isSession;
    private long appsStartTime;
    private final long startTime;
    private final long appSubmitTime;
    private String appName;
    private final ApplicationAttemptId appAttemptID;
    private final ContainerId containerID;
    private final String nmHost;
    private final int nmPort;
    private final int nmHttpPort;
    private final String workingDirectory;
    private ContainerSignatureMatcher containerSignatureMatcher;
    private AMContainerMap containers;
    private AMNodeTracker nodes;
    private AppContext context;
    private Configuration amConf;
    private Dispatcher dispatcher;
    private Dispatcher speculatorDispatcher;
    private ContainerLauncher containerLauncher;
    private ContainerHeartbeatHandler containerHeartbeatHandler;
    private TaskHeartbeatHandler taskHeartbeatHandler;
    private TaskAttemptListener taskAttemptListener;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private Token<JobTokenIdentifier> sessionToken;
    private DagEventDispatcher dagEventDispatcher;
    private VertexEventDispatcher vertexEventDispatcher;
    private TaskSchedulerEventHandler taskSchedulerEventHandler;
    private WebUIService webUIService;
    private HistoryEventHandler historyEventHandler;
    private final Map<String, LocalResource> amResources = new HashMap<String, LocalResource>();
    private final Map<String, LocalResource> cumulativeAdditionalResources = new HashMap<String, LocalResource>();
    private boolean isLocal = false;
    @VisibleForTesting
    protected DAGAppMasterShutdownHandler shutdownHandler;
    private final AtomicBoolean shutdownHandlerRunning = new AtomicBoolean(false);
    private DAGAppMasterState state;
    DAGClientServer clientRpcServer;
    private DAGClientHandler clientHandler;
    private DAG currentDAG;
    private Credentials amTokens = new Credentials();
    private UserGroupInformation appMasterUgi;
    private AtomicBoolean sessionStopped = new AtomicBoolean(false);
    private long sessionTimeoutInterval;
    private long lastDAGCompletionTime;
    private Timer dagSubmissionTimer;
    private boolean recoveryEnabled;
    private Path recoveryDataDir;
    private Path currentRecoveryDataDir;
    private Path tezSystemStagingDir;
    private FileSystem recoveryFS;
    Set<String> dagNames = new HashSet<String>();
    Set<String> dagIDs = new HashSet<String>();
    protected boolean isLastAMRetry = false;
    private final AtomicInteger dagCounter = new AtomicInteger();
    private final AtomicInteger submittedDAGs = new AtomicInteger();
    private final AtomicInteger successfulDAGs = new AtomicInteger();
    private final AtomicInteger failedDAGs = new AtomicInteger();
    private final AtomicInteger killedDAGs = new AtomicInteger();
    private ACLManager aclManager;
    private TezDagVersionInfo dagVersionInfo;
    private String clientVersion;
    private boolean versionMismatch = false;
    private String versionMismatchDiagnostics;
    Map<Service, ServiceWithDependency> services = new LinkedHashMap<Service, ServiceWithDependency>();

    public DAGAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime, boolean isSession, String workingDirectory, String clientVersion) {
        super(DAGAppMaster.class.getName());
        this.clock = clock;
        this.startTime = clock.getTime();
        this.appSubmitTime = appSubmitTime;
        this.appAttemptID = applicationAttemptId;
        this.containerID = containerId;
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.state = DAGAppMasterState.NEW;
        this.isSession = isSession;
        this.workingDirectory = workingDirectory;
        this.shutdownHandler = new DAGAppMasterShutdownHandler();
        this.dagVersionInfo = new TezDagVersionInfo();
        this.clientVersion = clientVersion;
        LOG.info((Object)("Created DAGAppMaster for application " + applicationAttemptId + ", versionInfo=" + this.dagVersionInfo.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serviceInit(Configuration conf) throws Exception {
        this.amConf = conf;
        this.isLocal = conf.getBoolean("tez.local.mode", false);
        boolean disableVersionCheck = conf.getBoolean("tez.am.disable.client-version-check", false);
        int maxAppAttempts = 1;
        String maxAppAttemptsEnv = System.getenv("MAX_APP_ATTEMPTS");
        if (maxAppAttemptsEnv != null) {
            maxAppAttempts = Integer.valueOf(maxAppAttemptsEnv);
        }
        this.isLastAMRetry = this.appAttemptID.getAttemptId() >= maxAppAttempts;
        LOG.info((Object)("Comparing client version with AM version, clientVersion=" + this.clientVersion + ", AMVersion=" + this.dagVersionInfo.getVersion()));
        Simple2LevelVersionComparator versionComparator = new Simple2LevelVersionComparator();
        if (versionComparator.compare(this.clientVersion, this.dagVersionInfo.getVersion()) != 0) {
            this.versionMismatchDiagnostics = "Incompatible versions found, clientVersion=" + this.clientVersion + ", AMVersion=" + this.dagVersionInfo.getVersion();
            if (disableVersionCheck) {
                LOG.warn((Object)("Ignoring client-AM version mismatch as check disabled. " + this.versionMismatchDiagnostics));
            } else {
                LOG.fatal((Object)this.versionMismatchDiagnostics);
                this.versionMismatch = true;
            }
        }
        if (this.isLocal) {
            UserGroupInformation.setConfiguration((Configuration)conf);
            this.appMasterUgi = UserGroupInformation.getCurrentUser();
            conf.setBoolean("tez.am.node-blacklisting.enabled", false);
            conf.set("tez.history.logging.service.class", "org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService");
        }
        conf.setBoolean("yarn.dispatcher.exit-on-error", !this.isLocal);
        String strAppId = this.appAttemptID.getApplicationId().toString();
        this.tezSystemStagingDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        this.dispatcher = this.createDispatcher();
        this.context = new RunningAppContext(conf);
        this.aclManager = new ACLManager(this.appMasterUgi.getShortUserName(), this.amConf);
        this.clientHandler = new DAGClientHandler(this);
        this.addIfService(this.dispatcher, false);
        this.clientRpcServer = new DAGClientServer(this.clientHandler, this.appAttemptID);
        this.addIfService((Object)this.clientRpcServer, true);
        this.taskHeartbeatHandler = this.createTaskHeartbeatHandler(this.context, conf);
        this.addIfService((Object)this.taskHeartbeatHandler, true);
        this.containerHeartbeatHandler = this.createContainerHeartbeatHandler(this.context, conf);
        this.addIfService((Object)this.containerHeartbeatHandler, true);
        this.sessionToken = TokenCache.getSessionToken((Credentials)this.amTokens);
        if (this.sessionToken == null) {
            throw new RuntimeException("Could not find session token in AM Credentials");
        }
        LOG.info((Object)"Adding session token to jobTokenSecretManager for application");
        this.jobTokenSecretManager.addTokenForJob(this.appAttemptID.getApplicationId().toString(), this.sessionToken);
        this.taskAttemptListener = this.createTaskAttemptListener(this.context, this.taskHeartbeatHandler, this.containerHeartbeatHandler);
        this.addIfService(this.taskAttemptListener, true);
        this.containerSignatureMatcher = this.createContainerSignatureMatcher();
        this.containers = new AMContainerMap(this.containerHeartbeatHandler, this.taskAttemptListener, this.containerSignatureMatcher, this.context);
        this.addIfService((Object)this.containers, true);
        this.dispatcher.register(AMContainerEventType.class, (EventHandler)this.containers);
        this.nodes = new AMNodeTracker(this.dispatcher.getEventHandler(), this.context);
        this.addIfService((Object)this.nodes, true);
        this.dispatcher.register(AMNodeEventType.class, (EventHandler)this.nodes);
        this.dagEventDispatcher = new DagEventDispatcher();
        this.vertexEventDispatcher = new VertexEventDispatcher();
        this.dispatcher.register(DAGAppMasterEventType.class, (EventHandler)new DAGAppMasterEventHandler());
        this.dispatcher.register(DAGEventType.class, (EventHandler)this.dagEventDispatcher);
        this.dispatcher.register(VertexEventType.class, (EventHandler)this.vertexEventDispatcher);
        this.dispatcher.register(TaskEventType.class, (EventHandler)new TaskEventDispatcher());
        this.dispatcher.register(TaskAttemptEventType.class, (EventHandler)new TaskAttemptEventDispatcher());
        this.speculatorDispatcher = this.createSpeculatorEventDispatcher();
        this.addIfService(this.speculatorDispatcher, true);
        this.dispatcher.register(SpeculatorEventType.class, this.speculatorDispatcher.getEventHandler());
        if (this.enableWebUIService()) {
            this.webUIService = new WebUIService(this.context);
            this.addIfService((Object)this.webUIService, false);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Web UI Service is not enabled.");
        }
        this.taskSchedulerEventHandler = new TaskSchedulerEventHandler(this.context, this.clientRpcServer, this.dispatcher.getEventHandler(), this.containerSignatureMatcher, this.webUIService);
        this.addIfService(this.taskSchedulerEventHandler, true);
        if (this.enableWebUIService()) {
            this.addIfServiceDependency(this.taskSchedulerEventHandler, (Object)this.webUIService);
        }
        if (this.isLastAMRetry) {
            LOG.info((Object)("AM will unregister as this is the last attempt, currentAttempt=" + this.appAttemptID.getAttemptId() + ", maxAttempts=" + maxAppAttempts));
            this.taskSchedulerEventHandler.setShouldUnregisterFlag();
        }
        this.dispatcher.register(AMSchedulerEventType.class, (EventHandler)this.taskSchedulerEventHandler);
        this.addIfServiceDependency(this.taskSchedulerEventHandler, (Object)this.clientRpcServer);
        this.containerLauncher = this.createContainerLauncher(this.context);
        this.addIfService(this.containerLauncher, true);
        this.dispatcher.register(NMCommunicatorEventType.class, (EventHandler)this.containerLauncher);
        this.historyEventHandler = new HistoryEventHandler(this.context);
        this.addIfService((Object)this.historyEventHandler, true);
        this.sessionTimeoutInterval = 1000 * this.amConf.getInt("tez.session.am.dag.submit.timeout.secs", 300);
        this.recoveryDataDir = TezCommonUtils.getRecoveryPath((Path)this.tezSystemStagingDir, (Configuration)conf);
        this.recoveryFS = this.recoveryDataDir.getFileSystem(conf);
        this.currentRecoveryDataDir = TezCommonUtils.getAttemptRecoveryPath((Path)this.recoveryDataDir, (int)this.appAttemptID.getAttemptId());
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Stage directory information for AppAttemptId :" + this.appAttemptID + " tezSystemStagingDir :" + this.tezSystemStagingDir + " recoveryDataDir :" + this.recoveryDataDir + " recoveryAttemptDir :" + this.currentRecoveryDataDir));
        }
        this.recoveryEnabled = conf.getBoolean("tez.dag.recovery.enabled", true);
        if (!this.versionMismatch && this.isSession) {
            FileInputStream sessionResourcesStream = null;
            try {
                sessionResourcesStream = new FileInputStream(new File(this.workingDirectory, "tez.session.local-resources.pb"));
                DAGProtos.PlanLocalResourcesProto amLocalResourceProto = DAGProtos.PlanLocalResourcesProto.parseDelimitedFrom((InputStream)sessionResourcesStream);
                this.amResources.putAll(DagTypeConverters.convertFromPlanLocalResources((DAGProtos.PlanLocalResourcesProto)amLocalResourceProto));
            }
            finally {
                if (sessionResourcesStream != null) {
                    sessionResourcesStream.close();
                }
            }
        }
        this.initServices(conf);
        super.serviceInit(conf);
        if (!this.versionMismatch) {
            if (this.appAttemptID.getAttemptId() == 1) {
                AppLaunchedEvent appLaunchedEvent = new AppLaunchedEvent(this.appAttemptID.getApplicationId(), this.startTime, this.appSubmitTime, this.appMasterUgi.getShortUserName(), this.amConf, this.dagVersionInfo);
                this.historyEventHandler.handle(new DAGHistoryEvent(appLaunchedEvent));
            }
            AMLaunchedEvent launchedEvent = new AMLaunchedEvent(this.appAttemptID, this.startTime, this.appSubmitTime, this.appMasterUgi.getShortUserName());
            this.historyEventHandler.handle(new DAGHistoryEvent(launchedEvent));
            this.state = DAGAppMasterState.INITED;
        } else {
            this.state = DAGAppMasterState.ERROR;
        }
    }

    @VisibleForTesting
    protected ContainerSignatureMatcher createContainerSignatureMatcher() {
        return new ContainerContextMatcher();
    }

    @VisibleForTesting
    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    protected void sysexit() {
        if (!this.isLocal) {
            System.exit(0);
        }
    }

    @VisibleForTesting
    protected TaskSchedulerEventHandler getTaskSchedulerEventHandler() {
        return this.taskSchedulerEventHandler;
    }

    @VisibleForTesting
    protected synchronized void handle(DAGAppMasterEvent event) {
        switch ((DAGAppMasterEventType)event.getType()) {
            case SCHEDULING_SERVICE_ERROR: {
                DAGAppMasterEventSchedulingServiceError schedulingServiceErrorEvent = (DAGAppMasterEventSchedulingServiceError)event;
                this.state = DAGAppMasterState.ERROR;
                LOG.info((Object)"Error in the TaskScheduler. Shutting down.", schedulingServiceErrorEvent.getThrowable());
                this.shutdownHandler.shutdown();
                break;
            }
            case INTERNAL_ERROR: {
                this.state = DAGAppMasterState.ERROR;
                if (this.currentDAG != null) {
                    this._updateLoggers(this.currentDAG, "_post");
                    LOG.info((Object)"Internal Error. Notifying dags to finish.");
                    this.sendEvent((Event<?>)new DAGEvent(this.currentDAG.getID(), DAGEventType.INTERNAL_ERROR));
                    break;
                }
                LOG.info((Object)"Internal Error. Finishing directly as no dag is active.");
                this.taskSchedulerEventHandler.setShouldUnregisterFlag();
                this.shutdownHandler.shutdown();
                break;
            }
            case DAG_FINISHED: {
                DAGAppMasterEventDAGFinished finishEvt = (DAGAppMasterEventDAGFinished)event;
                String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                System.err.println(timeStamp + " Completed Dag: " + finishEvt.getDAGId().toString());
                System.out.println(timeStamp + " Completed Dag: " + finishEvt.getDAGId().toString());
                if (!this.isSession) {
                    LOG.info((Object)"Not a session, AM will unregister as DAG has completed");
                    this.taskSchedulerEventHandler.setShouldUnregisterFlag();
                    this._updateLoggers(this.currentDAG, "_post");
                    this.setStateOnDAGCompletion();
                    LOG.info((Object)("Shutting down on completion of dag:" + finishEvt.getDAGId().toString()));
                    this.shutdownHandler.shutdown();
                } else {
                    LOG.info((Object)("DAG completed, dagId=" + finishEvt.getDAGId().toString() + ", dagState=" + (Object)((Object)finishEvt.getDAGState())));
                    this.lastDAGCompletionTime = this.clock.getTime();
                    this._updateLoggers(this.currentDAG, "_post");
                    if (this.historyEventHandler.hasRecoveryFailed()) {
                        LOG.warn((Object)"Recovery had a fatal error, shutting down session after DAG completion");
                        this.sessionStopped.set(true);
                    }
                    switch (finishEvt.getDAGState()) {
                        case SUCCEEDED: {
                            if (this.currentDAG.getName().startsWith("TezPreWarmDAG")) break;
                            this.successfulDAGs.incrementAndGet();
                            break;
                        }
                        case FAILED: {
                            if (this.currentDAG.getName().startsWith("TezPreWarmDAG")) break;
                            this.failedDAGs.incrementAndGet();
                            break;
                        }
                        case KILLED: {
                            if (this.currentDAG.getName().startsWith("TezPreWarmDAG")) break;
                            this.killedDAGs.incrementAndGet();
                            break;
                        }
                        case ERROR: {
                            if (!this.currentDAG.getName().startsWith("TezPreWarmDAG")) {
                                this.failedDAGs.incrementAndGet();
                            }
                        }
                        default: {
                            LOG.fatal((Object)("Received a DAG Finished Event with state=" + (Object)((Object)finishEvt.getDAGState()) + ". Error. Shutting down."));
                            this.state = DAGAppMasterState.ERROR;
                            this.taskSchedulerEventHandler.setShouldUnregisterFlag();
                            this.shutdownHandler.shutdown();
                        }
                    }
                    if (!this.state.equals((Object)DAGAppMasterState.ERROR)) {
                        if (!this.sessionStopped.get()) {
                            LOG.info((Object)"Waiting for next DAG to be submitted.");
                            this.taskSchedulerEventHandler.dagCompleted();
                            this.state = DAGAppMasterState.IDLE;
                        } else {
                            LOG.info((Object)"Session shutting down now.");
                            this.taskSchedulerEventHandler.setShouldUnregisterFlag();
                            this.state = this.historyEventHandler.hasRecoveryFailed() ? DAGAppMasterState.FAILED : DAGAppMasterState.SUCCEEDED;
                            this.shutdownHandler.shutdown();
                        }
                    }
                }
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)this.context.getCurrentDAG().getDagUGI());
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error occurred when trying to close FileSystem for userName " + this.context.getCurrentDAG().getDagUGI().getUserName()), (Throwable)e);
                }
                break;
            }
            case AM_REBOOT: {
                LOG.info((Object)"Received an AM_REBOOT signal");
                this.state = DAGAppMasterState.KILLED;
                this.shutdownHandler.shutdown(true);
                break;
            }
            default: {
                throw new TezUncheckedException("AppMaster: No handler for event type: " + event.getType());
            }
        }
    }

    private void _updateLoggers(DAG dag, String appender) {
        try {
            TezUtilsInternal.updateLoggers((String)(dag.getID().toString() + appender));
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)"Unable to update the logger. Continue with the old logger", (Throwable)e);
        }
    }

    public void setCurrentDAG(DAG currentDAG) {
        this.currentDAG = currentDAG;
        this.context.setDAG(currentDAG);
    }

    public ACLManager getACLManager() {
        return this.aclManager;
    }

    protected DAG createDAG(DAGProtos.DAGPlan dagPB) {
        return this.createDAG(dagPB, null);
    }

    DAGImpl createDAG(DAGProtos.DAGPlan dagPB, TezDAGID dagId) {
        if (dagId == null) {
            dagId = TezDAGID.getInstance((ApplicationId)this.appAttemptID.getApplicationId(), (int)this.dagCounter.incrementAndGet());
        }
        Iterator iter = dagPB.getDagKeyValues().getConfKeyValuesList().iterator();
        Configuration dagConf = new Configuration(this.amConf);
        while (iter.hasNext()) {
            DAGProtos.PlanKeyValuePair keyValPair = (DAGProtos.PlanKeyValuePair)iter.next();
            dagConf.set(keyValPair.getKey(), keyValPair.getValue());
        }
        Credentials dagCredentials = null;
        if (dagPB.hasCredentialsBinary()) {
            dagCredentials = DagTypeConverters.convertByteStringToCredentials((ByteString)dagPB.getCredentialsBinary());
            TezCommonUtils.logCredentials((Log)LOG, (Credentials)dagCredentials, (String)"dag");
        } else {
            dagCredentials = new Credentials();
        }
        TokenCache.setSessionToken(this.sessionToken, (Credentials)dagCredentials);
        DAGImpl newDag = new DAGImpl(dagId, dagConf, dagPB, this.dispatcher.getEventHandler(), this.taskAttemptListener, dagCredentials, this.clock, this.appMasterUgi.getShortUserName(), this.taskHeartbeatHandler, this.context);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("JSON dump for submitted DAG, dagId=" + dagId.toString() + ", json=" + DAGUtils.generateSimpleJSONPlan(dagPB).toString()));
            }
        }
        catch (JSONException e) {
            LOG.warn((Object)"Failed to generate json for DAG", (Throwable)e);
        }
        this.generateDAGVizFile(dagId, dagPB);
        this.writePBTextFile(newDag);
        return newDag;
    }

    String getShortClassName(String className) {
        int pos = className.lastIndexOf(".");
        if (pos != -1 && pos < className.length() - 1) {
            return className.substring(pos + 1);
        }
        return className;
    }

    private String sanitizeLabelForViz(String label) {
        Matcher m = sanitizeLabelPattern.matcher(label);
        return m.replaceAll("_");
    }

    private void generateDAGVizFile(TezDAGID dagId, DAGProtos.DAGPlan dagPB) {
        Graph graph = new Graph(this.sanitizeLabelForViz(dagPB.getName()));
        for (DAGProtos.VertexPlan v : dagPB.getVertexList()) {
            String nodeLabel = this.sanitizeLabelForViz(v.getName()) + "[" + this.getShortClassName(v.getProcessorDescriptor().getClassName() + "]");
            Graph.Node n = graph.newNode(this.sanitizeLabelForViz(v.getName()), nodeLabel);
            for (DAGProtos.RootInputLeafOutputProto input : v.getInputsList()) {
                Graph.Node inputNode = graph.getNode(this.sanitizeLabelForViz(v.getName()) + "_" + this.sanitizeLabelForViz(input.getName()));
                inputNode.setLabel(this.sanitizeLabelForViz(v.getName()) + "[" + this.sanitizeLabelForViz(input.getName()) + "]");
                inputNode.setShape("box");
                inputNode.addEdge(n, "Input [inputClass=" + this.getShortClassName(input.getIODescriptor().getClassName()) + ", initializer=" + this.getShortClassName(input.getControllerDescriptor().getClassName()) + "]");
            }
            for (DAGProtos.RootInputLeafOutputProto output : v.getOutputsList()) {
                Graph.Node outputNode = graph.getNode(this.sanitizeLabelForViz(v.getName()) + "_" + this.sanitizeLabelForViz(output.getName()));
                outputNode.setLabel(this.sanitizeLabelForViz(v.getName()) + "[" + this.sanitizeLabelForViz(output.getName()) + "]");
                outputNode.setShape("box");
                n.addEdge(outputNode, "Output [outputClass=" + this.getShortClassName(output.getIODescriptor().getClassName()) + ", initializer=" + this.getShortClassName(output.getControllerDescriptor().getClassName()) + "]");
            }
        }
        for (DAGProtos.EdgePlan e : dagPB.getEdgeList()) {
            Graph.Node n = graph.getNode(this.sanitizeLabelForViz(e.getInputVertexName()));
            n.addEdge(graph.getNode(this.sanitizeLabelForViz(e.getOutputVertexName())), "[input=" + this.getShortClassName(e.getEdgeSource().getClassName()) + ", output=" + this.getShortClassName(e.getEdgeDestination().getClassName()) + ", dataMovement=" + e.getDataMovementType().name().trim() + ", schedulingType=" + e.getSchedulingType().name().trim() + "]");
        }
        String logDirs = System.getenv(ApplicationConstants.Environment.LOG_DIRS.name());
        String outputFile = "";
        if (logDirs != null && !logDirs.isEmpty()) {
            int pos = logDirs.indexOf(",");
            outputFile = pos != -1 ? outputFile + logDirs.substring(0, pos) : outputFile + logDirs;
            outputFile = outputFile + File.separator;
        }
        outputFile = outputFile + dagId.toString() + ".dot";
        try {
            LOG.info((Object)("Generating DAG graphviz file, dagId=" + dagId.toString() + ", filePath=" + outputFile));
            graph.save(outputFile);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error occurred when trying to save graph structure for dag " + dagId.toString()), (Throwable)e);
        }
    }

    private void writePBTextFile(DAG dag) {
        if (dag.getConf().getBoolean("tez.generate.debug.artifacts", false)) {
            String logFile = TezUtilsInternal.getContainerLogDir() + File.separatorChar + dag.getID().toString() + "-" + "tez-dag.pb.txt";
            LOG.info((Object)("Writing DAG plan to: " + logFile));
            File outFile = new File(logFile);
            try {
                PrintWriter printWriter = new PrintWriter(outFile);
                printWriter.println(TezUtilsInternal.convertDagPlanToString((DAGProtos.DAGPlan)dag.getJobPlan()));
                printWriter.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to write TEZ_PLAN to " + outFile.toString()), (Throwable)e);
            }
        }
    }

    protected void addIfService(Object object, boolean addDispatcher) {
        if (object instanceof Service) {
            Service service = (Service)object;
            ServiceWithDependency sd = new ServiceWithDependency(service);
            this.services.put(service, sd);
            if (addDispatcher) {
                this.addIfServiceDependency(service, this.dispatcher);
            }
        }
    }

    protected void addIfServiceDependency(Object object, Object dependency) {
        if (object instanceof Service && dependency instanceof Service) {
            Service service = (Service)object;
            Service dependencyService = (Service)dependency;
            ServiceWithDependency sd = this.services.get(service);
            sd.dependencies.add(dependencyService);
            dependencyService.registerServiceListener((ServiceStateChangeListener)sd);
        }
    }

    protected TaskAttemptListener createTaskAttemptListener(AppContext context, TaskHeartbeatHandler thh, ContainerHeartbeatHandler chh) {
        TaskAttemptListenerImpTezDag lis = new TaskAttemptListenerImpTezDag(context, thh, chh, this.jobTokenSecretManager);
        return lis;
    }

    protected TaskHeartbeatHandler createTaskHeartbeatHandler(AppContext context, Configuration conf) {
        TaskHeartbeatHandler thh = new TaskHeartbeatHandler(context, conf.getInt("tez.am.task.listener.thread-count", 30));
        return thh;
    }

    protected ContainerHeartbeatHandler createContainerHeartbeatHandler(AppContext context, Configuration conf) {
        ContainerHeartbeatHandler chh = new ContainerHeartbeatHandler(context, conf.getInt("tez.am.task.listener.thread-count", 30));
        return chh;
    }

    protected ContainerLauncher createContainerLauncher(AppContext context) throws UnknownHostException {
        if (this.isLocal) {
            return new LocalContainerLauncher(context, this.taskAttemptListener, this.workingDirectory);
        }
        return new ContainerLauncherImpl(context);
    }

    public ApplicationId getAppID() {
        return this.appAttemptID.getApplicationId();
    }

    public ApplicationAttemptId getAttemptID() {
        return this.appAttemptID;
    }

    public int getStartCount() {
        return this.appAttemptID.getAttemptId();
    }

    public AppContext getContext() {
        return this.context;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public ContainerLauncher getContainerLauncher() {
        return this.containerLauncher;
    }

    public TaskAttemptListener getTaskAttemptListener() {
        return this.taskAttemptListener;
    }

    public ContainerId getAppContainerId() {
        return this.containerID;
    }

    public String getAppNMHost() {
        return this.nmHost;
    }

    public int getAppNMPort() {
        return this.nmPort;
    }

    public int getAppNMHttpPort() {
        return this.nmHttpPort;
    }

    public int getRpcPort() {
        return this.clientRpcServer.getBindAddress().getPort();
    }

    public DAGAppMasterState getState() {
        return this.state;
    }

    public List<String> getDiagnostics() {
        if (this.versionMismatch) {
            return Collections.singletonList(this.versionMismatchDiagnostics);
        }
        if (!this.isSession) {
            if (this.currentDAG != null) {
                return this.currentDAG.getDiagnostics();
            }
        } else {
            return Collections.singletonList("Session stats:submittedDAGs=" + this.submittedDAGs.get() + ", successfulDAGs=" + this.successfulDAGs.get() + ", failedDAGs=" + this.failedDAGs.get() + ", killedDAGs=" + this.killedDAGs.get());
        }
        return null;
    }

    public float getProgress() {
        if (this.isSession && this.state.equals((Object)DAGAppMasterState.IDLE)) {
            return 0.0f;
        }
        if (this.currentDAG != null) {
            DAGState state = this.currentDAG.getState();
            switch (state) {
                case NEW: 
                case INITED: {
                    return 0.0f;
                }
                case RUNNING: {
                    return this.currentDAG.getProgress();
                }
                case SUCCEEDED: 
                case FAILED: 
                case KILLED: 
                case ERROR: 
                case TERMINATING: {
                    return 1.0f;
                }
            }
        }
        return 0.0f;
    }

    private synchronized void setStateOnDAGCompletion() {
        DAGAppMasterState oldState = this.state;
        if (this.isSession) {
            return;
        }
        switch (this.currentDAG.getState()) {
            case SUCCEEDED: {
                this.state = DAGAppMasterState.SUCCEEDED;
                break;
            }
            case FAILED: {
                this.state = DAGAppMasterState.FAILED;
                break;
            }
            case KILLED: {
                this.state = DAGAppMasterState.KILLED;
                break;
            }
            case ERROR: {
                this.state = DAGAppMasterState.ERROR;
                break;
            }
            default: {
                this.state = DAGAppMasterState.ERROR;
            }
        }
        LOG.info((Object)("On DAG completion. Old state: " + (Object)((Object)oldState) + " new state: " + (Object)((Object)this.state)));
    }

    public synchronized void shutdownTezAM() {
        this.sessionStopped.set(true);
        this.taskSchedulerEventHandler.setShouldUnregisterFlag();
        if (this.currentDAG != null && !this.currentDAG.isComplete()) {
            LOG.info((Object)("Sending a kill event to the current DAG, dagId=" + this.currentDAG.getID()));
            this.sendEvent((Event<?>)new DAGEvent(this.currentDAG.getID(), DAGEventType.DAG_KILL));
        } else {
            LOG.info((Object)"No current running DAG, shutting down the AM");
            if (this.isSession && !this.state.equals((Object)DAGAppMasterState.ERROR)) {
                this.state = DAGAppMasterState.SUCCEEDED;
            }
            this.shutdownHandler.shutdown();
        }
    }

    public synchronized String submitDAGToAppMaster(DAGProtos.DAGPlan dagPlan, Map<String, LocalResource> additionalResources) throws TezException {
        if (this.versionMismatch) {
            throw new TezException("Unable to accept DAG submissions as the ApplicationMaster is incompatible with the client. " + this.versionMismatchDiagnostics);
        }
        if (this.currentDAG != null && !this.state.equals((Object)DAGAppMasterState.IDLE)) {
            throw new TezException("App master already running a DAG");
        }
        if (this.state.equals((Object)DAGAppMasterState.ERROR) || this.sessionStopped.get()) {
            throw new TezException("AM unable to accept new DAG submissions. In the process of shutting down");
        }
        LOG.info((Object)("Starting DAG submitted via RPC: " + dagPlan.getName()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Invoked with additional local resources: " + additionalResources));
        }
        this.submittedDAGs.incrementAndGet();
        this.startDAG(dagPlan, additionalResources);
        return this.currentDAG.getID().toString();
    }

    public void tryKillDAG(DAG dag) {
        this.dispatcher.getEventHandler().handle((Event)new DAGEvent(dag.getID(), DAGEventType.DAG_KILL));
    }

    private Map<String, LocalResource> getAdditionalLocalResourceDiff(DAG dag, Map<String, LocalResource> additionalResources) throws TezException {
        if (additionalResources == null) {
            return Collections.emptyMap();
        }
        Iterator<Map.Entry<String, LocalResource>> lrIter = additionalResources.entrySet().iterator();
        while (lrIter.hasNext()) {
            Map.Entry<String, LocalResource> lrEntry = lrIter.next();
            LocalResource existing = this.amResources.get(lrEntry.getKey());
            if (existing == null) continue;
            if (!this.isSameFile(dag, lrEntry.getKey(), existing, lrEntry.getValue())) {
                throw new TezUncheckedException("Cannot add different additional resources with the same name : " + lrEntry.getKey() + ", Existing: [" + existing + "], New: [" + lrEntry.getValue() + "]");
            }
            lrIter.remove();
        }
        return this.containerSignatureMatcher.getAdditionalResources(this.amResources, additionalResources);
    }

    private boolean isSameFile(DAG dag, final String fileName, final LocalResource oldLr, final LocalResource newLr) throws TezException {
        try {
            return oldLr.equals(newLr) || (Boolean)dag.getDagUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    Configuration conf = DAGAppMaster.this.getConfig();
                    byte[] oldSha = null;
                    try {
                        Path localFile = DAGAppMaster.findLocalFileForResource(fileName);
                        if (localFile != null) {
                            oldSha = RelocalizationUtils.getLocalSha(localFile, conf);
                        } else {
                            LOG.warn((Object)("Couldn't find local file for " + oldLr));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Error getting SHA from local file for " + oldLr), (Throwable)ex);
                    }
                    if (oldSha == null) {
                        oldSha = RelocalizationUtils.getResourceSha(DAGAppMaster.getLocalResourceUri(oldLr), conf);
                    }
                    byte[] newSha = RelocalizationUtils.getResourceSha(DAGAppMaster.getLocalResourceUri(newLr), conf);
                    return Arrays.equals(oldSha, newSha);
                }
            }) != false;
        }
        catch (InterruptedException ex) {
            throw new TezException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new TezException((Throwable)ex);
        }
    }

    private static Path findLocalFileForResource(String fileName) {
        java.net.URL localResource = ClassLoader.getSystemClassLoader().getResource(fileName);
        if (localResource == null) {
            return null;
        }
        return new Path(localResource.getPath());
    }

    private static URI getLocalResourceUri(LocalResource input) {
        try {
            return TezConverterUtils.getURIFromYarnURL((URL)input.getResource());
        }
        catch (URISyntaxException e) {
            throw new TezUncheckedException("Failed while handling : " + input, (Throwable)e);
        }
    }

    private List<java.net.URL> processAdditionalResources(Map<String, LocalResource> lrDiff) throws TezException {
        List<java.net.URL> downloadedURLs;
        if (lrDiff == null || lrDiff.isEmpty()) {
            return Collections.emptyList();
        }
        LOG.info((Object)("Localizing additional local resources for AM : " + lrDiff));
        try {
            downloadedURLs = RelocalizationUtils.processAdditionalResources(Maps.transformValues(lrDiff, (Function)new Function<LocalResource, URI>(){

                public URI apply(LocalResource input) {
                    return DAGAppMaster.getLocalResourceUri(input);
                }
            }), this.getConfig());
        }
        catch (IOException e) {
            throw new TezException((Throwable)e);
        }
        LOG.info((Object)"Done downloading additional AM resources");
        return downloadedURLs;
    }

    void startServices() {
        try {
            Throwable firstError = null;
            ArrayList<ServiceThread> threads = new ArrayList<ServiceThread>();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Begin parallel start");
            }
            for (ServiceWithDependency sd : this.services.values()) {
                ServiceThread st = new ServiceThread(sd);
                threads.add(st);
            }
            for (ServiceThread st : threads) {
                st.start();
            }
            for (ServiceThread st : threads) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Waiting for service thread to join for " + st.getName()));
                }
                st.join();
                if (st.error == null || firstError != null) continue;
                firstError = st.error;
            }
            if (firstError != null) {
                throw ServiceStateException.convert(firstError);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"End parallel start");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void initServices(Configuration conf) {
        for (ServiceWithDependency sd : this.services.values()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initing service : " + sd.service));
            }
            sd.service.init(conf);
        }
    }

    void stopServices() {
        ArrayList<Service> serviceList = new ArrayList<Service>(this.services.size());
        for (ServiceWithDependency sd : this.services.values()) {
            serviceList.add(sd.service);
        }
        Exception firstException = null;
        for (int i = this.services.size() - 1; i >= 0; --i) {
            Exception ex;
            Service service = (Service)serviceList.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Stopping service : " + service));
            }
            if ((ex = ServiceOperations.stopQuietly((Log)LOG, (Service)service)) == null || firstException != null) continue;
            LOG.warn((Object)("Failed to stop service, name=" + service.getName()), (Throwable)ex);
            firstException = ex;
        }
        if (firstException != null) {
            throw ServiceStateException.convert(firstException);
        }
    }

    private RecoveryParser.RecoveredDAGData recoverDAG() throws IOException, TezException {
        if (this.recoveryEnabled && this.appAttemptID.getAttemptId() > 1) {
            LOG.info((Object)("Recovering data from previous attempts, currentAttemptId=" + this.appAttemptID.getAttemptId()));
            this.state = DAGAppMasterState.RECOVERING;
            RecoveryParser recoveryParser = new RecoveryParser(this, this.recoveryFS, this.recoveryDataDir, this.appAttemptID.getAttemptId());
            RecoveryParser.RecoveredDAGData recoveredDAGData = recoveryParser.parseRecoveryData();
            return recoveredDAGData;
        }
        return null;
    }

    public synchronized void serviceStart() throws Exception {
        RecoveryParser.RecoveredDAGData recoveredDAGData;
        this.startServices();
        super.serviceStart();
        if (this.versionMismatch) {
            this.taskSchedulerEventHandler.setShouldUnregisterFlag();
            this.shutdownHandler.shutdown();
            return;
        }
        DefaultMetricsSystem.initialize((String)"DAGAppMaster");
        this.appsStartTime = this.clock.getTime();
        AMStartedEvent startEvent = new AMStartedEvent(this.appAttemptID, this.appsStartTime, this.appMasterUgi.getShortUserName());
        this.historyEventHandler.handle(new DAGHistoryEvent(startEvent));
        this.lastDAGCompletionTime = this.clock.getTime();
        try {
            recoveredDAGData = this.recoverDAG();
        }
        catch (IOException e) {
            LOG.error((Object)"Error occurred when trying to recover data from previous attempt. Shutting down AM", (Throwable)e);
            this.state = DAGAppMasterState.ERROR;
            this.taskSchedulerEventHandler.setShouldUnregisterFlag();
            this.shutdownHandler.shutdown();
            return;
        }
        if (!this.isSession) {
            LOG.info((Object)"In Non-Session mode.");
        } else {
            LOG.info((Object)"In Session mode. Waiting for DAG over RPC");
            this.state = DAGAppMasterState.IDLE;
        }
        if (recoveredDAGData != null) {
            List<java.net.URL> classpathUrls = null;
            if (recoveredDAGData.cumulativeAdditionalResources != null) {
                classpathUrls = this.processAdditionalResources(recoveredDAGData.cumulativeAdditionalResources);
                this.amResources.putAll(recoveredDAGData.cumulativeAdditionalResources);
                this.cumulativeAdditionalResources.putAll(recoveredDAGData.cumulativeAdditionalResources);
            }
            if (recoveredDAGData.isCompleted || recoveredDAGData.nonRecoverable) {
                LOG.info((Object)("Found previous DAG in completed or non-recoverable state, dagId=" + recoveredDAGData.recoveredDagID + ", isCompleted=" + recoveredDAGData.isCompleted + ", isNonRecoverable=" + recoveredDAGData.nonRecoverable + ", state=" + (recoveredDAGData.dagState == null ? "null" : recoveredDAGData.dagState) + ", failureReason=" + recoveredDAGData.reason));
                this._updateLoggers(recoveredDAGData.recoveredDAG, "");
                if (recoveredDAGData.nonRecoverable) {
                    DAGEventRecoverEvent recoverDAGEvent = new DAGEventRecoverEvent(recoveredDAGData.recoveredDAG.getID(), DAGState.FAILED, classpathUrls);
                    DAGRecoveredEvent dagRecoveredEvent = new DAGRecoveredEvent(this.appAttemptID, recoveredDAGData.recoveredDAG.getID(), recoveredDAGData.recoveredDAG.getName(), recoveredDAGData.recoveredDAG.getUserName(), this.clock.getTime(), DAGState.FAILED, recoveredDAGData.reason);
                    dagRecoveredEvent.setHistoryLoggingEnabled(recoveredDAGData.recoveredDAG.getConf().getBoolean("tez.dag.history.logging.enabled", true));
                    this.historyEventHandler.handle(new DAGHistoryEvent(recoveredDAGData.recoveredDAG.getID(), dagRecoveredEvent));
                    this.dagEventDispatcher.handle(recoverDAGEvent);
                    this.state = DAGAppMasterState.RUNNING;
                } else {
                    DAGEventRecoverEvent recoverDAGEvent = new DAGEventRecoverEvent(recoveredDAGData.recoveredDAG.getID(), recoveredDAGData.dagState, classpathUrls);
                    DAGRecoveredEvent dagRecoveredEvent = new DAGRecoveredEvent(this.appAttemptID, recoveredDAGData.recoveredDAG.getID(), recoveredDAGData.recoveredDAG.getName(), recoveredDAGData.recoveredDAG.getUserName(), this.clock.getTime(), recoveredDAGData.dagState, null);
                    this.historyEventHandler.handle(new DAGHistoryEvent(recoveredDAGData.recoveredDAG.getID(), dagRecoveredEvent));
                    this.dagEventDispatcher.handle(recoverDAGEvent);
                    this.state = DAGAppMasterState.RUNNING;
                }
            } else {
                LOG.info((Object)("Found DAG to recover, dagId=" + recoveredDAGData.recoveredDAG.getID()));
                this._updateLoggers(recoveredDAGData.recoveredDAG, "");
                DAGRecoveredEvent dagRecoveredEvent = new DAGRecoveredEvent(this.appAttemptID, recoveredDAGData.recoveredDAG.getID(), recoveredDAGData.recoveredDAG.getName(), recoveredDAGData.recoveredDAG.getUserName(), this.clock.getTime());
                this.historyEventHandler.handle(new DAGHistoryEvent(recoveredDAGData.recoveredDAG.getID(), dagRecoveredEvent));
                DAGEventRecoverEvent recoverDAGEvent = new DAGEventRecoverEvent(recoveredDAGData.recoveredDAG.getID(), classpathUrls);
                this.dagEventDispatcher.handle(recoverDAGEvent);
                this.state = DAGAppMasterState.RUNNING;
            }
        } else if (!this.isSession) {
            this.dagCounter.set(0);
            this.startDAG();
        }
        if (this.isSession) {
            this.dagSubmissionTimer = new Timer(true);
            this.dagSubmissionTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    DAGAppMaster.this.checkAndHandleSessionTimeout();
                }
            }, this.sessionTimeoutInterval, this.sessionTimeoutInterval / 10L);
        }
    }

    public synchronized void serviceStop() throws Exception {
        if (this.isSession) {
            this.sessionStopped.set(true);
        }
        if (this.dagSubmissionTimer != null) {
            this.dagSubmissionTimer.cancel();
        }
        this.stopServices();
        boolean deleteTezScratchData = this.amConf.getBoolean("tez.am.staging.scratch-data.auto-delete", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking whether tez scratch data dir should be deleted, deleteTezScratchData=" + deleteTezScratchData));
        }
        if (deleteTezScratchData && this.taskSchedulerEventHandler != null && this.taskSchedulerEventHandler.hasUnregistered() && this.tezSystemStagingDir != null) {
            try {
                this.appMasterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        FileSystem fs = DAGAppMaster.this.tezSystemStagingDir.getFileSystem(DAGAppMaster.this.amConf);
                        boolean deletedStagingDir = fs.delete(DAGAppMaster.this.tezSystemStagingDir, true);
                        if (!deletedStagingDir) {
                            LOG.warn((Object)("Failed to delete tez scratch data dir, path=" + DAGAppMaster.this.tezSystemStagingDir));
                        } else {
                            LOG.info((Object)("Completed deletion of tez scratch data dir, path=" + DAGAppMaster.this.tezSystemStagingDir));
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to delete tez scratch data dir", (Throwable)e);
            }
        }
        super.serviceStop();
    }

    AsyncDispatcher createSpeculatorEventDispatcher() {
        AsyncDispatcher dispatcher = new AsyncDispatcher();
        dispatcher.register(SpeculatorEventType.class, (EventHandler)new EventHandler<SpeculatorEvent>(){

            public void handle(SpeculatorEvent event) {
                TezVertexID vertexId;
                DAG dag = DAGAppMaster.this.context.getCurrentDAG();
                Vertex v = dag.getVertex(vertexId = event.getVertexId());
                Preconditions.checkState((v != null ? 1 : 0) != 0, (Object)("Unknown vertex: " + vertexId + " for DAG: " + dag.getID()));
                v.handleSpeculatorEvent(event);
            }
        });
        return dispatcher;
    }

    private static void validateInputParam(String value, String param) throws IOException {
        if (value == null) {
            String msg = param + " is null";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }

    private synchronized void checkAndHandleSessionTimeout() {
        if (EnumSet.of(DAGAppMasterState.RUNNING, DAGAppMasterState.RECOVERING).contains((Object)this.state) || this.sessionStopped.get()) {
            return;
        }
        long currentTime = this.clock.getTime();
        if (currentTime < this.lastDAGCompletionTime + this.sessionTimeoutInterval) {
            return;
        }
        LOG.info((Object)("Session timed out, lastDAGCompletionTime=" + this.lastDAGCompletionTime + " ms" + ", sessionTimeoutInterval=" + this.sessionTimeoutInterval + " ms"));
        this.shutdownTezAM();
    }

    public boolean isSession() {
        return this.isSession;
    }

    public static void main(String[] args) {
        try {
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
            String nodeHostString = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
            String nodePortString = System.getenv(ApplicationConstants.Environment.NM_PORT.name());
            String nodeHttpPortString = System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
            String appSubmitTimeStr = System.getenv("APP_SUBMIT_TIME_ENV");
            String clientVersion = System.getenv("TEZ_CLIENT_VERSION");
            if (clientVersion == null) {
                clientVersion = "Unknown";
            }
            DAGAppMaster.validateInputParam(appSubmitTimeStr, "APP_SUBMIT_TIME_ENV");
            ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            Options opts = new Options();
            opts.addOption("session", false, "Run Tez Application Master in Session mode");
            CommandLine cliParser = new GnuParser().parse(opts, args);
            DAGAppMaster appMaster = new DAGAppMaster(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), (Clock)new SystemClock(), appSubmitTime, cliParser.hasOption("session"), System.getenv(ApplicationConstants.Environment.PWD.name()), clientVersion);
            ShutdownHookManager.get().addShutdownHook((Runnable)new DAGAppMasterShutdownHook(appMaster), 30);
            DAGAppMaster.initAndStartAppMaster(appMaster, jobUserName);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting DAGAppMaster", t);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDAG() throws IOException, TezException {
        FileInputStream dagPBBinaryStream = null;
        try {
            DAGProtos.DAGPlan dagPlan = null;
            dagPBBinaryStream = new FileInputStream(new File(this.workingDirectory, "tez-dag.pb"));
            dagPlan = DAGProtos.DAGPlan.parseFrom((InputStream)dagPBBinaryStream);
            this.startDAG(dagPlan, null);
        }
        finally {
            if (dagPBBinaryStream != null) {
                dagPBBinaryStream.close();
            }
        }
    }

    private void startDAG(DAGProtos.DAGPlan dagPlan, Map<String, LocalResource> additionalAMResources) throws TezException {
        Map<String, LocalResource> lrDiff;
        long submitTime = this.clock.getTime();
        this.state = DAGAppMasterState.RUNNING;
        this.appName = dagPlan.getName();
        if (this.dagNames.contains(dagPlan.getName())) {
            throw new TezException("Duplicate dag name '" + dagPlan.getName() + "'");
        }
        this.dagNames.add(dagPlan.getName());
        DAG newDAG = this.createDAG(dagPlan);
        this._updateLoggers(newDAG, "");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Running a DAG with " + dagPlan.getVertexCount() + " vertices "));
            for (DAGProtos.VertexPlan v : dagPlan.getVertexList()) {
                LOG.debug((Object)("DAG has vertex " + v.getName()));
            }
        }
        if ((lrDiff = this.getAdditionalLocalResourceDiff(newDAG, additionalAMResources)) != null) {
            this.amResources.putAll(lrDiff);
            this.cumulativeAdditionalResources.putAll(lrDiff);
        }
        LOG.info((Object)("Running DAG: " + dagPlan.getName()));
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        System.err.println(timeStamp + " Running Dag: " + newDAG.getID());
        System.out.println(timeStamp + " Running Dag: " + newDAG.getID());
        DAGSubmittedEvent submittedEvent = new DAGSubmittedEvent(newDAG.getID(), submitTime, dagPlan, this.appAttemptID, this.cumulativeAdditionalResources, newDAG.getUserName(), newDAG.getConf());
        boolean dagLoggingEnabled = newDAG.getConf().getBoolean("tez.dag.history.logging.enabled", true);
        submittedEvent.setHistoryLoggingEnabled(dagLoggingEnabled);
        try {
            this.historyEventHandler.handleCriticalEvent(new DAGHistoryEvent(newDAG.getID(), submittedEvent));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.startDAGExecution(newDAG, lrDiff);
    }

    private void startDAGExecution(DAG dag, final Map<String, LocalResource> additionalAmResources) throws TezException {
        List additionalUrlsForClasspath;
        this.currentDAG = dag;
        try {
            additionalUrlsForClasspath = (List)dag.getDagUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<java.net.URL>>(){

                @Override
                public List<java.net.URL> run() throws Exception {
                    return DAGAppMaster.this.processAdditionalResources(additionalAmResources);
                }
            });
        }
        catch (IOException e) {
            throw new TezException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TezException((Throwable)e);
        }
        this.dagIDs.add(this.currentDAG.getID().toString());
        ((RunningAppContext)this.context).setDAG(this.currentDAG);
        DAGEvent initDagEvent = new DAGEvent(this.currentDAG.getID(), DAGEventType.DAG_INIT);
        this.dagEventDispatcher.handle(initDagEvent);
        DAGEventStartDag startDagEvent = new DAGEventStartDag(this.currentDAG.getID(), additionalUrlsForClasspath);
        this.sendEvent((Event<?>)startDagEvent);
    }

    public static void initAndStartAppMaster(final DAGAppMaster appMaster, String jobUserName) throws IOException, InterruptedException {
        final Configuration conf = new Configuration((Configuration)new YarnConfiguration());
        TezUtilsInternal.addUserSpecifiedTezConfiguration((String)appMaster.workingDirectory, (Configuration)conf);
        conf.setBoolean("fs.automatic.close", false);
        Limits.setConfiguration((Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        appMaster.appMasterUgi = UserGroupInformation.createRemoteUser((String)jobUserName);
        appMaster.appMasterUgi.addCredentials(credentials);
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        appMaster.amTokens = credentials;
        appMaster.appMasterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                appMaster.init(conf);
                appMaster.start();
                return null;
            }
        });
    }

    private void sendEvent(Event<?> event) {
        this.dispatcher.getEventHandler().handle(event);
    }

    synchronized void setDAGCounter(int dagCounter) {
        this.dagCounter.set(dagCounter);
    }

    private boolean enableWebUIService() {
        return this.amConf.getBoolean("tez.am.tez-ui.webservice.enable", true);
    }

    static class DAGAppMasterShutdownHook
    implements Runnable {
        DAGAppMaster appMaster;

        DAGAppMasterShutdownHook(DAGAppMaster appMaster) {
            this.appMaster = appMaster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)"DAGAppMasterShutdownHook invoked");
            if (this.appMaster.getServiceState() == Service.STATE.STOPPED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"DAGAppMaster already stopped. Ignoring signal");
                }
                AtomicBoolean atomicBoolean = this.appMaster.shutdownHandlerRunning;
                synchronized (atomicBoolean) {
                    try {
                        if (this.appMaster.shutdownHandlerRunning.get()) {
                            LOG.info((Object)"The shutdown handler is still running, waiting for it to complete");
                            this.appMaster.shutdownHandlerRunning.wait();
                            LOG.info((Object)"The shutdown handler has completed");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
            if (this.appMaster.getServiceState() == Service.STATE.STARTED) {
                LOG.info((Object)"DAGAppMaster received a signal. Signaling TaskScheduler");
                this.appMaster.taskSchedulerEventHandler.setSignalled(true);
            }
            if (EnumSet.of(DAGAppMasterState.NEW, DAGAppMasterState.INITED, DAGAppMasterState.IDLE).contains((Object)this.appMaster.state)) {
                this.appMaster.state = DAGAppMasterState.KILLED;
            } else if (this.appMaster.state == DAGAppMasterState.RUNNING) {
                this.appMaster.state = DAGAppMasterState.ERROR;
            }
            this.appMaster.stop();
        }
    }

    private class VertexEventDispatcher
    implements EventHandler<VertexEvent> {
        private VertexEventDispatcher() {
        }

        public void handle(VertexEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            int eventDagIndex = event.getVertexId().getDAGId().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            Vertex vertex = dag.getVertex(event.getVertexId());
            ((EventHandler)vertex).handle((Event)event);
        }
    }

    private class TaskAttemptEventDispatcher
    implements EventHandler<TaskAttemptEvent> {
        private TaskAttemptEventDispatcher() {
        }

        public void handle(TaskAttemptEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            int eventDagIndex = event.getTaskAttemptID().getTaskID().getVertexID().getDAGId().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            Task task = dag.getVertex(event.getTaskAttemptID().getTaskID().getVertexID()).getTask(event.getTaskAttemptID().getTaskID());
            TaskAttempt attempt = task.getAttempt(event.getTaskAttemptID());
            ((EventHandler)attempt).handle((Event)event);
        }
    }

    private class TaskEventDispatcher
    implements EventHandler<TaskEvent> {
        private TaskEventDispatcher() {
        }

        public void handle(TaskEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            int eventDagIndex = event.getTaskID().getVertexID().getDAGId().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            Task task = dag.getVertex(event.getTaskID().getVertexID()).getTask(event.getTaskID());
            ((EventHandler)task).handle((Event)event);
        }
    }

    private class DagEventDispatcher
    implements EventHandler<DAGEvent> {
        private DagEventDispatcher() {
        }

        public void handle(DAGEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            int eventDagIndex = event.getDAGId().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            ((EventHandler)dag).handle((Event)event);
        }
    }

    private class ServiceThread
    extends Thread {
        final ServiceWithDependency serviceWithDependency;
        Throwable error = null;

        public ServiceThread(ServiceWithDependency serviceWithDependency) {
            this.serviceWithDependency = serviceWithDependency;
            this.setName("ServiceThread:" + serviceWithDependency.service.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Starting thread " + this.serviceWithDependency.service.getName()));
            }
            long start = System.currentTimeMillis();
            try {
                this.serviceWithDependency.start();
            }
            catch (Throwable t) {
                this.error = t;
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Service: " + this.serviceWithDependency.service.getName() + " started in " + (System.currentTimeMillis() - start) + "ms"));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Service thread completed for " + this.serviceWithDependency.service.getName()));
            }
        }
    }

    private class ServiceWithDependency
    implements ServiceStateChangeListener {
        Service service;
        List<Service> dependencies = new ArrayList<Service>();
        AtomicInteger dependenciesStarted = new AtomicInteger(0);
        volatile boolean canStart = false;
        volatile boolean dependenciesFailed = false;

        ServiceWithDependency(Service service) {
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(Service dependency) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Service dependency: " + dependency.getName() + " notify" + " for service: " + this.service.getName()));
            }
            if (dependency.isInState(Service.STATE.STARTED)) {
                if (this.dependenciesStarted.incrementAndGet() == this.dependencies.size()) {
                    ServiceWithDependency serviceWithDependency = this;
                    synchronized (serviceWithDependency) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Service: " + this.service.getName() + " notified to start"));
                        }
                        this.canStart = true;
                        this.notifyAll();
                    }
                }
            } else if (!this.service.isInState(Service.STATE.STARTED) && dependency.getFailureState() != null) {
                ServiceWithDependency serviceWithDependency = this;
                synchronized (serviceWithDependency) {
                    this.dependenciesFailed = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Service: " + this.service.getName() + " will fail to start" + " as dependent service " + dependency.getName() + " failed to start"));
                    }
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() throws InterruptedException {
            if (this.dependencies.size() > 0) {
                ServiceWithDependency serviceWithDependency = this;
                synchronized (serviceWithDependency) {
                    while (!this.canStart) {
                        this.wait(180000L);
                        if (!this.dependenciesFailed) continue;
                        throw new TezUncheckedException("Skipping service start for " + this.service.getName() + " as dependencies failed to start");
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Service: " + this.service.getName() + " trying to start"));
            }
            for (Service dependency : this.dependencies) {
                if (dependency.isInState(Service.STATE.STARTED)) continue;
                LOG.info((Object)("Service: " + this.service.getName() + " not started because " + " service: " + dependency.getName() + " is in state: " + dependency.getServiceState()));
                return;
            }
            this.service.start();
        }
    }

    private class RunningAppContext
    implements AppContext {
        private DAG dag;
        private final Configuration conf;
        private final ClusterInfo clusterInfo = new ClusterInfo();
        private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Lock rLock = this.rwLock.readLock();
        private final Lock wLock = this.rwLock.writeLock();
        private final EventHandler eventHandler;

        public RunningAppContext(Configuration config) {
            Preconditions.checkNotNull((Object)config, (Object)"config is null");
            this.conf = config;
            this.eventHandler = DAGAppMaster.this.dispatcher.getEventHandler();
        }

        @Override
        public DAGAppMaster getAppMaster() {
            return DAGAppMaster.this;
        }

        @Override
        public Configuration getAMConf() {
            return this.conf;
        }

        @Override
        public ApplicationAttemptId getApplicationAttemptId() {
            return DAGAppMaster.this.appAttemptID;
        }

        @Override
        public ApplicationId getApplicationID() {
            return DAGAppMaster.this.appAttemptID.getApplicationId();
        }

        @Override
        public String getApplicationName() {
            return DAGAppMaster.this.appName;
        }

        @Override
        public long getStartTime() {
            return DAGAppMaster.this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DAG getCurrentDAG() {
            try {
                this.rLock.lock();
                DAG dAG = this.dag;
                return dAG;
            }
            finally {
                this.rLock.unlock();
            }
        }

        @Override
        public Set<String> getAllDAGIDs() {
            return DAGAppMaster.this.dagIDs;
        }

        @Override
        public EventHandler getEventHandler() {
            return this.eventHandler;
        }

        @Override
        public String getUser() {
            return this.dag.getUserName();
        }

        @Override
        public Clock getClock() {
            return DAGAppMaster.this.clock;
        }

        @Override
        public ClusterInfo getClusterInfo() {
            return this.clusterInfo;
        }

        @Override
        public AMContainerMap getAllContainers() {
            return DAGAppMaster.this.containers;
        }

        @Override
        public AMNodeTracker getNodeTracker() {
            return DAGAppMaster.this.nodes;
        }

        @Override
        public TaskSchedulerEventHandler getTaskScheduler() {
            return DAGAppMaster.this.taskSchedulerEventHandler;
        }

        @Override
        public boolean isSession() {
            return DAGAppMaster.this.isSession;
        }

        @Override
        public DAGAppMasterState getAMState() {
            return DAGAppMaster.this.state;
        }

        @Override
        public HistoryEventHandler getHistoryHandler() {
            return DAGAppMaster.this.historyEventHandler;
        }

        @Override
        public Path getCurrentRecoveryDir() {
            return DAGAppMaster.this.currentRecoveryDataDir;
        }

        @Override
        public boolean isRecoveryEnabled() {
            return DAGAppMaster.this.recoveryEnabled;
        }

        @Override
        public ACLManager getAMACLManager() {
            return DAGAppMaster.this.aclManager;
        }

        @Override
        public String getAMUser() {
            return DAGAppMaster.this.appMasterUgi.getShortUserName();
        }

        @Override
        public Map<ApplicationAccessType, String> getApplicationACLs() {
            if (DAGAppMaster.this.getServiceState() != Service.STATE.STARTED) {
                throw new TezUncheckedException("Cannot get ApplicationACLs before all services have started");
            }
            return DAGAppMaster.this.taskSchedulerEventHandler.getApplicationAcls();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TezDAGID getCurrentDAGID() {
            try {
                this.rLock.lock();
                if (this.dag != null) {
                    TezDAGID tezDAGID = this.dag.getID();
                    return tezDAGID;
                }
                TezDAGID tezDAGID = null;
                return tezDAGID;
            }
            finally {
                this.rLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDAG(DAG dag) {
            Preconditions.checkNotNull((Object)dag, (Object)"dag is null");
            try {
                this.wLock.lock();
                this.dag = dag;
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    protected class DAGAppMasterShutdownHandler {
        private AtomicBoolean shutdownHandled = new AtomicBoolean(false);

        protected DAGAppMasterShutdownHandler() {
        }

        public void shutdown() {
            this.shutdown(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown(boolean now) {
            LOG.info((Object)"DAGAppMasterShutdownHandler invoked");
            if (!this.shutdownHandled.compareAndSet(false, true)) {
                LOG.info((Object)"Ignoring multiple shutdown events");
                return;
            }
            AtomicBoolean atomicBoolean = DAGAppMaster.this.shutdownHandlerRunning;
            synchronized (atomicBoolean) {
                DAGAppMaster.this.shutdownHandlerRunning.set(true);
            }
            LOG.info((Object)"Handling DAGAppMaster shutdown");
            AMShutdownRunnable r = new AMShutdownRunnable(now);
            Thread t = new Thread((Runnable)r, "AMShutdownThread");
            t.start();
        }

        private class AMShutdownRunnable
        implements Runnable {
            private final boolean immediateShutdown;

            public AMShutdownRunnable(boolean immediateShutdown) {
                this.immediateShutdown = immediateShutdown;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!this.immediateShutdown) {
                    try {
                        LOG.info((Object)"Sleeping for 5 seconds before shutting down");
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    LOG.info((Object)"Calling stop for all the services");
                    DAGAppMaster.this.stop();
                    AtomicBoolean e = DAGAppMaster.this.shutdownHandlerRunning;
                    synchronized (e) {
                        DAGAppMaster.this.shutdownHandlerRunning.set(false);
                        DAGAppMaster.this.shutdownHandlerRunning.notify();
                    }
                    LOG.info((Object)"Exiting DAGAppMaster..GoodBye!");
                    DAGAppMaster.this.sysexit();
                }
                catch (Throwable t) {
                    LOG.warn((Object)"Graceful stop failed ", t);
                }
            }
        }
    }

    private class DAGAppMasterEventHandler
    implements EventHandler<DAGAppMasterEvent> {
        private DAGAppMasterEventHandler() {
        }

        public void handle(DAGAppMasterEvent event) {
            DAGAppMaster.this.handle(event);
        }
    }
}

