/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.tez.common.ContainerContext;
import org.apache.tez.common.ContainerTask;
import org.apache.tez.common.TezTaskUmbilicalProtocol;

public class ContainerReporter
implements Callable<ContainerTask> {
    private static final Logger LOG = Logger.getLogger(ContainerReporter.class);
    private final TezTaskUmbilicalProtocol umbilical;
    private final ContainerContext containerContext;
    private final int getTaskMaxSleepTime;
    private final long LOG_INTERVAL = 2000L;
    private long nextGetTaskPrintTime;

    ContainerReporter(TezTaskUmbilicalProtocol umbilical, ContainerContext containerContext, int getTaskMaxSleepTime) {
        this.umbilical = umbilical;
        this.containerContext = containerContext;
        this.getTaskMaxSleepTime = getTaskMaxSleepTime;
    }

    @Override
    public ContainerTask call() throws Exception {
        ContainerTask containerTask = null;
        LOG.info((Object)("Attempting to fetch new task for container " + this.containerContext.getContainerIdentifier()));
        containerTask = this.umbilical.getTask(this.containerContext);
        long getTaskPollStartTime = System.currentTimeMillis();
        this.nextGetTaskPrintTime = getTaskPollStartTime + 2000L;
        int idle = 1;
        while (containerTask == null) {
            long sleepTimeMilliSecs = Math.min(idle * 10, this.getTaskMaxSleepTime);
            this.maybeLogSleepMessage(sleepTimeMilliSecs);
            TimeUnit.MILLISECONDS.sleep(sleepTimeMilliSecs);
            containerTask = this.umbilical.getTask(this.containerContext);
            ++idle;
        }
        LOG.info((Object)("Got TaskUpdate for containerId= " + this.containerContext.getContainerIdentifier() + ": " + (System.currentTimeMillis() - getTaskPollStartTime) + " ms after starting to poll." + " TaskInfo: shouldDie: " + containerTask.shouldDie() + (containerTask.shouldDie() ? "" : ", currentTaskAttemptId: " + containerTask.getTaskSpec().getTaskAttemptID())));
        return containerTask;
    }

    private void maybeLogSleepMessage(long sleepTimeMilliSecs) {
        long currentTime = System.currentTimeMillis();
        if (sleepTimeMilliSecs + currentTime > this.nextGetTaskPrintTime) {
            LOG.info((Object)("Sleeping for " + sleepTimeMilliSecs + "ms before retrying getTask again. Got null now. " + "Next getTask sleep message after " + 2000L + "ms"));
            this.nextGetTaskPrintTime = currentTime + sleepTimeMilliSecs + 2000L;
        }
    }
}

