/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;

public class ContainerContextMatcher
implements ContainerSignatureMatcher {
    private void checkArguments(Object cs1, Object cs2) {
        Preconditions.checkNotNull((Object)cs1, (Object)"Arguments cannot be null");
        Preconditions.checkNotNull((Object)cs2, (Object)"Arguments cannot be null");
        Preconditions.checkArgument((cs1 instanceof ContainerContext && cs2 instanceof ContainerContext ? 1 : 0) != 0, (Object)("Container context can only compare instances of " + ContainerContext.class.getName() + ", Recevied: " + cs1.getClass().getName() + " and " + cs2.getClass().getName()));
    }

    @Override
    public boolean isSuperSet(Object cs1, Object cs2) {
        this.checkArguments(cs1, cs2);
        ContainerContext context1 = (ContainerContext)cs1;
        ContainerContext context2 = (ContainerContext)cs2;
        return context1.isSuperSet(context2);
    }

    @Override
    public boolean isExactMatch(Object cs1, Object cs2) {
        this.checkArguments(cs1, cs2);
        ContainerContext context1 = (ContainerContext)cs1;
        ContainerContext context2 = (ContainerContext)cs2;
        return context1.isExactMatch(context2);
    }

    @Override
    public Map<String, LocalResource> getAdditionalResources(Map<String, LocalResource> lr1, Map<String, LocalResource> lr2) {
        Preconditions.checkNotNull(lr1);
        Preconditions.checkNotNull(lr2);
        HashMap<String, LocalResource> c2LocalResources = new HashMap<String, LocalResource>(lr2);
        for (Map.Entry<String, LocalResource> c1LocalResource : lr1.entrySet()) {
            c2LocalResources.remove(c1LocalResource.getKey());
        }
        return c2LocalResources;
    }

    @Override
    public Object union(Object cs1, Object cs2) {
        this.checkArguments(cs1, cs2);
        return ContainerContext.union((ContainerContext)cs1, (ContainerContext)cs2);
    }
}

