/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.node;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.rm.AMSchedulerEventNodeBlacklistUpdate;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventNodeFailed;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.node.AMNode;
import org.apache.tez.dag.app.rm.node.AMNodeEvent;
import org.apache.tez.dag.app.rm.node.AMNodeEventContainerAllocated;
import org.apache.tez.dag.app.rm.node.AMNodeEventTaskAttemptEnded;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.AMNodeState;
import org.apache.tez.dag.records.TezTaskAttemptID;

public class AMNodeImpl
implements AMNode {
    private static final Log LOG = LogFactory.getLog(AMNodeImpl.class);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final NodeId nodeId;
    private final AppContext appContext;
    private final int maxTaskFailuresPerNode;
    private boolean blacklistingEnabled;
    private boolean ignoreBlacklisting = false;
    private Set<TezTaskAttemptID> failedAttemptIds = Sets.newHashSet();
    protected EventHandler eventHandler;
    @VisibleForTesting
    final List<ContainerId> containers = new LinkedList<ContainerId>();
    int numFailedTAs = 0;
    int numSuccessfulTAs = 0;
    private final List<ContainerId> pastContainers = new LinkedList<ContainerId>();
    private final StateMachine<AMNodeState, AMNodeEventType, AMNodeEvent> stateMachine;
    private static StateMachineFactory<AMNodeImpl, AMNodeState, AMNodeEventType, AMNodeEvent> stateMachineFactory = new StateMachineFactory((Enum)AMNodeState.ACTIVE).addTransition((Enum)AMNodeState.ACTIVE, (Enum)AMNodeState.ACTIVE, (Enum)AMNodeEventType.N_CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedTransition()).addTransition((Enum)AMNodeState.ACTIVE, (Enum)AMNodeState.ACTIVE, (Enum)AMNodeEventType.N_TA_SUCCEEDED, (SingleArcTransition)new TaskAttemptSucceededTransition()).addTransition((Enum)AMNodeState.ACTIVE, EnumSet.of(AMNodeState.ACTIVE, AMNodeState.BLACKLISTED), (Enum)AMNodeEventType.N_TA_ENDED, (MultipleArcTransition)new TaskAttemptFailedTransition()).addTransition((Enum)AMNodeState.ACTIVE, (Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeEventType.N_TURNED_UNHEALTHY, (SingleArcTransition)new NodeTurnedUnhealthyTransition()).addTransition((Enum)AMNodeState.ACTIVE, EnumSet.of(AMNodeState.ACTIVE, AMNodeState.BLACKLISTED), (Enum)AMNodeEventType.N_IGNORE_BLACKLISTING_DISABLED, (MultipleArcTransition)new IgnoreBlacklistingDisabledTransition()).addTransition((Enum)AMNodeState.ACTIVE, (Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED, (SingleArcTransition)new IgnoreBlacklistingStateChangeTransition(true)).addTransition((Enum)AMNodeState.ACTIVE, (Enum)AMNodeState.ACTIVE, (Enum)AMNodeEventType.N_TURNED_HEALTHY).addTransition((Enum)AMNodeState.BLACKLISTED, (Enum)AMNodeState.BLACKLISTED, (Enum)AMNodeEventType.N_CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedWhileBlacklistedTransition()).addTransition((Enum)AMNodeState.BLACKLISTED, EnumSet.of(AMNodeState.BLACKLISTED, AMNodeState.ACTIVE), (Enum)AMNodeEventType.N_TA_SUCCEEDED, (MultipleArcTransition)new TaskAttemptSucceededWhileBlacklistedTransition()).addTransition((Enum)AMNodeState.BLACKLISTED, (Enum)AMNodeState.BLACKLISTED, (Enum)AMNodeEventType.N_TA_ENDED, (SingleArcTransition)new CountFailedTaskAttemptTransition()).addTransition((Enum)AMNodeState.BLACKLISTED, (Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeEventType.N_TURNED_UNHEALTHY, (SingleArcTransition)new NodeTurnedUnhealthyTransition()).addTransition((Enum)AMNodeState.BLACKLISTED, (Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED, (SingleArcTransition)new IgnoreBlacklistingStateChangeTransition(true)).addTransition((Enum)AMNodeState.BLACKLISTED, (Enum)AMNodeState.BLACKLISTED, EnumSet.of(AMNodeEventType.N_TURNED_HEALTHY, AMNodeEventType.N_IGNORE_BLACKLISTING_DISABLED), (SingleArcTransition)new GenericErrorTransition()).addTransition((Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeEventType.N_CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedTransition()).addTransition((Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeEventType.N_TA_SUCCEEDED, (SingleArcTransition)new TaskAttemptSucceededTransition()).addTransition((Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeEventType.N_TA_ENDED, (SingleArcTransition)new CountFailedTaskAttemptTransition()).addTransition((Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeEventType.N_TURNED_UNHEALTHY, (SingleArcTransition)new NodeTurnedUnhealthyTransition()).addTransition((Enum)AMNodeState.FORCED_ACTIVE, EnumSet.of(AMNodeState.BLACKLISTED, AMNodeState.ACTIVE), (Enum)AMNodeEventType.N_IGNORE_BLACKLISTING_DISABLED, (MultipleArcTransition)new IgnoreBlacklistingDisabledTransition()).addTransition((Enum)AMNodeState.FORCED_ACTIVE, (Enum)AMNodeState.FORCED_ACTIVE, EnumSet.of(AMNodeEventType.N_TURNED_HEALTHY, AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED), (SingleArcTransition)new GenericErrorTransition()).addTransition((Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeEventType.N_CONTAINER_ALLOCATED, (SingleArcTransition)new ContainerAllocatedWhileUnhealthyTransition()).addTransition((Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeState.UNHEALTHY, EnumSet.of(AMNodeEventType.N_TA_SUCCEEDED, AMNodeEventType.N_TA_ENDED)).addTransition((Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeEventType.N_IGNORE_BLACKLISTING_DISABLED, (SingleArcTransition)new IgnoreBlacklistingStateChangeTransition(false)).addTransition((Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeEventType.N_IGNORE_BLACKLISTING_ENABLED, (SingleArcTransition)new IgnoreBlacklistingStateChangeTransition(true)).addTransition((Enum)AMNodeState.UNHEALTHY, EnumSet.of(AMNodeState.ACTIVE, AMNodeState.FORCED_ACTIVE), (Enum)AMNodeEventType.N_TURNED_HEALTHY, (MultipleArcTransition)new NodeTurnedHealthyTransition()).addTransition((Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeState.UNHEALTHY, (Enum)AMNodeEventType.N_TURNED_UNHEALTHY, (SingleArcTransition)new GenericErrorTransition()).installTopology();

    public AMNodeImpl(NodeId nodeId, int maxTaskFailuresPerNode, EventHandler eventHandler, boolean blacklistingEnabled, AppContext appContext) {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.nodeId = nodeId;
        this.appContext = appContext;
        this.eventHandler = eventHandler;
        this.blacklistingEnabled = blacklistingEnabled;
        this.maxTaskFailuresPerNode = maxTaskFailuresPerNode;
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AMNodeState getState() {
        this.readLock.lock();
        try {
            AMNodeState aMNodeState = (AMNodeState)this.stateMachine.getCurrentState();
            return aMNodeState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerId> getContainers() {
        this.readLock.lock();
        try {
            LinkedList<ContainerId> cIds;
            LinkedList<ContainerId> linkedList = cIds = new LinkedList<ContainerId>(this.containers);
            return linkedList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(AMNodeEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing AMNodeEvent " + event.getNodeId() + " of type " + event.getType() + " while in state: " + (Object)((Object)this.getState()) + ". Event: " + (Object)((Object)event)));
        }
        this.writeLock.lock();
        try {
            AMNodeState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle event " + event.getType() + " at current state " + (Object)((Object)oldState) + " for NodeId " + this.nodeId), (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info((Object)("AMNode " + this.nodeId + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected boolean qualifiesForBlacklisting() {
        return this.blacklistingEnabled && this.numFailedTAs >= this.maxTaskFailuresPerNode;
    }

    protected boolean registerBadNodeAndShouldBlacklist() {
        return this.appContext.getNodeTracker().registerBadNodeAndShouldBlacklist(this);
    }

    protected void blacklistSelf() {
        for (ContainerId c : this.containers) {
            this.sendEvent((Event<?>)new AMContainerEventNodeFailed(c, "Node blacklisted"));
        }
        this.pastContainers.addAll(this.containers);
        this.containers.clear();
        this.sendEvent((Event<?>)new AMSchedulerEventNodeBlacklistUpdate(this.getNodeId(), true));
    }

    private void sendEvent(Event<?> event) {
        this.eventHandler.handle(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnhealthy() {
        this.readLock.lock();
        try {
            boolean bl = this.getState() == AMNodeState.UNHEALTHY;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBlacklisted() {
        this.readLock.lock();
        try {
            boolean bl = this.getState() == AMNodeState.BLACKLISTED;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isUsable() {
        return !this.isUnhealthy() && !this.isBlacklisted();
    }

    protected static class NodeTurnedHealthyTransition
    implements MultipleArcTransition<AMNodeImpl, AMNodeEvent, AMNodeState> {
        protected NodeTurnedHealthyTransition() {
        }

        public AMNodeState transition(AMNodeImpl node, AMNodeEvent nEvent) {
            node.pastContainers.addAll(node.containers);
            node.containers.clear();
            if (node.ignoreBlacklisting) {
                return AMNodeState.FORCED_ACTIVE;
            }
            return AMNodeState.ACTIVE;
        }
    }

    protected static class ContainerAllocatedWhileUnhealthyTransition
    implements SingleArcTransition<AMNodeImpl, AMNodeEvent> {
        protected ContainerAllocatedWhileUnhealthyTransition() {
        }

        public void transition(AMNodeImpl node, AMNodeEvent nEvent) {
            AMNodeEventContainerAllocated event = (AMNodeEventContainerAllocated)nEvent;
            LOG.info((Object)("Node: " + node.getNodeId() + " got allocated a contaienr with id: " + event.getContainerId() + " while in UNHEALTHY state. Releasing it."));
            node.sendEvent((Event)new AMContainerEventNodeFailed(event.getContainerId(), "new container assigned on failed node " + node.getNodeId()));
        }
    }

    protected static class GenericErrorTransition
    implements SingleArcTransition<AMNodeImpl, AMNodeEvent> {
        protected GenericErrorTransition() {
        }

        public void transition(AMNodeImpl node, AMNodeEvent nEvent) {
            LOG.warn((Object)("Invalid event: " + nEvent.getType() + " while in state: " + (Object)((Object)node.getState()) + ". Ignoring." + " Event: " + (Object)((Object)nEvent)));
        }
    }

    protected static class CountFailedTaskAttemptTransition
    implements SingleArcTransition<AMNodeImpl, AMNodeEvent> {
        protected CountFailedTaskAttemptTransition() {
        }

        public void transition(AMNodeImpl node, AMNodeEvent nEvent) {
            AMNodeEventTaskAttemptEnded event = (AMNodeEventTaskAttemptEnded)nEvent;
            if (event.failed()) {
                ++node.numFailedTAs;
            }
        }
    }

    protected static class TaskAttemptSucceededWhileBlacklistedTransition
    implements MultipleArcTransition<AMNodeImpl, AMNodeEvent, AMNodeState> {
        protected TaskAttemptSucceededWhileBlacklistedTransition() {
        }

        public AMNodeState transition(AMNodeImpl node, AMNodeEvent nEvent) {
            ++node.numSuccessfulTAs;
            return AMNodeState.BLACKLISTED;
        }
    }

    protected static class ContainerAllocatedWhileBlacklistedTransition
    implements SingleArcTransition<AMNodeImpl, AMNodeEvent> {
        protected ContainerAllocatedWhileBlacklistedTransition() {
        }

        public void transition(AMNodeImpl node, AMNodeEvent nEvent) {
            AMNodeEventContainerAllocated event = (AMNodeEventContainerAllocated)nEvent;
            node.sendEvent((Event)new AMContainerEvent(event.getContainerId(), AMContainerEventType.C_STOP_REQUEST));
        }
    }

    protected static class IgnoreBlacklistingStateChangeTransition
    implements SingleArcTransition<AMNodeImpl, AMNodeEvent> {
        private boolean ignore;

        public IgnoreBlacklistingStateChangeTransition(boolean ignore) {
            this.ignore = ignore;
        }

        public void transition(AMNodeImpl node, AMNodeEvent nEvent) {
            node.ignoreBlacklisting = this.ignore;
            if (node.getState() == AMNodeState.BLACKLISTED) {
                node.sendEvent((Event)new AMSchedulerEventNodeBlacklistUpdate(node.getNodeId(), false));
            }
        }
    }

    protected static class IgnoreBlacklistingDisabledTransition
    implements MultipleArcTransition<AMNodeImpl, AMNodeEvent, AMNodeState> {
        protected IgnoreBlacklistingDisabledTransition() {
        }

        public AMNodeState transition(AMNodeImpl node, AMNodeEvent nEvent) {
            node.ignoreBlacklisting = false;
            if (node.qualifiesForBlacklisting() && node.registerBadNodeAndShouldBlacklist()) {
                LOG.info((Object)("Too many previous task failures after blacklisting re-enabled. Blacklisting node: " + node.getNodeId()));
                node.blacklistSelf();
                return AMNodeState.BLACKLISTED;
            }
            return AMNodeState.ACTIVE;
        }
    }

    protected static class NodeTurnedUnhealthyTransition
    implements SingleArcTransition<AMNodeImpl, AMNodeEvent> {
        protected NodeTurnedUnhealthyTransition() {
        }

        public void transition(AMNodeImpl node, AMNodeEvent nEvent) {
            for (ContainerId c : node.containers) {
                node.sendEvent((Event)new AMContainerEventNodeFailed(c, "Node failed"));
            }
            node.numFailedTAs = 0;
            node.numSuccessfulTAs = 0;
        }
    }

    protected static class TaskAttemptFailedTransition
    implements MultipleArcTransition<AMNodeImpl, AMNodeEvent, AMNodeState> {
        protected TaskAttemptFailedTransition() {
        }

        public AMNodeState transition(AMNodeImpl node, AMNodeEvent nEvent) {
            AMNodeEventTaskAttemptEnded event = (AMNodeEventTaskAttemptEnded)nEvent;
            LOG.info((Object)("Attempt failed on node: " + node.getNodeId() + " TA: " + event.getTaskAttemptId() + " failed: " + event.failed() + " container: " + event.getContainerId() + " numFailedTAs: " + node.numFailedTAs));
            if (event.failed() && node.failedAttemptIds.add(event.getTaskAttemptId())) {
                ++node.numFailedTAs;
                if (node.qualifiesForBlacklisting() && node.registerBadNodeAndShouldBlacklist()) {
                    LOG.info((Object)("Too many task attempt failures. Blacklisting node: " + node.getNodeId()));
                    node.blacklistSelf();
                    return AMNodeState.BLACKLISTED;
                }
            }
            return AMNodeState.ACTIVE;
        }
    }

    protected static class TaskAttemptSucceededTransition
    implements SingleArcTransition<AMNodeImpl, AMNodeEvent> {
        protected TaskAttemptSucceededTransition() {
        }

        public void transition(AMNodeImpl node, AMNodeEvent nEvent) {
            ++node.numSuccessfulTAs;
        }
    }

    protected static class ContainerAllocatedTransition
    implements SingleArcTransition<AMNodeImpl, AMNodeEvent> {
        protected ContainerAllocatedTransition() {
        }

        public void transition(AMNodeImpl node, AMNodeEvent nEvent) {
            AMNodeEventContainerAllocated event = (AMNodeEventContainerAllocated)nEvent;
            node.containers.add(event.getContainerId());
        }
    }
}

