/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class TaskFinishedEvent
implements HistoryEvent {
    private static final Log LOG = LogFactory.getLog(TaskFinishedEvent.class);
    private TezTaskID taskID;
    private String vertexName;
    private long startTime;
    private long finishTime;
    private TaskState state;
    private TezCounters tezCounters;
    private TezTaskAttemptID successfulAttemptID;
    private String diagnostics;

    public TaskFinishedEvent(TezTaskID taskID, String vertexName, long startTime, long finishTime, TezTaskAttemptID successfulAttemptID, TaskState state, String diagnostics, TezCounters counters) {
        this.vertexName = vertexName;
        this.taskID = taskID;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
    }

    public TaskFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_FINISHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskFinishedProto toProto() {
        RecoveryProtos.TaskFinishedProto.Builder builder = RecoveryProtos.TaskFinishedProto.newBuilder();
        builder.setTaskId(this.taskID.toString()).setState(this.state.ordinal()).setFinishTime(this.finishTime);
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        if (this.successfulAttemptID != null) {
            builder.setSuccessfulTaskAttemptId(this.successfulAttemptID.toString());
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.TaskFinishedProto proto) {
        this.taskID = TezTaskID.fromString((String)proto.getTaskId());
        this.finishTime = proto.getFinishTime();
        this.state = TaskState.values()[proto.getState()];
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
        if (proto.hasSuccessfulTaskAttemptId()) {
            this.successfulAttemptID = TezTaskAttemptID.fromString((String)proto.getSuccessfulTaskAttemptId());
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskFinishedProto proto = RecoveryProtos.TaskFinishedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskId=" + this.taskID + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", successfulAttemptID=" + (this.successfulAttemptID == null ? "null" : this.successfulAttemptID.toString()) + ", diagnostics=" + this.diagnostics + ", counters=" + (this.tezCounters == null ? "null" : this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " "));
    }

    public TezTaskID getTaskID() {
        return this.taskID;
    }

    public TaskState getState() {
        return this.state;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public TezCounters getTezCounters() {
        return this.tezCounters;
    }

    public TezTaskAttemptID getSuccessfulAttemptID() {
        return this.successfulAttemptID;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }
}

