/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;

public class TaskAttemptFinishedEvent
implements HistoryEvent {
    private static final Log LOG = LogFactory.getLog(TaskAttemptFinishedEvent.class);
    private TezTaskAttemptID taskAttemptId;
    private String vertexName;
    private long startTime;
    private long finishTime;
    private TaskAttemptState state;
    private String diagnostics;
    private TezCounters tezCounters;

    public TaskAttemptFinishedEvent(TezTaskAttemptID taId, String vertexName, long startTime, long finishTime, TaskAttemptState state, String diagnostics, TezCounters counters) {
        this.taskAttemptId = taId;
        this.vertexName = vertexName;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.diagnostics = diagnostics;
        this.tezCounters = counters;
    }

    public TaskAttemptFinishedEvent() {
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.TASK_ATTEMPT_FINISHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.TaskAttemptFinishedProto toProto() {
        RecoveryProtos.TaskAttemptFinishedProto.Builder builder = RecoveryProtos.TaskAttemptFinishedProto.newBuilder();
        builder.setTaskAttemptId(this.taskAttemptId.toString()).setState(this.state.ordinal()).setFinishTime(this.finishTime);
        if (this.diagnostics != null) {
            builder.setDiagnostics(this.diagnostics);
        }
        if (this.tezCounters != null) {
            builder.setCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)this.tezCounters));
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.TaskAttemptFinishedProto proto) {
        this.taskAttemptId = TezTaskAttemptID.fromString((String)proto.getTaskAttemptId());
        this.finishTime = proto.getFinishTime();
        this.state = TaskAttemptState.values()[proto.getState()];
        if (proto.hasDiagnostics()) {
            this.diagnostics = proto.getDiagnostics();
        }
        if (proto.hasCounters()) {
            this.tezCounters = DagTypeConverters.convertTezCountersFromProto((DAGProtos.TezCountersProto)proto.getCounters());
        }
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        this.toProto().writeDelimitedTo(outputStream);
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        RecoveryProtos.TaskAttemptFinishedProto proto = RecoveryProtos.TaskAttemptFinishedProto.parseDelimitedFrom(inputStream);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexName=" + this.vertexName + ", taskAttemptId=" + this.taskAttemptId + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", timeTaken=" + (this.finishTime - this.startTime) + ", status=" + this.state.name() + ", diagnostics=" + this.diagnostics + ", counters=" + (this.tezCounters == null ? "null" : this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " "));
    }

    public TezTaskAttemptID getTaskAttemptID() {
        return this.taskAttemptId;
    }

    public TezCounters getCounters() {
        return this.tezCounters;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public TaskAttemptState getState() {
        return this.state;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

