/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.log4j.Logger;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.utils.EnvironmentUpdateUtils;

public class LocalClient
extends FrameworkClient {
    public static final Logger LOG = Logger.getLogger(LocalClient.class);
    private volatile DAGAppMaster dagAppMaster = null;
    private volatile DAGClientHandler clientHandler = null;
    private Thread dagAmThread;
    private Configuration conf;
    private final long clusterTimeStamp = System.currentTimeMillis();
    private final long TIME_OUT = 60000L;
    private int appIdNumber = 1;
    private boolean isSession;

    public void init(TezConfiguration tezConf, YarnConfiguration yarnConf) {
        this.conf = yarnConf;
        tezConf.set("fs.defaultFS", "file:///");
        tezConf.setBoolean("tez.ignore.lib.uris", true);
        this.isSession = tezConf.getBoolean("tez.am.mode.session", TezConfiguration.TEZ_AM_SESSION_MODE_DEFAULT);
    }

    public void start() {
    }

    public void stop() {
    }

    public void close() throws IOException {
    }

    public YarnClientApplication createApplication() throws YarnException, IOException {
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        ApplicationId appId = ApplicationId.newInstance((long)this.clusterTimeStamp, (int)this.appIdNumber++);
        context.setApplicationId(appId);
        GetNewApplicationResponse response = (GetNewApplicationResponse)Records.newRecord(GetNewApplicationResponse.class);
        response.setApplicationId(appId);
        return new YarnClientApplication(response, context);
    }

    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) {
        ApplicationId appId = appContext.getApplicationId();
        this.startDAGAppMaster(appContext);
        return appId;
    }

    public void killApplication(ApplicationId appId) {
        this.clientHandler.shutdownAM();
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) {
        ApplicationReport report = (ApplicationReport)Records.newRecord(ApplicationReport.class);
        report.setApplicationId(appId);
        report.setCurrentApplicationAttemptId(this.dagAppMaster.getAttemptID());
        AppContext runningAppContext = this.dagAppMaster.getContext();
        if (runningAppContext != null) {
            DAG dag = runningAppContext.getCurrentDAG();
            if (dag != null) {
                report.setUser(runningAppContext.getUser());
            }
            report.setName(runningAppContext.getApplicationName());
            report.setStartTime(runningAppContext.getStartTime());
        }
        report.setHost(this.dagAppMaster.getAppNMHost());
        report.setRpcPort(this.dagAppMaster.getRpcPort());
        report.setClientToAMToken(null);
        report.setYarnApplicationState(this.convertDAGAppMasterState(this.dagAppMaster.getState()));
        report.setFinalApplicationStatus(this.convertDAGAppMasterStateToFinalYARNState(this.dagAppMaster.getState()));
        List<String> diagnostics = this.dagAppMaster.getDiagnostics();
        if (diagnostics != null) {
            report.setDiagnostics(diagnostics.toString());
        }
        report.setTrackingUrl("N/A");
        report.setFinishTime(0L);
        report.setApplicationResourceUsageReport(null);
        report.setOriginalTrackingUrl("N/A");
        report.setProgress(this.dagAppMaster.getProgress());
        report.setAMRMToken(null);
        return report;
    }

    protected FinalApplicationStatus convertDAGAppMasterStateToFinalYARNState(DAGAppMasterState dagAppMasterState) {
        switch (dagAppMasterState) {
            case NEW: 
            case INITED: 
            case RECOVERING: 
            case IDLE: 
            case RUNNING: {
                return FinalApplicationStatus.UNDEFINED;
            }
            case SUCCEEDED: {
                return FinalApplicationStatus.SUCCEEDED;
            }
            case FAILED: {
                return FinalApplicationStatus.FAILED;
            }
            case KILLED: {
                return FinalApplicationStatus.KILLED;
            }
            case ERROR: {
                return FinalApplicationStatus.FAILED;
            }
        }
        return FinalApplicationStatus.UNDEFINED;
    }

    protected YarnApplicationState convertDAGAppMasterState(DAGAppMasterState dagAppMasterState) {
        switch (dagAppMasterState) {
            case NEW: {
                return YarnApplicationState.NEW;
            }
            case INITED: 
            case RECOVERING: 
            case IDLE: 
            case RUNNING: {
                return YarnApplicationState.RUNNING;
            }
            case SUCCEEDED: {
                return YarnApplicationState.FINISHED;
            }
            case FAILED: {
                return YarnApplicationState.FAILED;
            }
            case KILLED: {
                return YarnApplicationState.KILLED;
            }
            case ERROR: {
                return YarnApplicationState.FAILED;
            }
        }
        return YarnApplicationState.SUBMITTED;
    }

    protected void startDAGAppMaster(ApplicationSubmissionContext appContext) {
        block10: {
            if (this.dagAmThread == null) {
                try {
                    this.dagAmThread = this.createDAGAppMaster(appContext);
                    this.dagAmThread.start();
                    long waitingTime = 0L;
                    while (true) {
                        if (this.dagAppMaster != null) {
                            DAGAppMasterState dagAMState = this.dagAppMaster.getState();
                            LOG.info((Object)("DAGAppMaster state: " + (Object)((Object)dagAMState)));
                            if (dagAMState.equals((Object)DAGAppMasterState.NEW)) {
                                LOG.info((Object)"DAGAppMaster is not started wait for 100ms...");
                            } else {
                                if (!dagAMState.equals((Object)DAGAppMasterState.INITED)) {
                                    if (dagAMState.equals((Object)DAGAppMasterState.ERROR)) {
                                        throw new TezException("DAGAppMaster got an error during initialization");
                                    }
                                    if (dagAMState.equals((Object)DAGAppMasterState.KILLED)) {
                                        throw new TezException("DAGAppMaster is killed");
                                    }
                                    break block10;
                                }
                                LOG.info((Object)"DAGAppMaster is not startetd wait for 100ms...");
                            }
                        }
                        if (waitingTime >= 60000L) break;
                        LOG.info((Object)"DAGAppMaster is not created wait for 100ms...");
                        Thread.sleep(100L);
                        waitingTime += 100L;
                    }
                    throw new TezException("Time out creating DAGAppMaster");
                }
                catch (Throwable t) {
                    LOG.fatal((Object)"Error starting DAGAppMaster", t);
                    this.dagAmThread.interrupt();
                    System.exit(0);
                }
            }
        }
    }

    protected Thread createDAGAppMaster(final ApplicationSubmissionContext appContext) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationId appId = appContext.getApplicationId();
                    Path userDir = TezCommonUtils.getTezSystemStagingPath((Configuration)LocalClient.this.conf, (String)appId.toString());
                    LOG.info((Object)("Using staging directory: " + userDir.toUri().getPath()));
                    FileSystem fs = FileSystem.get((Configuration)LocalClient.this.conf);
                    fs.mkdirs(userDir);
                    Path logDir = new Path(userDir, "localmode-log-dir");
                    Path localDir = new Path(userDir, "localmode-local-dir");
                    fs.mkdirs(logDir);
                    fs.mkdirs(localDir);
                    EnvironmentUpdateUtils.put((String)ApplicationConstants.Environment.LOG_DIRS.name(), (String)logDir.toUri().getPath());
                    EnvironmentUpdateUtils.put((String)ApplicationConstants.Environment.LOCAL_DIRS.name(), (String)localDir.toUri().getPath());
                    UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                    ByteBuffer tokens = appContext.getAMContainerSpec().getTokens();
                    if (tokens != null) {
                        Credentials amCredentials = new Credentials();
                        DataInputByteBuffer dibb = new DataInputByteBuffer();
                        dibb.reset(new ByteBuffer[]{tokens});
                        amCredentials.readTokenStorageStream((DataInputStream)dibb);
                        tokens.rewind();
                        currentUser.addCredentials(amCredentials);
                    }
                    ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
                    ContainerId cId = ContainerId.newInstance((ApplicationAttemptId)applicationAttemptId, (int)1);
                    String currentHost = InetAddress.getLocalHost().getHostName();
                    int nmPort = 0;
                    int nmHttpPort = 8042;
                    long appSubmitTime = System.currentTimeMillis();
                    LocalClient.this.dagAppMaster = new DAGAppMaster(applicationAttemptId, cId, currentHost, nmPort, nmHttpPort, (Clock)new SystemClock(), appSubmitTime, LocalClient.this.isSession, userDir.toUri().getPath());
                    LocalClient.this.clientHandler = new DAGClientHandler(LocalClient.this.dagAppMaster);
                    DAGAppMaster.initAndStartAppMaster(LocalClient.this.dagAppMaster, currentUser.getShortUserName());
                }
                catch (Throwable t) {
                    LOG.fatal((Object)"Error starting DAGAppMaster", t);
                    System.exit(1);
                }
            }
        });
        thread.setName("DAGAppMaster Thread");
        LOG.info((Object)"DAGAppMaster thread has been created");
        return thread;
    }
}

