/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Vector;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.YarnTezDagChild;
import org.apache.hadoop.yarn.api.ApplicationConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TezRuntimeChildJVM {
    private static String getTaskLogFile(LogName filter) {
        return "<LOG_DIR>/" + filter.toString();
    }

    public static List<String> getVMCommand(InetSocketAddress taskAttemptListenerAddr, String containerIdentifier, String tokenIdentifier, int applicationAttemptNumber, boolean shouldProfile, String javaOpts) {
        Vector<String> vargs = new Vector<String>(9);
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
        vargs.add(javaOpts);
        Path childTmpDir = new Path(ApplicationConstants.Environment.PWD.$(), "./tmp");
        vargs.add("-Djava.io.tmpdir=" + childTmpDir);
        if (shouldProfile) {
            // empty if block
        }
        vargs.add(YarnTezDagChild.class.getName());
        vargs.add(taskAttemptListenerAddr.getAddress().getHostAddress());
        vargs.add(Integer.toString(taskAttemptListenerAddr.getPort()));
        vargs.add(containerIdentifier);
        vargs.add(tokenIdentifier);
        vargs.add(Integer.toString(applicationAttemptNumber));
        vargs.add("1>" + TezRuntimeChildJVM.getTaskLogFile(LogName.STDOUT));
        vargs.add("2>" + TezRuntimeChildJVM.getTaskLogFile(LogName.STDERR));
        StringBuilder mergedCommand = new StringBuilder();
        for (String str : vargs) {
            mergedCommand.append((CharSequence)str).append(" ");
        }
        Vector<String> vargsFinal = new Vector<String>(1);
        vargsFinal.add(mergedCommand.toString());
        return vargsFinal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogName {
        STDOUT("stdout"),
        STDERR("stderr"),
        SYSLOG("syslog"),
        PROFILE("profile.out"),
        DEBUGOUT("debugout");

        private String prefix;

        private LogName(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

