/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.avro.DAGFinished;
import org.apache.tez.dag.history.avro.HistoryEventType;
import org.apache.tez.dag.records.TezDAGID;

public class DAGFinishedEvent
implements HistoryEvent {
    private DAGFinished datum = new DAGFinished();
    private final TezCounters tezCounters;

    public DAGFinishedEvent(TezDAGID dagId, long startTime, long finishTime, DAGStatus.State state, String diagnostics, TezCounters counters) {
        this.datum.dagId = dagId.toString();
        this.datum.startTime = startTime;
        this.datum.finishTime = finishTime;
        this.datum.status = state.name();
        this.datum.diagnostics = diagnostics;
        this.tezCounters = counters;
    }

    public HistoryEventType getEventType() {
        return HistoryEventType.DAG_FINISHED;
    }

    public Object getBlob() {
        return this.toString();
    }

    public void setBlob(Object blob) {
        this.datum = (DAGFinished)((Object)blob);
    }

    public String toString() {
        return "dagId=" + this.datum.dagId + ", startTime=" + this.datum.startTime + ", finishTime=" + this.datum.finishTime + ", timeTaken=" + (this.datum.finishTime - this.datum.startTime) + ", status=" + this.datum.status + ", diagnostics=" + this.datum.diagnostics + ", counters=" + this.tezCounters.toString().replaceAll("\\n", ", ").replaceAll("\\s+", " ");
    }
}

