/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.taskclean;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.taskclean.TaskCleaner;
import org.apache.tez.dag.app.taskclean.TaskCleanupEvent;

public class TaskCleanerImpl
extends AbstractService
implements TaskCleaner {
    private static final Log LOG = LogFactory.getLog(TaskCleanerImpl.class);
    private final AppContext context;
    private ThreadPoolExecutor launcherPool;
    private Thread eventHandlingThread;
    private BlockingQueue<TaskCleanupEvent> eventQueue = new LinkedBlockingQueue<TaskCleanupEvent>();

    public TaskCleanerImpl(AppContext context) {
        super("TaskCleaner");
        this.context = context;
    }

    public void serviceStart() {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("TaskCleaner #%d").build();
        this.launcherPool = new ThreadPoolExecutor(5, 5, 1L, TimeUnit.HOURS, new LinkedBlockingQueue<Runnable>(), tf);
        this.eventHandlingThread = new Thread(new Runnable(){

            public void run() {
                TaskCleanupEvent event = null;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        event = (TaskCleanupEvent)((Object)TaskCleanerImpl.this.eventQueue.take());
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Returning, interrupted : " + e));
                        return;
                    }
                    TaskCleanerImpl.this.launcherPool.execute(new EventProcessor(event));
                }
            }
        });
        this.eventHandlingThread.setName("TaskCleaner Event Handler");
        this.eventHandlingThread.start();
    }

    public void serviceStop() {
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        if (this.launcherPool != null) {
            this.launcherPool.shutdown();
        }
        for (TaskCleanupEvent ev : this.eventQueue) {
            LOG.info((Object)("TaskCleaner.stop: Cleanup for: " + ev.getAttemptID()));
            new EventProcessor(ev).run();
        }
    }

    public void handle(TaskCleanupEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    private class EventProcessor
    implements Runnable {
        private TaskCleanupEvent event;

        EventProcessor(TaskCleanupEvent event) {
            this.event = event;
        }

        public void run() {
            LOG.info((Object)("Processing the event " + this.event.toString()));
            try {
                this.event.getCommitter().abortTask(this.event.getAttemptContext());
            }
            catch (Exception e) {
                LOG.warn((Object)("Task cleanup failed for attempt " + this.event.getAttemptID()), (Throwable)e);
            }
        }
    }
}

