/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.utils.TezRuntimeChildJVM;
import org.apache.tez.runtime.library.common.security.TokenCache;
import org.apache.tez.runtime.library.common.shuffle.server.ShuffleHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMContainerHelpers {
    private static final Log LOG = LogFactory.getLog(AMContainerHelpers.class);
    private static Object commonContainerSpecLock = new Object();
    private static TezDAGID lastDAGID = null;
    private static Map<TezDAGID, ContainerLaunchContext> commonContainerSpecs = new HashMap<TezDAGID, ContainerLaunchContext>();

    public static LocalResource createLocalResource(FileSystem fc, Path file, LocalResourceType type, LocalResourceVisibility visibility) throws IOException {
        FileStatus fstat = fc.getFileStatus(file);
        URL resourceURL = ConverterUtils.getYarnUrlFromPath((Path)fc.resolvePath(fstat.getPath()));
        long resourceSize = fstat.getLen();
        long resourceModificationTime = fstat.getModificationTime();
        return LocalResource.newInstance((URL)resourceURL, (LocalResourceType)type, (LocalResourceVisibility)visibility, (long)resourceSize, (long)resourceModificationTime);
    }

    private static ContainerLaunchContext createCommonContainerLaunchContext(Map<ApplicationAccessType, String> applicationACLs, Credentials credentials) {
        HashMap localResources = new HashMap();
        HashMap environment = new HashMap();
        HashMap<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
        ByteBuffer taskCredentialsBuffer = ByteBuffer.wrap(new byte[0]);
        try {
            Credentials taskCredentials = new Credentials();
            LOG.info((Object)("Adding #" + credentials.numberOfTokens() + " tokens and #" + credentials.numberOfSecretKeys() + " secret keys for NM use for launching container"));
            taskCredentials.addAll(credentials);
            DataOutputBuffer containerTokens_dob = new DataOutputBuffer();
            LOG.info((Object)("Size of containertokens_dob is " + taskCredentials.numberOfTokens()));
            taskCredentials.writeTokenStorageToStream((DataOutputStream)containerTokens_dob);
            taskCredentialsBuffer = ByteBuffer.wrap(containerTokens_dob.getData(), 0, containerTokens_dob.getLength());
            LOG.info((Object)"Putting shuffle token in serviceData");
            serviceData.put("mapreduce_shuffle", ShuffleHandler.serializeServiceData((Token)TokenCache.getJobToken((Credentials)taskCredentials)));
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        ContainerLaunchContext container = ContainerLaunchContext.newInstance(localResources, environment, null, serviceData, (ByteBuffer)taskCredentialsBuffer, applicationACLs);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static ContainerLaunchContext createContainerLaunchContext(TezDAGID tezDAGID, Map<ApplicationAccessType, String> acls, ContainerId containerId, Map<String, LocalResource> localResources, Map<String, String> vertexEnv, String javaOpts, TaskAttemptListener taskAttemptListener, Credentials credentials, boolean shouldProfile, AppContext appContext) {
        ContainerLaunchContext commonContainerSpec = null;
        Object object = commonContainerSpecLock;
        synchronized (object) {
            if (!commonContainerSpecs.containsKey(tezDAGID)) {
                commonContainerSpec = AMContainerHelpers.createCommonContainerLaunchContext(acls, credentials);
                commonContainerSpecs.put(tezDAGID, commonContainerSpec);
            } else {
                commonContainerSpec = commonContainerSpecs.get(tezDAGID);
            }
            if (lastDAGID == null) {
                lastDAGID = tezDAGID;
            } else if (!lastDAGID.equals((Object)tezDAGID)) {
                commonContainerSpecs.remove(lastDAGID);
                lastDAGID = tezDAGID;
            }
        }
        TreeMap<String, LocalResource> lResources = new TreeMap<String, LocalResource>();
        lResources.putAll(commonContainerSpec.getLocalResources());
        lResources.putAll(localResources);
        Map env = commonContainerSpec.getEnvironment();
        HashMap<String, String> myEnv = new HashMap<String, String>(env.size());
        myEnv.putAll(env);
        myEnv.putAll(vertexEnv);
        List<String> commands = TezRuntimeChildJVM.getVMCommand(taskAttemptListener.getAddress(), containerId.toString(), appContext.getApplicationID().toString(), appContext.getApplicationAttemptId().getAttemptId(), shouldProfile, javaOpts);
        HashMap myServiceData = new HashMap();
        for (Map.Entry entry : commonContainerSpec.getServiceData().entrySet()) {
            myServiceData.put(entry.getKey(), ((ByteBuffer)entry.getValue()).duplicate());
        }
        ContainerLaunchContext container = ContainerLaunchContext.newInstance(lResources, myEnv, commands, myServiceData, (ByteBuffer)commonContainerSpec.getTokens().duplicate(), acls);
        return container;
    }
}

