/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.Records;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.oldrecords.TaskAttemptReport;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventCounterUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventDiagnosticsUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.DiagnosableEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventDiagnosticsUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventOutputFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStartedRemotely;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStatusUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEventTAUpdate;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImplHelpers;
import org.apache.tez.dag.app.rm.AMSchedulerEventTAEnded;
import org.apache.tez.dag.app.rm.AMSchedulerEventTALaunchRequest;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.TezBuilderUtils;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskAttemptImpl
implements TaskAttempt,
EventHandler<TaskAttemptEvent> {
    private static final Log LOG = LogFactory.getLog(TaskAttemptImpl.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final TezCounters EMPTY_COUNTERS = new TezCounters();
    protected final Configuration conf;
    protected EventHandler eventHandler;
    private final TezTaskAttemptID attemptId;
    private final Clock clock;
    private final List<String> diagnostics = new ArrayList<String>();
    private final Lock readLock;
    private final Lock writeLock;
    protected final AppContext appContext;
    private final TaskHeartbeatHandler taskHeartbeatHandler;
    private long launchTime = 0L;
    private long finishTime = 0L;
    private String trackerName;
    private int httpPort;
    private ContainerId containerId;
    private NodeId containerNodeId;
    private String nodeHttpAddress;
    private String nodeRackName;
    private TaskAttempt.TaskAttemptStatus reportedStatus;
    private DAGCounter localityCounter;
    Set<String> taskHosts = new HashSet<String>();
    Set<String> taskRacks = new HashSet<String>();
    private Set<TezTaskAttemptID> uniquefailedOutputReports = new HashSet<TezTaskAttemptID>();
    private static final double MAX_ALLOWED_OUTPUT_FAILURES_FRACTION = 0.5;
    protected final VertexLocationHint.TaskLocationHint locationHint;
    protected final boolean isRescheduled;
    private final Resource taskResource;
    private final ContainerContext containerContext;
    protected static final FailedTransitionHelper FAILED_HELPER = new FailedTransitionHelper();
    protected static final KilledTransitionHelper KILLED_HELPER = new KilledTransitionHelper();
    private static SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION = new DiagnosticInformationUpdater();
    private static SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> STATUS_UPDATER = new StatusUpdaterTransition();
    private final StateMachine<TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachine;
    private static StateMachineFactory<TaskAttemptImpl, TaskAttemptStateInternal, TaskAttemptEventType, TaskAttemptEvent> stateMachineFactory = new StateMachineFactory((Enum)TaskAttemptStateInternal.NEW).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptEventType.TA_SCHEDULE, (SingleArcTransition)new ScheduleTaskattemptTransition()).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_FAIL_REQUEST, (SingleArcTransition)new TerminateTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.NEW, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminateTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_STARTED_REMOTELY, (SingleArcTransition)new StartedTransition()).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_FAIL_REQUEST, (SingleArcTransition)new TerminatedBeforeRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminatedBeforeRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_NODE_FAILED, (SingleArcTransition)new NodeFailedBeforeRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATING, (SingleArcTransition)new ContainerTerminatingBeforeRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.START_WAIT, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedBeforeRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_STATUS_UPDATE, STATUS_UPDATER).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptEventType.TA_OUTPUT_CONSUMABLE, (SingleArcTransition)new OutputConsumableTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)new SucceededTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_FAILED, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_FAIL_REQUEST, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_NODE_FAILED, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATING, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.RUNNING, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedWhileRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.RUNNING, EnumSet.of(TaskAttemptStateInternal.FAIL_IN_PROGRESS, TaskAttemptStateInternal.RUNNING), (Enum)TaskAttemptEventType.TA_OUTPUT_FAILED, (MultipleArcTransition)new OutputReportedFailedTransition()).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptEventType.TA_STATUS_UPDATE, STATUS_UPDATER).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptEventType.TA_OUTPUT_CONSUMABLE).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DONE, (SingleArcTransition)new SucceededTransition()).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_FAILED, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_TIMED_OUT, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_FAIL_REQUEST, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_NODE_FAILED, (SingleArcTransition)new TerminatedWhileRunningTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATING, (SingleArcTransition)new TerminatedWhileRunningTransition(FAILED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedBeforeRunningTransition()).addTransition((Enum)TaskAttemptStateInternal.OUTPUT_CONSUMABLE, EnumSet.of(TaskAttemptStateInternal.FAIL_IN_PROGRESS, TaskAttemptStateInternal.OUTPUT_CONSUMABLE), (Enum)TaskAttemptEventType.TA_OUTPUT_FAILED, (MultipleArcTransition)new OutputReportedFailedTransition()).addTransition((Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedWhileTerminating()).addTransition((Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.KILL_IN_PROGRESS, EnumSet.of(TaskAttemptEventType.TA_STARTED_REMOTELY, new TaskAttemptEventType[]{TaskAttemptEventType.TA_STATUS_UPDATE, TaskAttemptEventType.TA_OUTPUT_CONSUMABLE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILED, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_FAIL_REQUEST, TaskAttemptEventType.TA_KILL_REQUEST, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_OUTPUT_FAILED})).addTransition((Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_CONTAINER_TERMINATED, (SingleArcTransition)new ContainerCompletedWhileTerminating()).addTransition((Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, (Enum)TaskAttemptStateInternal.FAIL_IN_PROGRESS, EnumSet.of(TaskAttemptEventType.TA_STARTED_REMOTELY, new TaskAttemptEventType[]{TaskAttemptEventType.TA_STATUS_UPDATE, TaskAttemptEventType.TA_OUTPUT_CONSUMABLE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILED, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_FAIL_REQUEST, TaskAttemptEventType.TA_KILL_REQUEST, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_OUTPUT_FAILED})).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptStateInternal.KILLED, EnumSet.of(TaskAttemptEventType.TA_STARTED_REMOTELY, new TaskAttemptEventType[]{TaskAttemptEventType.TA_STATUS_UPDATE, TaskAttemptEventType.TA_OUTPUT_CONSUMABLE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILED, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_FAIL_REQUEST, TaskAttemptEventType.TA_KILL_REQUEST, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_OUTPUT_FAILED})).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.FAILED, (Enum)TaskAttemptStateInternal.FAILED, EnumSet.of(TaskAttemptEventType.TA_STARTED_REMOTELY, new TaskAttemptEventType[]{TaskAttemptEventType.TA_STATUS_UPDATE, TaskAttemptEventType.TA_OUTPUT_CONSUMABLE, TaskAttemptEventType.TA_COMMIT_PENDING, TaskAttemptEventType.TA_DONE, TaskAttemptEventType.TA_FAILED, TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_FAIL_REQUEST, TaskAttemptEventType.TA_KILL_REQUEST, TaskAttemptEventType.TA_NODE_FAILED, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATED, TaskAttemptEventType.TA_OUTPUT_FAILED})).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptEventType.TA_DIAGNOSTICS_UPDATE, DIAGNOSTIC_INFORMATION_UPDATE_TRANSITION).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_KILL_REQUEST, (SingleArcTransition)new TerminatedAfterSuccessTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.KILLED, (Enum)TaskAttemptEventType.TA_NODE_FAILED, (SingleArcTransition)new TerminatedAfterSuccessTransition(KILLED_HELPER)).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.SUCCEEDED), (Enum)TaskAttemptEventType.TA_OUTPUT_FAILED, (MultipleArcTransition)new OutputReportedFailedTransition()).addTransition((Enum)TaskAttemptStateInternal.SUCCEEDED, (Enum)TaskAttemptStateInternal.SUCCEEDED, EnumSet.of(TaskAttemptEventType.TA_TIMED_OUT, TaskAttemptEventType.TA_FAIL_REQUEST, TaskAttemptEventType.TA_CONTAINER_TERMINATING, TaskAttemptEventType.TA_CONTAINER_TERMINATED)).installTopology();

    public TaskAttemptImpl(TezTaskID taskId, int attemptNumber, EventHandler eventHandler, TaskAttemptListener tal, Configuration conf, Clock clock, TaskHeartbeatHandler taskHeartbeatHandler, AppContext appContext, VertexLocationHint.TaskLocationHint locationHint, boolean isRescheduled, Resource resource, ContainerContext containerContext) {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.attemptId = TezBuilderUtils.newTaskAttemptId(taskId, attemptNumber);
        this.eventHandler = eventHandler;
        this.conf = conf;
        this.clock = clock;
        this.taskHeartbeatHandler = taskHeartbeatHandler;
        this.appContext = appContext;
        this.reportedStatus = new TaskAttempt.TaskAttemptStatus();
        this.initTaskAttemptStatus(this.reportedStatus);
        RackResolver.init((Configuration)conf);
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.locationHint = locationHint;
        this.isRescheduled = isRescheduled;
        this.taskResource = resource;
        this.containerContext = containerContext;
    }

    @Override
    public TezTaskAttemptID getID() {
        return this.attemptId;
    }

    @Override
    public TezTaskID getTaskID() {
        return this.attemptId.getTaskID();
    }

    @Override
    public TezVertexID getVertexID() {
        return this.attemptId.getTaskID().getVertexID();
    }

    @Override
    public TezDAGID getDAGID() {
        return this.getVertexID().getDAGId();
    }

    TaskSpec createRemoteTaskSpec() {
        Vertex vertex = this.getVertex();
        ProcessorDescriptor procDesc = vertex.getProcessorDescriptor();
        DAG dag = vertex.getDAG();
        int taskId = this.getTaskID().getId();
        return new TaskSpec(this.getID(), dag.getUserName(), vertex.getName(), procDesc, vertex.getInputSpecList(taskId), vertex.getOutputSpecList(taskId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttemptReport getReport() {
        TaskAttemptReport result = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        this.readLock.lock();
        try {
            result.setTaskAttemptId(this.attemptId);
            result.setTaskAttemptState(this.getState());
            result.setProgress(this.reportedStatus.progress);
            result.setStartTime(this.launchTime);
            result.setFinishTime(this.finishTime);
            result.setDiagnosticInfo(StringUtils.join((CharSequence)LINE_SEPARATOR, this.getDiagnostics()));
            result.setCounters(this.getCounters());
            result.setContainerId(this.getAssignedContainerID());
            result.setNodeManagerHost(this.trackerName);
            result.setNodeManagerHttpPort(this.httpPort);
            if (this.containerNodeId != null) {
                result.setNodeManagerPort(this.containerNodeId.getPort());
            }
            TaskAttemptReport taskAttemptReport = result;
            return taskAttemptReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDiagnostics() {
        ArrayList<String> result = new ArrayList<String>();
        this.readLock.lock();
        try {
            result.addAll(this.diagnostics);
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TezCounters getCounters() {
        this.readLock.lock();
        try {
            this.reportedStatus.setLocalityCounter(this.localityCounter);
            TezCounters counters = this.reportedStatus.counters;
            if (counters == null) {
                counters = EMPTY_COUNTERS;
            }
            TezCounters tezCounters = counters;
            return tezCounters;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.reportedStatus.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskAttemptState getState() {
        this.readLock.lock();
        try {
            TaskAttemptState taskAttemptState = this.getStateNoLock();
            return taskAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public TaskAttemptState getStateNoLock() {
        return TaskAttemptImpl.getExternalState((TaskAttemptStateInternal)this.stateMachine.getCurrentState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = EnumSet.of(TaskAttemptStateInternal.SUCCEEDED, TaskAttemptStateInternal.FAILED, TaskAttemptStateInternal.FAIL_IN_PROGRESS, TaskAttemptStateInternal.KILLED, TaskAttemptStateInternal.KILL_IN_PROGRESS).contains((Object)this.getInternalState());
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerId getAssignedContainerID() {
        this.readLock.lock();
        try {
            ContainerId containerId = this.containerId;
            return containerId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAssignedContainerMgrAddress() {
        this.readLock.lock();
        try {
            String string = this.containerNodeId.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeId getNodeId() {
        this.readLock.lock();
        try {
            NodeId nodeId = this.containerNodeId;
            return nodeId;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeHttpAddress() {
        this.readLock.lock();
        try {
            String string = this.nodeHttpAddress;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNodeRackName() {
        this.readLock.lock();
        try {
            String string = this.nodeRackName;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLaunchTime() {
        this.readLock.lock();
        try {
            long l = this.launchTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Task getTask() {
        return this.appContext.getCurrentDAG().getVertex(this.attemptId.getTaskID().getVertexID()).getTask(this.attemptId.getTaskID());
    }

    Vertex getVertex() {
        return this.appContext.getCurrentDAG().getVertex(this.attemptId.getTaskID().getVertexID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(TaskAttemptEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing TaskAttemptEvent " + event.getTaskAttemptID() + " of type " + event.getType() + " while in state " + (Object)((Object)this.getInternalState()) + ". Event: " + (Object)((Object)event)));
        }
        this.writeLock.lock();
        try {
            TaskAttemptStateInternal oldState = this.getInternalState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)("Can't handle this event at current state for " + this.attemptId), (Throwable)e);
                this.eventHandler.handle((Event)new DAGEventDiagnosticsUpdate(this.attemptId.getTaskID().getVertexID().getDAGId(), "Invalid event " + event.getType() + " on TaskAttempt " + this.attemptId));
                this.eventHandler.handle((Event)new DAGEvent(this.attemptId.getTaskID().getVertexID().getDAGId(), DAGEventType.INTERNAL_ERROR));
            }
            if (oldState != this.getInternalState()) {
                LOG.info((Object)(this.attemptId + " TaskAttempt Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getInternalState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TaskAttemptStateInternal getInternalState() {
        this.readLock.lock();
        try {
            TaskAttemptStateInternal taskAttemptStateInternal = (TaskAttemptStateInternal)this.stateMachine.getCurrentState();
            return taskAttemptStateInternal;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static TaskAttemptState getExternalState(TaskAttemptStateInternal smState) {
        switch (smState) {
            case NEW: 
            case START_WAIT: {
                return TaskAttemptState.STARTING;
            }
            case RUNNING: 
            case OUTPUT_CONSUMABLE: {
                return TaskAttemptState.RUNNING;
            }
            case FAILED: 
            case FAIL_IN_PROGRESS: {
                return TaskAttemptState.FAILED;
            }
            case KILLED: 
            case KILL_IN_PROGRESS: {
                return TaskAttemptState.KILLED;
            }
            case SUCCEEDED: {
                return TaskAttemptState.SUCCEEDED;
            }
        }
        throw new TezUncheckedException("Attempt to convert invalid stateMachineTaskAttemptState to externalTaskAttemptState: " + (Object)((Object)smState));
    }

    @Override
    public boolean getIsRescheduled() {
        return this.isRescheduled;
    }

    private void sendEvent(Event<?> event) {
        this.eventHandler.handle(event);
    }

    private void setFinishTime() {
        if (this.launchTime != 0L && this.finishTime == 0L) {
            this.finishTime = this.clock.getTime();
        }
    }

    private static DAGEventCounterUpdate createJobCounterUpdateEventTALaunched(TaskAttemptImpl ta) {
        DAGEventCounterUpdate jce = new DAGEventCounterUpdate(ta.getDAGID());
        jce.addCounterUpdate((Enum<?>)DAGCounter.TOTAL_LAUNCHED_TASKS, 1L);
        return jce;
    }

    private static DAGEventCounterUpdate createJobCounterUpdateEventSlotMillis(TaskAttemptImpl ta) {
        DAGEventCounterUpdate jce = new DAGEventCounterUpdate(ta.getDAGID());
        return jce;
    }

    private static DAGEventCounterUpdate createJobCounterUpdateEventTATerminated(TaskAttemptImpl taskAttempt, boolean taskAlreadyCompleted, TaskAttemptStateInternal taState) {
        DAGEventCounterUpdate jce = new DAGEventCounterUpdate(taskAttempt.getDAGID());
        if (taState == TaskAttemptStateInternal.FAILED) {
            jce.addCounterUpdate((Enum<?>)DAGCounter.NUM_FAILED_TASKS, 1L);
        } else if (taState == TaskAttemptStateInternal.KILLED) {
            jce.addCounterUpdate((Enum<?>)DAGCounter.NUM_KILLED_TASKS, 1L);
        }
        return jce;
    }

    private void updateProgressSplits() {
    }

    private void sendTaskAttemptCleanupEvent() {
    }

    protected String[] resolveHosts(String[] src) {
        return TaskAttemptImplHelpers.resolveHosts(src);
    }

    protected void logJobHistoryAttemptStarted() {
        String containerIdStr = this.containerId.toString();
        String inProgressLogsUrl = this.nodeHttpAddress + "/" + "node/containerlogs" + "/" + containerIdStr + "/" + this.appContext.getUser();
        String completedLogsUrl = "";
        if (this.conf.getBoolean("yarn.log-aggregation-enable", false) && this.conf.get("yarn.log.server.url") != null) {
            String contextStr = "v_" + this.getTask().getVertex().getName() + "_" + this.attemptId.toString();
            completedLogsUrl = this.conf.get("yarn.log.server.url") + "/" + this.containerNodeId.toString() + "/" + containerIdStr + "/" + contextStr + "/" + this.appContext.getUser();
        }
        TaskAttemptStartedEvent startEvt = new TaskAttemptStartedEvent(this.attemptId, this.getTask().getVertex().getName(), this.launchTime, this.containerId, this.containerNodeId, inProgressLogsUrl, completedLogsUrl);
        this.eventHandler.handle((Event)new DAGHistoryEvent(startEvt));
    }

    protected void logJobHistoryAttemptFinishedEvent(TaskAttemptStateInternal state) {
        if (this.getLaunchTime() == 0L) {
            return;
        }
        TaskAttemptFinishedEvent finishEvt = new TaskAttemptFinishedEvent(this.attemptId, this.getTask().getVertex().getName(), this.getLaunchTime(), this.getFinishTime(), TaskAttemptState.SUCCEEDED, "", this.getCounters());
        this.eventHandler.handle((Event)new DAGHistoryEvent(finishEvt));
    }

    protected void logJobHistoryAttemptUnsuccesfulCompletion(TaskAttemptState state) {
        TaskAttemptFinishedEvent finishEvt = new TaskAttemptFinishedEvent(this.attemptId, this.getTask().getVertex().getName(), this.getLaunchTime(), this.clock.getTime(), state, StringUtils.join((CharSequence)LINE_SEPARATOR, this.getDiagnostics()), this.getCounters());
        this.eventHandler.handle((Event)new DAGHistoryEvent(finishEvt));
    }

    private void initTaskAttemptStatus(TaskAttempt.TaskAttemptStatus result) {
        result.progress = 0.0f;
        result.state = TaskAttemptState.NEW;
    }

    private void addDiagnosticInfo(String diag) {
        if (diag != null && !diag.equals("")) {
            this.diagnostics.add(diag);
        }
    }

    public String toString() {
        return this.getID().toString();
    }

    protected static class KilledTransitionHelper
    implements TerminatedTransitionHelper {
        protected KilledTransitionHelper() {
        }

        public TaskAttemptStateInternal getTaskAttemptStateInternal() {
            return TaskAttemptStateInternal.KILLED;
        }

        public TaskAttemptState getTaskAttemptState() {
            return TaskAttemptState.KILLED;
        }

        public TaskEventType getTaskEventType() {
            return TaskEventType.T_ATTEMPT_KILLED;
        }
    }

    protected static class FailedTransitionHelper
    implements TerminatedTransitionHelper {
        protected FailedTransitionHelper() {
        }

        public TaskAttemptStateInternal getTaskAttemptStateInternal() {
            return TaskAttemptStateInternal.FAILED;
        }

        public TaskAttemptState getTaskAttemptState() {
            return TaskAttemptState.FAILED;
        }

        public TaskEventType getTaskEventType() {
            return TaskEventType.T_ATTEMPT_FAILED;
        }
    }

    protected static interface TerminatedTransitionHelper {
        public TaskAttemptStateInternal getTaskAttemptStateInternal();

        public TaskAttemptState getTaskAttemptState();

        public TaskEventType getTaskEventType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OutputReportedFailedTransition
    implements MultipleArcTransition<TaskAttemptImpl, TaskAttemptEvent, TaskAttemptStateInternal> {
        protected OutputReportedFailedTransition() {
        }

        public TaskAttemptStateInternal transition(TaskAttemptImpl attempt, TaskAttemptEvent event) {
            TaskAttemptEventOutputFailed outputFailedEvent = (TaskAttemptEventOutputFailed)event;
            TezEvent tezEvent = outputFailedEvent.getInputFailedEvent();
            TezTaskAttemptID failedDestTaId = tezEvent.getSourceInfo().getTaskAttemptID();
            InputReadErrorEvent readErrorEvent = (InputReadErrorEvent)tezEvent.getEvent();
            int failedInputIndexOnDestTa = readErrorEvent.getIndex();
            if (readErrorEvent.getVersion() != attempt.getID().getId()) {
                throw new TezUncheckedException(attempt.getID() + " incorrectly blamed for read error from " + failedDestTaId + " at inputIndex " + failedInputIndexOnDestTa + " version" + readErrorEvent.getVersion());
            }
            LOG.info((Object)(attempt.getID() + " blamed for read error from " + failedDestTaId + " at inputIndex " + failedInputIndexOnDestTa));
            attempt.uniquefailedOutputReports.add(failedDestTaId);
            float failureFraction = (float)attempt.uniquefailedOutputReports.size() / (float)outputFailedEvent.getConsumerTaskNumber();
            if ((double)failureFraction <= 0.5) {
                return attempt.getInternalState();
            }
            String message = attempt.getID() + " being failed for too many output errors";
            LOG.info((Object)message);
            attempt.addDiagnosticInfo(message);
            if (attempt.getInternalState() == TaskAttemptStateInternal.SUCCEEDED) {
                new TerminatedAfterSuccessTransition(FAILED_HELPER).transition(attempt, event);
                return TaskAttemptStateInternal.FAILED;
            }
            new TerminatedWhileRunningTransition(FAILED_HELPER).transition(attempt, event);
            return TaskAttemptStateInternal.FAIL_IN_PROGRESS;
        }
    }

    protected static class TerminatedAfterSuccessTransition
    extends TerminatedBeforeRunningTransition {
        protected boolean sendSchedulerEvent() {
            return false;
        }

        public TerminatedAfterSuccessTransition(TerminatedTransitionHelper helper) {
            super(helper);
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            ta.sendTaskAttemptCleanupEvent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ContainerCompletedWhileTerminating
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected ContainerCompletedWhileTerminating() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            ta.sendTaskAttemptCleanupEvent();
            TaskAttemptEventContainerTerminated tEvent = (TaskAttemptEventContainerTerminated)event;
            ta.addDiagnosticInfo(tEvent.getDiagnosticInfo());
        }
    }

    protected static class ContainerCompletedWhileRunningTransition
    extends TerminatedBeforeRunningTransition {
        public ContainerCompletedWhileRunningTransition() {
            super(FAILED_HELPER);
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            ta.sendTaskAttemptCleanupEvent();
        }
    }

    protected static class TerminatedWhileRunningTransition
    extends TerminatedBeforeRunningTransition {
        public TerminatedWhileRunningTransition(TerminatedTransitionHelper helper) {
            super(helper);
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            ta.taskHeartbeatHandler.unregister(ta.attemptId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SucceededTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected SucceededTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            ta.setFinishTime();
            ta.logJobHistoryAttemptFinishedEvent(TaskAttemptStateInternal.SUCCEEDED);
            ta.sendEvent((Event)TaskAttemptImpl.createJobCounterUpdateEventSlotMillis(ta));
            ta.sendEvent((Event)new AMSchedulerEventTAEnded(ta, ta.containerId, TaskAttemptState.SUCCEEDED));
            ta.sendEvent((Event)new TaskEventTAUpdate(ta.attemptId, TaskEventType.T_ATTEMPT_SUCCEEDED));
            ta.taskHeartbeatHandler.unregister(ta.attemptId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OutputConsumableTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected OutputConsumableTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            ta.sendEvent((Event)new TaskEventTAUpdate(ta.attemptId, TaskEventType.T_ATTEMPT_OUTPUT_CONSUMABLE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StatusUpdaterTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected StatusUpdaterTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            TaskStatusUpdateEvent statusEvent = ((TaskAttemptEventStatusUpdate)event).getStatusEvent();
            ((TaskAttemptImpl)ta).reportedStatus.state = ta.getState();
            ((TaskAttemptImpl)ta).reportedStatus.progress = statusEvent.getProgress();
            ((TaskAttemptImpl)ta).reportedStatus.counters = statusEvent.getCounters();
            ta.updateProgressSplits();
        }
    }

    protected static class ContainerCompletedBeforeRunningTransition
    extends TerminatedBeforeRunningTransition {
        public ContainerCompletedBeforeRunningTransition() {
            super(FAILED_HELPER);
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            ta.sendTaskAttemptCleanupEvent();
        }
    }

    protected static class ContainerTerminatingBeforeRunningTransition
    extends TerminatedBeforeRunningTransition {
        public ContainerTerminatingBeforeRunningTransition() {
            super(FAILED_HELPER);
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
        }
    }

    protected static class NodeFailedBeforeRunningTransition
    extends TerminatedBeforeRunningTransition {
        public NodeFailedBeforeRunningTransition() {
            super(KILLED_HELPER);
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
        }
    }

    protected static class TerminatedBeforeRunningTransition
    extends TerminateTransition {
        public TerminatedBeforeRunningTransition(TerminatedTransitionHelper helper) {
            super(helper);
        }

        protected boolean sendSchedulerEvent() {
            return true;
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            super.transition(ta, event);
            if (this.sendSchedulerEvent()) {
                ta.sendEvent((Event)new AMSchedulerEventTAEnded(ta, ta.containerId, this.helper.getTaskAttemptState()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StartedTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected StartedTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent origEvent) {
            TaskAttemptEventStartedRemotely event = (TaskAttemptEventStartedRemotely)origEvent;
            Container container = ta.appContext.getAllContainers().get(event.getContainerId()).getContainer();
            ta.containerId = event.getContainerId();
            ta.containerNodeId = container.getNodeId();
            ta.nodeHttpAddress = container.getNodeHttpAddress();
            ta.nodeRackName = RackResolver.resolve((String)ta.containerNodeId.getHost()).getNetworkLocation();
            ta.launchTime = ta.clock.getTime();
            InetSocketAddress nodeHttpInetAddr = NetUtils.createSocketAddr((String)ta.nodeHttpAddress);
            ta.trackerName = nodeHttpInetAddr.getHostName();
            ta.httpPort = nodeHttpInetAddr.getPort();
            ta.sendEvent((Event)TaskAttemptImpl.createJobCounterUpdateEventTALaunched(ta));
            LOG.info((Object)("TaskAttempt: [" + ta.attemptId + "] started." + " Is using containerId: [" + ta.containerId + "]" + " on NM: [" + ta.containerNodeId + "]"));
            ta.logJobHistoryAttemptStarted();
            if (ta.taskHosts.contains(ta.containerNodeId.getHost())) {
                ta.localityCounter = DAGCounter.DATA_LOCAL_TASKS;
            } else if (ta.taskRacks.contains(ta.nodeRackName)) {
                ta.localityCounter = DAGCounter.RACK_LOCAL_TASKS;
            } else if (ta.locationHint != null) {
                ta.localityCounter = DAGCounter.OTHER_LOCAL_TASKS;
            }
            ta.sendEvent((Event)new TaskEventTAUpdate(ta.attemptId, TaskEventType.T_ATTEMPT_LAUNCHED));
            ta.taskHeartbeatHandler.register(ta.attemptId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TerminateTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        TerminatedTransitionHelper helper;

        public TerminateTransition(TerminatedTransitionHelper helper) {
            this.helper = helper;
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            ta.setFinishTime();
            if (event instanceof DiagnosableEvent) {
                ta.addDiagnosticInfo(((DiagnosableEvent)((Object)event)).getDiagnosticInfo());
            }
            ta.sendEvent((Event)TaskAttemptImpl.createJobCounterUpdateEventTATerminated(ta, false, this.helper.getTaskAttemptStateInternal()));
            if (ta.getLaunchTime() != 0L) {
                ta.logJobHistoryAttemptUnsuccesfulCompletion(this.helper.getTaskAttemptState());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not generating HistoryFinish event since start event not generated for taskAttempt: " + ta.getID()));
            }
            ta.sendEvent((Event)new TaskEventTAUpdate(ta.attemptId, this.helper.getTaskEventType()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DiagnosticInformationUpdater
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected DiagnosticInformationUpdater() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            TaskAttemptEventDiagnosticsUpdate diagEvent = (TaskAttemptEventDiagnosticsUpdate)event;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Diagnostics update for " + ta.attemptId + ": " + diagEvent.getDiagnosticInfo()));
            }
            ta.addDiagnosticInfo(diagEvent.getDiagnosticInfo());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ScheduleTaskattemptTransition
    implements SingleArcTransition<TaskAttemptImpl, TaskAttemptEvent> {
        protected ScheduleTaskattemptTransition() {
        }

        public void transition(TaskAttemptImpl ta, TaskAttemptEvent event) {
            TaskAttemptEventSchedule scheduleEvent = (TaskAttemptEventSchedule)event;
            TaskSpec remoteTaskSpec = ta.createRemoteTaskSpec();
            String[] requestHosts = new String[]{};
            String[] requestRacks = new String[]{};
            HashSet<String> racks = new HashSet<String>();
            if (ta.locationHint != null) {
                if (ta.locationHint.getRacks() != null) {
                    racks.addAll(ta.locationHint.getRacks());
                }
                if (ta.locationHint.getDataLocalHosts() != null) {
                    for (String host : ta.locationHint.getDataLocalHosts()) {
                        racks.add(RackResolver.resolve((String)host).getNetworkLocation());
                    }
                    requestHosts = ta.resolveHosts(ta.locationHint.getDataLocalHosts().toArray(new String[ta.locationHint.getDataLocalHosts().size()]));
                }
            }
            requestRacks = racks.toArray(new String[racks.size()]);
            ta.taskHosts.addAll(Arrays.asList(requestHosts));
            ta.taskRacks = racks;
            if (ta.isRescheduled) {
                requestHosts = new String[]{};
                requestRacks = new String[]{};
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Asking for container launch with taskAttemptContext: " + remoteTaskSpec));
            }
            AMSchedulerEventTALaunchRequest launchRequestEvent = new AMSchedulerEventTALaunchRequest(ta.attemptId, ta.taskResource, remoteTaskSpec, ta, requestHosts, requestRacks, scheduleEvent.getPriority(), ta.containerContext);
            ta.sendEvent((Event)launchRequestEvent);
        }
    }
}

