/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.client.ProgressBuilder;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.EdgeManager;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.VertexTerminationCause;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.app.dag.impl.RootInputLeafOutputDescriptor;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Vertex
extends Comparable<Vertex> {
    public TezVertexID getVertexId();

    public DAGProtos.VertexPlan getVertexPlan();

    public int getDistanceFromRoot();

    public String getName();

    public VertexState getState();

    public TezCounters getAllCounters();

    public Map<TezTaskID, Task> getTasks();

    public Task getTask(TezTaskID var1);

    public Task getTask(int var1);

    public List<String> getDiagnostics();

    public int getTotalTasks();

    public int getCompletedTasks();

    public int getSucceededTasks();

    public int getRunningTasks();

    public float getProgress();

    public ProgressBuilder getVertexProgress();

    public VertexStatusBuilder getVertexStatus(Set<StatusGetOpts> var1);

    public void setParallelism(int var1, Map<Vertex, EdgeManager> var2);

    public void setVertexLocationHint(VertexLocationHint var1);

    public void setInputVertices(Map<Vertex, Edge> var1);

    public void setOutputVertices(Map<Vertex, Edge> var1);

    public Map<Vertex, Edge> getInputVertices();

    public Map<Vertex, Edge> getOutputVertices();

    public void setAdditionalInputs(List<DAGProtos.RootInputLeafOutputProto> var1);

    public void setAdditionalOutputs(List<DAGProtos.RootInputLeafOutputProto> var1);

    public Map<String, RootInputLeafOutputDescriptor<InputDescriptor>> getAdditionalInputs();

    public Map<String, RootInputLeafOutputDescriptor<OutputDescriptor>> getAdditionalOutputs();

    public List<InputSpec> getInputSpecList(int var1);

    public List<OutputSpec> getOutputSpecList(int var1);

    public int getInputVerticesCount();

    public int getOutputVerticesCount();

    public void scheduleTasks(Collection<TezTaskID> var1);

    public Resource getTaskResource();

    public ProcessorDescriptor getProcessorDescriptor();

    public DAG getDAG();

    public VertexTerminationCause getTerminationCause();
}

