/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputFailed;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputInitialized;
import org.apache.tez.dag.app.dag.impl.RootInputLeafOutputDescriptor;
import org.apache.tez.dag.app.dag.impl.TezRootInputInitializerContextImpl;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.TezRootInputInitializer;
import org.apache.tez.runtime.api.TezRootInputInitializerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootInputInitializerRunner {
    private static final Log LOG = LogFactory.getLog(RootInputInitializerRunner.class);
    private final ExecutorService rawExecutor;
    private final ListeningExecutorService executor;
    private final String dagName;
    private final String vertexName;
    private final TezVertexID vertexID;
    private final int numTasks;
    private final EventHandler eventHandler;
    private volatile boolean isStopped = false;

    public RootInputInitializerRunner(String dagName, String vertexName, TezVertexID vertexID, EventHandler eventHandler, int numTasks) {
        this.dagName = dagName;
        this.vertexName = vertexName;
        this.vertexID = vertexID;
        this.eventHandler = eventHandler;
        this.numTasks = numTasks;
        this.rawExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("InputInitializer [" + this.vertexName + "] #%d").build());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)this.rawExecutor);
    }

    public void runInputInitializers(List<RootInputLeafOutputDescriptor<InputDescriptor>> inputs) {
        for (RootInputLeafOutputDescriptor<InputDescriptor> input : inputs) {
            ListenableFuture future = this.executor.submit((Callable)new InputInitializerCallable(input, this.vertexID, this.dagName, this.vertexName, this.numTasks));
            Futures.addCallback((ListenableFuture)future, (FutureCallback)this.createInputInitializerCallback(input.getEntityName()));
        }
    }

    @VisibleForTesting
    protected InputInitializerCallback createInputInitializerCallback(String entityName) {
        return new InputInitializerCallback(entityName, this.eventHandler, this.vertexID);
    }

    public void shutdown() {
        if (this.executor != null && !this.isStopped) {
            this.executor.shutdownNow();
            this.isStopped = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @VisibleForTesting
    private static class InputInitializerCallback
    implements FutureCallback<List<org.apache.tez.runtime.api.Event>> {
        private final String inputName;
        private final EventHandler eventHandler;
        private final TezVertexID vertexID;

        public InputInitializerCallback(String inputName, EventHandler eventHandler, TezVertexID vertexID) {
            this.inputName = inputName;
            this.eventHandler = eventHandler;
            this.vertexID = vertexID;
        }

        public void onSuccess(List<org.apache.tez.runtime.api.Event> result) {
            this.eventHandler.handle((Event)new VertexEventRootInputInitialized(this.vertexID, this.inputName, result));
        }

        public void onFailure(Throwable t) {
            this.eventHandler.handle((Event)new VertexEventRootInputFailed(this.vertexID, this.inputName, t));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputInitializerCallable
    implements Callable<List<org.apache.tez.runtime.api.Event>> {
        private final RootInputLeafOutputDescriptor<InputDescriptor> input;
        private final TezVertexID vertexID;
        private final String dagName;
        private final String vertexName;
        private final int numTasks;

        public InputInitializerCallable(RootInputLeafOutputDescriptor<InputDescriptor> input, TezVertexID vertexID, String dagName, String vertexName, int numTasks) {
            this.input = input;
            this.vertexID = vertexID;
            this.dagName = dagName;
            this.vertexName = vertexName;
            this.numTasks = numTasks;
        }

        @Override
        public List<org.apache.tez.runtime.api.Event> call() throws Exception {
            TezRootInputInitializer initializer = this.createInitializer();
            TezRootInputInitializerContextImpl context = new TezRootInputInitializerContextImpl(this.vertexID, this.dagName, this.vertexName, this.input.getEntityName(), this.input.getDescriptor(), this.numTasks);
            return initializer.initialize((TezRootInputInitializerContext)context);
        }

        private TezRootInputInitializer createInitializer() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            String className = this.input.getInitializerClassName();
            Class<?> clazz = Class.forName(className);
            TezRootInputInitializer initializer = (TezRootInputInitializer)clazz.newInstance();
            return initializer;
        }
    }
}

