/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.client.DAGStatusBuilder;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGReport;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DAG {
    public TezDAGID getID();

    public String getName();

    public DAGState getState();

    public DAGReport getReport();

    public TezCounters getAllCounters();

    public Vertex getVertex(String var1);

    public Map<TezVertexID, Vertex> getVertices();

    public Vertex getVertex(TezVertexID var1);

    public List<String> getDiagnostics();

    public int getTotalVertices();

    public int getSuccessfulVertices();

    public float getProgress();

    public boolean isUber();

    public String getUserName();

    public String getQueueName();

    public Configuration getConf();

    public DAGProtos.DAGPlan getJobPlan();

    public DAGStatusBuilder getDAGStatus(Set<StatusGetOpts> var1);

    public VertexStatusBuilder getVertexStatus(String var1, Set<StatusGetOpts> var2);

    public boolean isComplete();

    public Map<ApplicationAccessType, String> getJobACLs();

    public boolean checkAccess(UserGroupInformation var1, ApplicationAccessType var2);
}

