/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPBServerImpl;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.app.DAGAppMaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAGClientServer
extends AbstractService {
    static final Log LOG = LogFactory.getLog(DAGClientServer.class);
    ClientToAMTokenSecretManager secretManager;
    DAGAppMaster.DAGClientHandler realInstance;
    RPC.Server server;
    InetSocketAddress bindAddress;

    public DAGClientServer(DAGAppMaster.DAGClientHandler realInstance, ApplicationAttemptId attemptId) {
        super("DAGClientRPCServer");
        this.realInstance = realInstance;
        this.secretManager = new ClientToAMTokenSecretManager(attemptId, null);
    }

    public void serviceStart() {
        try {
            Configuration conf = this.getConfig();
            InetSocketAddress addr = new InetSocketAddress(0);
            DAGClientAMProtocolBlockingPBServerImpl service = new DAGClientAMProtocolBlockingPBServerImpl(this.realInstance);
            BlockingService blockingService = DAGClientAMProtocolRPC.DAGClientAMProtocol.newReflectiveBlockingService((DAGClientAMProtocolRPC.DAGClientAMProtocol.BlockingInterface)service);
            int numHandlers = conf.getInt("tez.am.client.am.thread-count", 1);
            String portRange = conf.get("tez.am.client.am.port-range");
            this.server = this.createServer(DAGClientAMProtocolBlockingPB.class, addr, conf, numHandlers, blockingService, portRange);
            this.server.start();
            this.bindAddress = NetUtils.getConnectAddress((Server)this.server);
            LOG.info((Object)("Instantiated DAGClientRPCServer at " + this.bindAddress));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to start DAGClientServer: ", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
    }

    public void serviceStop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setClientAMSecretKey(ByteBuffer key) {
        if (key != null && key.hasRemaining()) {
            this.secretManager.setMasterKey(key.array());
        }
    }

    private RPC.Server createServer(Class<?> pbProtocol, InetSocketAddress addr, Configuration conf, int numHandlers, BlockingService blockingService, String portRangeConfig) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, pbProtocol, ProtobufRpcEngine.class);
        RPC.Server server = new RPC.Builder(conf).setProtocol(pbProtocol).setInstance((Object)blockingService).setBindAddress(addr.getHostName()).setPort(addr.getPort()).setNumHandlers(numHandlers).setVerbose(false).setPortRangeConfig(portRangeConfig).setSecretManager((SecretManager)this.secretManager).build();
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, pbProtocol, (Object)blockingService);
        return server;
    }
}

