/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.AMRMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezAMRMClientAsync<T extends AMRMClient.ContainerRequest>
extends AMRMClientAsyncImpl<T> {
    private static final Logger LOG = LoggerFactory.getLogger(TezAMRMClientAsync.class);
    private TreeMap<Priority, LocalityRequestCounter> knownRequestsByPriority = new TreeMap();

    public static <T extends AMRMClient.ContainerRequest> TezAMRMClientAsync<T> createAMRMClientAsync(int intervalMs, AMRMClientAsync.CallbackHandler callbackHandler) {
        return new TezAMRMClientAsync<T>(intervalMs, callbackHandler);
    }

    public TezAMRMClientAsync(int intervalMs, AMRMClientAsync.CallbackHandler callbackHandler) {
        super((AMRMClient)new AMRMClientImpl(), intervalMs, callbackHandler);
    }

    public TezAMRMClientAsync(AMRMClient<T> client, int intervalMs, AMRMClientAsync.CallbackHandler callbackHandler) {
        super(client, intervalMs, callbackHandler);
    }

    public synchronized Priority getTopPriority() {
        if (this.knownRequestsByPriority.isEmpty()) {
            return null;
        }
        return this.knownRequestsByPriority.lastKey();
    }

    public synchronized void addNodeToBlacklist(NodeId nodeId) {
        this.client.updateBlacklist(Collections.singletonList(nodeId.getHost()), null);
    }

    public synchronized void removeNodeFromBlacklist(NodeId nodeId) {
        this.client.updateBlacklist(null, Collections.singletonList(nodeId.getHost()));
    }

    public synchronized void addContainerRequest(T req) {
        super.addContainerRequest(req);
        boolean hasLocality = req.getNodes() != null && !req.getNodes().isEmpty() || req.getRacks() != null && !req.getRacks().isEmpty();
        LocalityRequestCounter lrc = this.knownRequestsByPriority.get(req.getPriority());
        if (lrc == null) {
            lrc = new LocalityRequestCounter();
            this.knownRequestsByPriority.put(req.getPriority(), lrc);
        }
        if (hasLocality) {
            lrc.localityRequests.incrementAndGet();
        } else {
            lrc.noLocalityRequests.incrementAndGet();
        }
    }

    public synchronized void removeContainerRequest(T req) {
        super.removeContainerRequest(req);
        boolean hasLocality = req.getNodes() != null && !req.getNodes().isEmpty() || req.getRacks() != null && !req.getRacks().isEmpty();
        LocalityRequestCounter lrc = this.knownRequestsByPriority.get(req.getPriority());
        if (hasLocality) {
            lrc.localityRequests.decrementAndGet();
        } else {
            lrc.noLocalityRequests.decrementAndGet();
        }
        if (lrc.localityRequests.get() == 0 && lrc.noLocalityRequests.get() == 0) {
            this.knownRequestsByPriority.remove(req.getPriority());
        }
    }

    public synchronized List<? extends Collection<T>> getMatchingRequestsForTopPriority(String resourceName, Resource capability) {
        List matched;
        Map.Entry<Priority, LocalityRequestCounter> entry = this.knownRequestsByPriority.lastEntry();
        if (entry == null || entry.getValue() == null) {
            return Collections.emptyList();
        }
        Priority p = entry.getKey();
        LocalityRequestCounter lrc = entry.getValue();
        if (lrc.localityRequests.get() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Over-ridding location request for matching containers as there are no pending requests that require locality at this priority, priority=" + p + ", localityRequests=" + lrc.localityRequests + ", noLocalityRequests=" + lrc.noLocalityRequests);
            }
            resourceName = "*";
        }
        if ((matched = this.getMatchingRequests(p, resourceName, capability)) != null && !matched.isEmpty()) {
            return matched;
        }
        return Collections.emptyList();
    }

    private static class LocalityRequestCounter {
        final AtomicInteger localityRequests = new AtomicInteger(0);
        final AtomicInteger noLocalityRequests = new AtomicInteger(0);
    }
}

