/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskAttemptImplHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAttemptImplHelpers.class);
    private static final Pattern ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    private TaskAttemptImplHelpers() {
    }

    static String[] resolveHosts(String[] src) {
        String[] result = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            result[i] = TaskAttemptImplHelpers.isIP(src[i]) ? TaskAttemptImplHelpers.resolveHost(src[i]) : src[i];
        }
        return result;
    }

    static String resolveHost(String src) {
        String result = src;
        try {
            InetAddress addr = InetAddress.getByName(src);
            result = addr.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("Failed to resolve address: " + src + ". Continuing to use the same.");
        }
        return result;
    }

    static boolean isIP(String src) {
        return ipPattern.matcher(src).matches();
    }
}

