/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.web;

import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.YarnWebParams;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.web.ProfileServlet;
import org.apache.tez.common.web.ServletToControllerAdapters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.web.AMWebController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebUIService
extends AbstractService {
    private static final String WS_PREFIX = "/ui/ws/v1/tez/";
    private static final String WS_PREFIX_V2 = "/ui/ws/v2/tez/";
    public static final String VERTEX_ID = "vertexID";
    public static final String DAG_ID = "dagID";
    public static final String TASK_ID = "taskID";
    public static final String ATTEMPT_ID = "attemptID";
    public static final String COUNTERS = "counters";
    public static final String LIMIT = "limit";
    private static final Logger LOG = LoggerFactory.getLogger(WebUIService.class);
    private final AppContext context;
    private TezAMWebApp tezAMWebApp;
    private WebApp webApp;
    private String baseUrl = "";
    private String trackingUrl = "";
    private String historyUrl = "";

    public WebUIService(AppContext context) {
        super(WebUIService.class.getName());
        this.context = context;
        this.tezAMWebApp = new TezAMWebApp(context);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        Configuration config = new Configuration(conf);
        if (this.historyUrl == null || this.historyUrl.isEmpty()) {
            LOG.error("Tez UI History URL is not set");
        } else {
            LOG.info("Tez UI History URL: " + this.historyUrl);
        }
        if (this.tezAMWebApp != null) {
            this.tezAMWebApp.setHistoryUrl(this.historyUrl);
        }
        super.serviceInit(config);
    }

    protected void serviceStart() throws Exception {
        if (this.tezAMWebApp != null) {
            Configuration conf = this.getConfig();
            conf.set("hadoop.http.filter.initializers", "org.apache.hadoop.yarn.server.webproxy.amfilter.AmFilterInitializer");
            try {
                conf.set("yarn.http.policy", "HTTP_ONLY");
                if (conf.get("tez.am.tez-ui.webservice.port-range") == null) {
                    conf.set("tez.am.tez-ui.webservice.port-range", "50000-50050");
                    LOG.info("Using default port range for WebUIService: " + conf.get("tez.am.tez-ui.webservice.port-range"));
                }
                this.webApp = WebApps.$for((Object)((Object)this.tezAMWebApp)).with(conf).withPortRange(conf, "tez.am.tez-ui.webservice.port-range").start((WebApp)this.tezAMWebApp);
                InetSocketAddress address = this.webApp.getListenerAddress();
                if (address != null) {
                    InetSocketAddress bindAddress = NetUtils.createSocketAddrForHost((String)this.context.getAppMaster().getAppNMHost(), (int)address.getPort());
                    String hostname = this.context.getAppMaster().getAppNMHost();
                    int port = address.getPort();
                    if (bindAddress.getAddress() != null && bindAddress.getAddress().getCanonicalHostName() != null) {
                        hostname = bindAddress.getAddress().getCanonicalHostName();
                    } else {
                        LOG.warn("Failed to resolve canonical hostname for " + this.context.getAppMaster().getAppNMHost());
                    }
                    this.baseUrl = "http://" + hostname + ":" + port;
                    this.trackingUrl = this.baseUrl + "/ui/";
                    LOG.info("Instantiated WebUIService at " + this.trackingUrl);
                }
            }
            catch (Exception e) {
                LOG.error("Tez UI WebService failed to start.", (Throwable)e);
                throw new TezUncheckedException((Throwable)e);
            }
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            LOG.debug("Stopping WebApp");
            this.webApp.stop();
        }
        super.serviceStop();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getTrackingURL() {
        return this.trackingUrl;
    }

    public String getHistoryUrl() {
        return this.historyUrl;
    }

    public void setHistoryUrl(String historyUrl) {
        this.historyUrl = historyUrl;
    }

    private static class TezAMWebApp
    extends WebApp
    implements YarnWebParams {
        private String historyUrl;
        AppContext context;

        public TezAMWebApp(AppContext context) {
            this.context = context;
        }

        public void setHistoryUrl(String historyUrl) {
            this.historyUrl = historyUrl;
        }

        public void setup() {
            Preconditions.checkArgument((this.historyUrl != null ? 1 : 0) != 0);
            this.bind(AppContext.class).toInstance((Object)this.context);
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"TezUIHistoryURL")).toInstance((Object)this.historyUrl);
            this.route("/", AMWebController.class, "ui");
            this.route("/ui", AMWebController.class, "ui");
            this.route("/main", AMWebController.class, "main");
            this.route("/ui/ws/v1/tez/about", AMWebController.class, "about");
            this.route(WebUIService.WS_PREFIX + StringHelper.pajoin((Object[])new Object[]{"dagProgress", WebUIService.DAG_ID}), AMWebController.class, "getDagProgress");
            this.route(WebUIService.WS_PREFIX + StringHelper.pajoin((Object[])new Object[]{"vertexProgress", WebUIService.VERTEX_ID}), AMWebController.class, "getVertexProgress");
            this.route(WebUIService.WS_PREFIX + StringHelper.pajoin((Object[])new Object[]{"vertexProgresses", WebUIService.VERTEX_ID, WebUIService.DAG_ID}), AMWebController.class, "getVertexProgresses");
            this.route(WebUIService.WS_PREFIX_V2 + StringHelper.pajoin((Object[])new Object[]{"dagInfo", WebUIService.DAG_ID}), AMWebController.class, "getDagInfo");
            this.route(WebUIService.WS_PREFIX_V2 + StringHelper.pajoin((Object[])new Object[]{"verticesInfo", WebUIService.VERTEX_ID, WebUIService.DAG_ID}), AMWebController.class, "getVerticesInfo");
            this.route(WebUIService.WS_PREFIX_V2 + StringHelper.pajoin((Object[])new Object[]{"tasksInfo", WebUIService.TASK_ID, WebUIService.VERTEX_ID, WebUIService.DAG_ID}), AMWebController.class, "getTasksInfo");
            this.route(WebUIService.WS_PREFIX_V2 + StringHelper.pajoin((Object[])new Object[]{"attemptsInfo", WebUIService.ATTEMPT_ID, WebUIService.DAG_ID}), AMWebController.class, "getAttemptsInfo");
            this.route("/jmx", ServletToControllerAdapters.JMXJsonServletController.class);
            this.route("/conf", ServletToControllerAdapters.ConfServletController.class);
            this.route("/stacks", ServletToControllerAdapters.StackServletController.class);
            String asyncProfilerHome = ProfileServlet.getAsyncProfilerHome();
            if (asyncProfilerHome != null && !asyncProfilerHome.trim().isEmpty()) {
                Path tmpDir = Paths.get(ProfileServlet.OUTPUT_DIR, new String[0]);
                try {
                    Files.createDirectories(tmpDir, new FileAttribute[0]);
                    this.route("/prof", ServletToControllerAdapters.ProfileServletController.class);
                    this.route("/prof-output", ServletToControllerAdapters.ProfileOutputServletController.class);
                }
                catch (IOException e) {
                    LOG.info("Could not create directory for profiler output: {} Disabling /prof endpoint... ", (Object)tmpDir);
                }
            } else {
                LOG.info("ASYNC_PROFILER_HOME env or -Dasync.profiler.home not specified. Disabling /prof endpoint..");
            }
        }
    }
}

