/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez;

import java.io.File;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.event.Event;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGScheduler;
import org.apache.tez.dag.app.dag.DAGTerminationCause;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventTerminateDag;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.utils.Graph;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static Pattern sanitizeLabelPattern = Pattern.compile("[:\\-\\W]+");

    public static String getContainerLauncherIdentifierString(int launcherIndex, AppContext appContext) {
        String name;
        try {
            name = appContext.getContainerLauncherName(launcherIndex);
        }
        catch (Exception e) {
            LOG.error("Unable to get launcher name for index: " + launcherIndex + ", falling back to reporting the index");
            return "[" + String.valueOf(launcherIndex) + "]";
        }
        return "[" + launcherIndex + ":" + name + "]";
    }

    public static String getTaskCommIdentifierString(int taskCommIndex, AppContext appContext) {
        String name;
        try {
            name = appContext.getTaskCommunicatorName(taskCommIndex);
        }
        catch (Exception e) {
            LOG.error("Unable to get taskcomm name for index: " + taskCommIndex + ", falling back to reporting the index");
            return "[" + String.valueOf(taskCommIndex) + "]";
        }
        return "[" + taskCommIndex + ":" + name + "]";
    }

    public static String getTaskSchedulerIdentifierString(int schedulerIndex, AppContext appContext) {
        String name;
        try {
            name = appContext.getTaskSchedulerName(schedulerIndex);
        }
        catch (Exception e) {
            LOG.error("Unable to get scheduler name for index: " + schedulerIndex + ", falling back to reporting the index");
            return "[" + String.valueOf(schedulerIndex) + "]";
        }
        return "[" + schedulerIndex + ":" + name + "]";
    }

    public static void processNonFatalServiceErrorReport(String entityString, ServicePluginError servicePluginError, String diagnostics, DagInfo dagInfo, AppContext appContext, String componentName) {
        String message = "Error reported by " + componentName + " [" + entityString + "][" + servicePluginError + "] " + (diagnostics == null ? "" : diagnostics);
        if (dagInfo != null) {
            DAG dag = appContext.getCurrentDAG();
            if (dag != null && dag.getID().getId() == dagInfo.getIndex()) {
                TezDAGID dagId = dag.getID();
                LOG.warn(message + ", Failing dag: [" + dagInfo.getName() + ", " + dagId + "]");
                Utils.sendEvent(appContext, new DAGEventTerminateDag(dagId, DAGTerminationCause.SERVICE_PLUGIN_ERROR, message));
            }
        } else {
            LOG.warn("No current dag name provided. Not acting on " + message);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void generateDAGVizFile(DAG dag, DAGProtos.DAGPlan dagPB, String[] logDirs, @Nullable DAGScheduler scheduler) {
        void var7_16;
        void var7_13;
        TezDAGID dagId = dag.getID();
        HashMap<String, Vertex> nameToVertex = null;
        if (scheduler != null) {
            nameToVertex = new HashMap<String, Vertex>(dag.getVertices().size());
            for (Vertex vertex : dag.getVertices().values()) {
                nameToVertex.put(vertex.getName(), vertex);
            }
        }
        Graph graph = new Graph(Utils.sanitizeLabelForViz(dagPB.getName()));
        for (DAGProtos.VertexPlan vertexPlan : dagPB.getVertexList()) {
            Vertex vertex;
            StringBuilder nodeLabel = new StringBuilder(Utils.sanitizeLabelForViz(vertexPlan.getName()) + "[" + Utils.getShortClassName(vertexPlan.getProcessorDescriptor().getClassName()));
            if (scheduler != null && (vertex = (Vertex)nameToVertex.get(vertexPlan.getName())) != null) {
                try {
                    int priority = (scheduler.getPriorityLowLimit(dag, vertex) + scheduler.getPriorityHighLimit(dag, vertex)) / 2;
                    nodeLabel.append(", priority=").append(priority).append("]");
                }
                catch (UnsupportedOperationException e) {
                    LOG.info("The DAG graphviz file with priorities will not be generate since the scheduler " + scheduler.getClass().getSimpleName() + " doesn't override the methods to get the priorities");
                    return;
                }
            }
            Graph.Node n = graph.newNode(Utils.sanitizeLabelForViz(vertexPlan.getName()), nodeLabel.toString());
            for (DAGProtos.RootInputLeafOutputProto input : vertexPlan.getInputsList()) {
                Graph.Node inputNode = graph.getNode(Utils.sanitizeLabelForViz(vertexPlan.getName()) + "_" + Utils.sanitizeLabelForViz(input.getName()));
                inputNode.setLabel(Utils.sanitizeLabelForViz(vertexPlan.getName()) + "[" + Utils.sanitizeLabelForViz(input.getName()) + "]");
                inputNode.setShape("box");
                inputNode.addEdge(n, "Input [inputClass=" + Utils.getShortClassName(input.getIODescriptor().getClassName()) + ", initializer=" + Utils.getShortClassName(input.getControllerDescriptor().getClassName()) + "]");
            }
            for (DAGProtos.RootInputLeafOutputProto output : vertexPlan.getOutputsList()) {
                Graph.Node outputNode = graph.getNode(Utils.sanitizeLabelForViz(vertexPlan.getName()) + "_" + Utils.sanitizeLabelForViz(output.getName()));
                outputNode.setLabel(Utils.sanitizeLabelForViz(vertexPlan.getName()) + "[" + Utils.sanitizeLabelForViz(output.getName()) + "]");
                outputNode.setShape("box");
                n.addEdge(outputNode, "Output [outputClass=" + Utils.getShortClassName(output.getIODescriptor().getClassName()) + ", committer=" + Utils.getShortClassName(output.getControllerDescriptor().getClassName()) + "]");
            }
        }
        for (DAGProtos.EdgePlan e : dagPB.getEdgeList()) {
            Graph.Node n = graph.getNode(Utils.sanitizeLabelForViz(e.getInputVertexName()));
            n.addEdge(graph.getNode(Utils.sanitizeLabelForViz(e.getOutputVertexName())), "[input=" + Utils.getShortClassName(e.getEdgeSource().getClassName()) + ", output=" + Utils.getShortClassName(e.getEdgeDestination().getClassName()) + ", dataMovement=" + e.getDataMovementType().name().trim() + ", schedulingType=" + e.getSchedulingType().name().trim() + "]");
        }
        String string = "";
        if (logDirs != null && logDirs.length != 0) {
            String string3 = string + logDirs[0];
            string3 = string3 + File.separator;
        } else {
            LOG.warn("DAGVizFile will be created under current (.) directory: {}, which is not expected and recommended", (Object)new File(".").getAbsolutePath());
        }
        String string4 = (String)var7_13 + dagId.toString();
        if (scheduler != null) {
            String string5 = string4 + "_priority";
        }
        String string6 = (String)var7_16 + ".dot";
        try {
            LOG.info("Generating DAG graphviz file, dagId=" + dagId.toString() + ", filePath=" + string6);
            graph.save(string6);
        }
        catch (Exception e) {
            LOG.warn("Error occurred when trying to save graph structure for dag " + dagId.toString(), (Throwable)e);
        }
    }

    private static String getShortClassName(String className) {
        int pos = className.lastIndexOf(".");
        if (pos != -1 && pos < className.length() - 1) {
            return className.substring(pos + 1);
        }
        return className;
    }

    private static String sanitizeLabelForViz(String label) {
        Matcher m = sanitizeLabelPattern.matcher(label);
        return m.replaceAll("_");
    }

    private static void sendEvent(AppContext appContext, Event<?> event) {
        appContext.getEventHandler().handle(event);
    }
}

