/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.dag.records.TezTaskID;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezTaskAttemptID
extends TezID {
    public static final String ATTEMPT = "attempt";
    private TezTaskID taskId;

    public TezTaskAttemptID() {
        this.taskId = new TezTaskID();
    }

    public TezTaskAttemptID(TezTaskID taskId, int id) {
        super(id);
        if (taskId == null) {
            throw new IllegalArgumentException("taskId cannot be null");
        }
        this.taskId = taskId;
    }

    public TezTaskID getTaskID() {
        return this.taskId;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezTaskAttemptID that = (TezTaskAttemptID)o;
        return this.taskId.equals(that.taskId);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.taskId.appendTo(builder).append('_').append(this.id);
    }

    public int hashCode() {
        return this.taskId.hashCode() * 539501 + this.id;
    }

    public int compareTo(TezID o) {
        TezTaskAttemptID that = (TezTaskAttemptID)o;
        int tipComp = this.taskId.compareTo(that.taskId);
        if (tipComp == 0) {
            return this.id - that.id;
        }
        return tipComp;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(ATTEMPT)).toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.taskId.readFields(in);
        super.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.taskId.write(out);
        super.write(out);
    }

    public static TezTaskAttemptID read(DataInput in) throws IOException {
        TezTaskAttemptID tId = new TezTaskAttemptID();
        tId.readFields(in);
        return tId;
    }
}

