/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.TaskFailureType;

@InterfaceAudience.Public
public interface TaskContext {
    public ApplicationId getApplicationId();

    public int getDAGAttemptNumber();

    public int getTaskIndex();

    public int getTaskAttemptNumber();

    public String getDAGName();

    public String getTaskVertexName();

    public int getTaskVertexIndex();

    public int getDagIdentifier();

    public TezCounters getCounters();

    public void sendEvents(List<Event> var1);

    public UserPayload getUserPayload();

    public String[] getWorkDirs();

    public String getUniqueIdentifier();

    public ObjectRegistry getObjectRegistry();

    public void notifyProgress();

    @Deprecated
    public void fatalError(@Nullable Throwable var1, @Nullable String var2);

    public void reportFailure(TaskFailureType var1, @Nullable Throwable var2, @Nullable String var3);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public void killSelf(@Nullable Throwable var1, @Nullable String var2);

    public ByteBuffer getServiceConsumerMetaData(String var1);

    @Nullable
    public ByteBuffer getServiceProviderMetaData(String var1);

    public void requestInitialMemory(long var1, MemoryUpdateCallback var3);

    public long getTotalMemoryAvailableToTask();

    public int getVertexParallelism();

    public ExecutionContext getExecutionContext();
}

