/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.log4j.Level;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezApiVersionInfo;
import org.apache.tez.common.JavaOptsChecker;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezYARNUtils;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.common.security.HistoryACLPolicyException;
import org.apache.tez.common.security.HistoryACLPolicyManager;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TezClientUtils {
    private static Logger LOG = LoggerFactory.getLogger(TezClientUtils.class);
    private static final int UTF8_CHUNK_SIZE = 16384;

    private static FileStatus[] getLRFileStatus(String fileName, Configuration conf) throws IOException {
        URI uri;
        try {
            uri = new URI(fileName);
        }
        catch (URISyntaxException e) {
            String message = "Invalid URI defined in configuration for location of TEZ jars. providedURI=" + fileName;
            LOG.error(message);
            throw new TezUncheckedException(message, e);
        }
        Path p = new Path(uri);
        FileSystem fs = p.getFileSystem(conf);
        p = fs.resolvePath(p.makeQualified(fs.getUri(), fs.getWorkingDirectory()));
        FileSystem targetFS = p.getFileSystem(conf);
        if (targetFS.isDirectory(p)) {
            return targetFS.listStatus(p);
        }
        FileStatus fStatus = targetFS.getFileStatus(p);
        return new FileStatus[]{fStatus};
    }

    static boolean setupTezJarsLocalResources(TezConfiguration conf, Credentials credentials, Map<String, LocalResource> tezJarResources) throws IOException {
        Preconditions.checkNotNull((Object)credentials, (Object)"A non-null credentials object should be specified");
        boolean usingTezArchive = false;
        if (conf.getBoolean("tez.ignore.lib.uris", false)) {
            LOG.info("Ignoring 'tez.lib.uris' since  'tez.ignore.lib.uris' is set to true");
        } else {
            Object[] tezJarUris = conf.getStrings("tez.lib.uris");
            if (tezJarUris == null || tezJarUris.length == 0) {
                throw new TezUncheckedException("Invalid configuration of tez jars, tez.lib.uris is not defined in the configuration");
            }
            LOG.info("Using tez.lib.uris value from configuration: " + conf.get("tez.lib.uris"));
            LOG.info("Using tez.lib.uris.classpath value from configuration: " + conf.get("tez.lib.uris.classpath"));
            usingTezArchive = TezClientUtils.addLocalResources(conf, (String[])tezJarUris, tezJarResources, credentials);
            if (tezJarResources.isEmpty()) {
                throw new TezUncheckedException("No files found in locations specified in tez.lib.uris . Locations: " + StringUtils.join((Object[])tezJarUris, (char)','));
            }
        }
        TezClientUtils.addLocalResources(conf, conf.getStrings("tez.aux.uris"), tezJarResources, credentials);
        return usingTezArchive;
    }

    private static boolean addLocalResources(Configuration conf, String[] configUris, Map<String, LocalResource> tezJarResources, Credentials credentials) throws IOException {
        boolean usingTezArchive = false;
        if (configUris == null || configUris.length == 0) {
            return usingTezArchive;
        }
        ArrayList configuredPaths = Lists.newArrayListWithCapacity((int)configUris.length);
        for (String configUri : configUris) {
            FileStatus[] fileStatuses;
            URI u = null;
            try {
                u = new URI(configUri);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to convert " + configUri + "to URI", e);
            }
            Path p = new Path(u);
            FileSystem remoteFS = p.getFileSystem(conf);
            p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
            LocalResourceType type = null;
            type = p.getName().endsWith(".tar.gz") || p.getName().endsWith(".tgz") || p.getName().endsWith(".zip") || p.getName().endsWith(".tar") ? LocalResourceType.ARCHIVE : LocalResourceType.FILE;
            for (FileStatus fStatus : fileStatuses = TezClientUtils.getLRFileStatus(configUri, conf)) {
                Path name;
                if (fStatus.isDirectory()) continue;
                if (type != LocalResourceType.ARCHIVE) {
                    u = fStatus.getPath().toUri();
                    p = new Path(u);
                    remoteFS = p.getFileSystem(conf);
                    p = remoteFS.resolvePath(p.makeQualified(remoteFS.getUri(), remoteFS.getWorkingDirectory()));
                    if (null != u.getFragment()) {
                        LOG.warn("Fragment set for link being interpreted as a file,URI: " + u.toString());
                    }
                }
                if ((name = new Path(null == u.getFragment() ? p.getName() : u.getFragment())).isAbsolute()) {
                    throw new IllegalArgumentException("Resource name must be relative, not absolute: " + name + " in URI: " + u.toString());
                }
                URL url = ConverterUtils.getYarnUrlFromURI((URI)p.toUri());
                String linkName = name.toUri().getPath();
                if (type == LocalResourceType.ARCHIVE && configUris.length == 1 && null == u.getFragment()) {
                    linkName = "tezlib";
                    usingTezArchive = true;
                }
                LocalResourceVisibility lrVisibility = TezClientUtils.checkAncestorPermissionsForAllUsers(conf, url.getFile(), FsAction.EXECUTE) && fStatus.getPermission().getOtherAction().implies(FsAction.READ) ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE;
                if (tezJarResources.containsKey(linkName)) {
                    String message = "Duplicate resource found, resourceName=" + linkName + ", existingPath=" + tezJarResources.get(linkName).getResource().toString() + ", newPath=" + fStatus.getPath();
                    LOG.warn(message);
                }
                tezJarResources.put(linkName, LocalResource.newInstance((URL)url, (LocalResourceType)type, (LocalResourceVisibility)lrVisibility, (long)fStatus.getLen(), (long)fStatus.getModificationTime()));
                configuredPaths.add(fStatus.getPath());
            }
        }
        if (!configuredPaths.isEmpty()) {
            TokenCache.obtainTokensForFileSystems(credentials, configuredPaths.toArray(new Path[configuredPaths.size()]), conf);
        }
        return usingTezArchive;
    }

    static void processTezLocalCredentialsFile(Credentials credentials, Configuration conf) throws IOException {
        String path = conf.get("tez.credentials.path");
        if (path == null) {
            return;
        }
        TokenCache.mergeBinaryTokens(credentials, conf, path);
    }

    public static FileSystem ensureStagingDirExists(Configuration conf, Path stagingArea) throws IOException {
        FileSystem fs = stagingArea.getFileSystem(conf);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        String realUser = ugi.getShortUserName();
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        if (fs.exists(stagingArea)) {
            FileStatus fsStatus = fs.getFileStatus(stagingArea);
            String owner = fsStatus.getOwner();
            if (!owner.equals(currentUser) && !owner.equals(realUser)) {
                throw new IOException("The ownership on the staging directory " + stagingArea + " is not as expected. " + "It is owned by " + owner + ". The directory must " + "be owned by the submitter " + currentUser + " or " + "by " + realUser);
            }
            if (!fsStatus.getPermission().equals((Object)TezCommonUtils.TEZ_AM_DIR_PERMISSION)) {
                LOG.info("Permissions on staging directory " + stagingArea + " are " + "incorrect: " + fsStatus.getPermission() + ". Fixing permissions " + "to correct value " + TezCommonUtils.TEZ_AM_DIR_PERMISSION);
                fs.setPermission(stagingArea, TezCommonUtils.TEZ_AM_DIR_PERMISSION);
            }
        } else {
            TezCommonUtils.mkDirForAM(fs, stagingArea);
        }
        return fs;
    }

    public static void addFileSystemCredentialsFromURIs(Collection<URI> uris, Credentials credentials, Configuration conf) throws IOException {
        if (uris != null && !uris.isEmpty()) {
            Iterator pathIter = Iterators.transform(uris.iterator(), (Function)new Function<URI, Path>(){

                public Path apply(URI input) {
                    return new Path(input);
                }
            });
            Path[] paths = (Path[])Iterators.toArray((Iterator)pathIter, Path.class);
            TokenCache.obtainTokensForFileSystems(credentials, paths, conf);
        }
    }

    @InterfaceAudience.Private
    static Credentials setupDAGCredentials(DAG dag, Credentials sessionCredentials, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)sessionCredentials);
        TezCommonUtils.logCredentials(LOG, sessionCredentials, "session");
        Credentials dagCredentials = new Credentials();
        dagCredentials.mergeAll(sessionCredentials);
        TezClientUtils.addFileSystemCredentialsFromURIs(dag.getURIsForCredentials(), dagCredentials, conf);
        try {
            HashSet<Path> lrPaths = new HashSet<Path>();
            for (Vertex v : dag.getVertices()) {
                for (LocalResource lr : v.getTaskLocalFiles().values()) {
                    lrPaths.add(ConverterUtils.getPathFromYarnURL((URL)lr.getResource()));
                }
                List<DataSourceDescriptor> dataSources = v.getDataSources();
                for (DataSourceDescriptor dataSource : dataSources) {
                    TezClientUtils.addFileSystemCredentialsFromURIs(dataSource.getURIsForCredentials(), dagCredentials, conf);
                }
                List<DataSinkDescriptor> dataSinks = v.getDataSinks();
                for (DataSinkDescriptor dataSink : dataSinks) {
                    TezClientUtils.addFileSystemCredentialsFromURIs(dataSink.getURIsForCredentials(), dagCredentials, conf);
                }
            }
            for (LocalResource lr : dag.getTaskLocalFiles().values()) {
                lrPaths.add(ConverterUtils.getPathFromYarnURL((URL)lr.getResource()));
            }
            Path[] paths = lrPaths.toArray(new Path[lrPaths.size()]);
            TokenCache.obtainTokensForFileSystems(dagCredentials, paths, conf);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return dagCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public static ApplicationSubmissionContext createApplicationSubmissionContext(ApplicationId appId, DAG dag, String amName, AMConfiguration amConfig, Map<String, LocalResource> tezJarResources, Credentials sessionCreds, boolean tezLrsAsArchive, TezApiVersionInfo apiVersionInfo, HistoryACLPolicyManager historyACLPolicyManager, ServicePluginsDescriptor servicePluginsDescriptor, JavaOptsChecker javaOptsChecker) throws IOException, YarnException {
        Preconditions.checkNotNull((Object)sessionCreds);
        TezConfiguration conf = amConfig.getTezConfiguration();
        FileSystem fs = TezClientUtils.ensureStagingDirExists(conf, TezCommonUtils.getTezBaseStagingPath(conf));
        String strAppId = appId.toString();
        Path tezSysStagingPath = TezCommonUtils.createTezSystemStagingPath(conf, strAppId);
        Path binaryConfPath = TezCommonUtils.getTezConfStagingPath(tezSysStagingPath);
        binaryConfPath = fs.makeQualified(binaryConfPath);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(amConfig.getTezConfiguration().getInt("tez.am.resource.memory.mb", 1024));
        capability.setVirtualCores(amConfig.getTezConfiguration().getInt("tez.am.resource.cpu.vcores", 1));
        if (LOG.isDebugEnabled()) {
            LOG.debug("AppMaster capability = " + capability);
        }
        ByteBuffer securityTokens = null;
        Credentials amLaunchCredentials = new Credentials();
        if (amConfig.getCredentials() != null) {
            amLaunchCredentials.addAll(amConfig.getCredentials());
        }
        TokenCache.obtainTokensForFileSystems(sessionCreds, new Path[]{binaryConfPath}, conf);
        amLaunchCredentials.mergeAll(sessionCreds);
        DataOutputBuffer dob = new DataOutputBuffer();
        amLaunchCredentials.writeTokenStorageToStream((DataOutputStream)dob);
        securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        ArrayList<String> vargs = new ArrayList<String>(8);
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
        String amOpts = TezClientUtils.constructAMLaunchOpts(amConfig.getTezConfiguration(), capability);
        vargs.add(amOpts);
        String amLogLevelString = amConfig.getTezConfiguration().get("tez.am.log.level", "INFO");
        String[] amLogParams = TezClientUtils.parseLogParams(amLogLevelString);
        String amLogLevel = amLogParams[0];
        TezClientUtils.maybeAddDefaultLoggingJavaOpts(amLogLevel, vargs);
        vargs.add("-Dsun.nio.ch.bugLevel=''");
        vargs.add("org.apache.tez.dag.app.DAGAppMaster");
        if (dag == null) {
            vargs.add("--session");
        }
        vargs.add("1><LOG_DIR>" + File.separator + "stdout");
        vargs.add("2><LOG_DIR>" + File.separator + "stderr");
        Vector<String> vargsFinal = new Vector<String>(8);
        StringBuilder mergedCommand = new StringBuilder();
        for (CharSequence charSequence : vargs) {
            mergedCommand.append(charSequence).append(" ");
        }
        vargsFinal.add(mergedCommand.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Command to launch container for ApplicationMaster is : " + mergedCommand);
        }
        TreeMap<String, String> environment = new TreeMap<String, String>();
        TezYARNUtils.setupDefaultEnv(environment, conf, "tez.am.launch.env", "", "tez.am.launch.cluster-default.env", TezConfiguration.TEZ_AM_LAUNCH_CLUSTER_DEFAULT_ENV_DEFAULT, tezLrsAsArchive);
        TezClientUtils.addVersionInfoToEnv(environment, apiVersionInfo);
        TezClientUtils.addLogParamsToEnv(environment, amLogParams);
        TreeMap<String, LocalResource> treeMap = new TreeMap<String, LocalResource>();
        if (amConfig.getAMLocalResources() != null) {
            treeMap.putAll(amConfig.getAMLocalResources());
        }
        treeMap.putAll(tezJarResources);
        Map<String, String> aclConfigs = null;
        if (historyACLPolicyManager != null) {
            if (dag == null) {
                try {
                    aclConfigs = historyACLPolicyManager.setupSessionACLs(amConfig.getTezConfiguration(), appId);
                }
                catch (HistoryACLPolicyException e) {
                    LOG.warn("Disabling history logging for session " + strAppId + " due to error in setting up history acls " + e);
                    amConfig.getTezConfiguration().setBoolean("tez.am.history.logging.enabled", false);
                }
            } else {
                try {
                    aclConfigs = historyACLPolicyManager.setupNonSessionACLs(amConfig.getTezConfiguration(), appId, dag.getDagAccessControls());
                }
                catch (HistoryACLPolicyException e) {
                    LOG.warn("Disabling history logging for dag " + dag.getName() + " due to error in setting up history acls " + e);
                    dag.setConf("tez.dag.history.logging.enabled", "false");
                    amConfig.getTezConfiguration().setBoolean("tez.am.history.logging.enabled", false);
                }
            }
        }
        DAGProtos.ConfigurationProto finalConfProto = TezClientUtils.createFinalConfProtoForApp(amConfig.getTezConfiguration(), aclConfigs, servicePluginsDescriptor);
        try (FSDataOutputStream amConfPBOutBinaryStream = null;){
            amConfPBOutBinaryStream = TezCommonUtils.createFileForAM(fs, binaryConfPath);
            finalConfProto.writeTo((OutputStream)amConfPBOutBinaryStream);
        }
        LocalResource binaryConfLRsrc = TezClientUtils.createLocalResource(fs, binaryConfPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION);
        amConfig.setBinaryConfLR(binaryConfLRsrc);
        treeMap.put("tez-conf.pb", binaryConfLRsrc);
        Path sessionJarsPath = TezCommonUtils.getTezAMJarStagingPath(tezSysStagingPath);
        try (FSDataOutputStream sessionJarsPBOutStream = null;){
            sessionJarsPBOutStream = TezCommonUtils.createFileForAM(fs, sessionJarsPath);
            DAGProtos.PlanLocalResourcesProto amResourceProto = treeMap != null && !treeMap.isEmpty() ? DagTypeConverters.convertFromLocalResources(treeMap) : DAGProtos.PlanLocalResourcesProto.getDefaultInstance();
            amResourceProto.writeDelimitedTo((OutputStream)sessionJarsPBOutStream);
        }
        LocalResource sessionJarsPBLRsrc = TezClientUtils.createLocalResource(fs, sessionJarsPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION);
        treeMap.put("tez.session.local-resources.pb", sessionJarsPBLRsrc);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        ACLManager aclManager = new ACLManager(user, amConfig.getTezConfiguration());
        Map<ApplicationAccessType, String> acls = aclManager.toYARNACls();
        if (dag != null) {
            DAGProtos.DAGPlan dagPB = TezClientUtils.prepareAndCreateDAGPlan(dag, amConfig, tezJarResources, tezLrsAsArchive, sessionCreds, servicePluginsDescriptor, javaOptsChecker);
            Path binaryPath = TezCommonUtils.getTezBinPlanStagingPath(tezSysStagingPath);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stage directory information for AppId :" + appId + " tezSysStagingPath :" + tezSysStagingPath + " binaryConfPath :" + binaryConfPath + " sessionJarsPath :" + sessionJarsPath + " binaryPlanPath :" + binaryPath);
            }
            try (FSDataOutputStream dagPBOutBinaryStream = null;){
                dagPBOutBinaryStream = TezCommonUtils.createFileForAM(fs, binaryPath);
                dagPB.writeTo((OutputStream)dagPBOutBinaryStream);
            }
            treeMap.put("tez-dag.pb", TezClientUtils.createLocalResource(fs, binaryPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION));
            if (Level.DEBUG.isGreaterOrEqual((org.apache.log4j.Priority)Level.toLevel((String)amLogLevel))) {
                Path textPath = TezClientUtils.localizeDagPlanAsText(dagPB, fs, amConfig, strAppId, tezSysStagingPath);
                treeMap.put("tez-dag.pb.txt", TezClientUtils.createLocalResource(fs, textPath, LocalResourceType.FILE, LocalResourceVisibility.APPLICATION));
            }
        }
        HashMap<String, ByteBuffer> serviceData = new HashMap<String, ByteBuffer>();
        serviceData.put("mapreduce_shuffle", TezCommonUtils.serializeServiceData(TokenCache.getSessionToken(amLaunchCredentials)));
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(treeMap, environment, vargsFinal, serviceData, (ByteBuffer)securityTokens, acls);
        ApplicationSubmissionContext appContext = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        Collection tagsFromConf = amConfig.getTezConfiguration().getTrimmedStringCollection("tez.application.tags");
        appContext.setApplicationType("TEZ");
        if (tagsFromConf != null && !tagsFromConf.isEmpty()) {
            appContext.setApplicationTags(new HashSet(tagsFromConf));
        }
        appContext.setApplicationId(appId);
        appContext.setResource(capability);
        if (amConfig.getQueueName() != null) {
            appContext.setQueue(amConfig.getQueueName());
        }
        TezClientUtils.setApplicationPriority(appContext, amConfig);
        appContext.setApplicationName(amName);
        appContext.setCancelTokensWhenComplete(amConfig.getTezConfiguration().getBoolean("tez.cancel.delegation.tokens.on.completion", true));
        appContext.setAMContainerSpec(amContainer);
        appContext.setMaxAppAttempts(amConfig.getTezConfiguration().getInt("tez.am.max.app.attempts", 2));
        return appContext;
    }

    static DAGProtos.DAGPlan prepareAndCreateDAGPlan(DAG dag, AMConfiguration amConfig, Map<String, LocalResource> tezJarResources, boolean tezLrsAsArchive, Credentials credentials, ServicePluginsDescriptor servicePluginsDescriptor, JavaOptsChecker javaOptsChecker) throws IOException {
        return TezClientUtils.prepareAndCreateDAGPlan(dag, amConfig, tezJarResources, tezLrsAsArchive, credentials, null, servicePluginsDescriptor, javaOptsChecker);
    }

    static DAGProtos.DAGPlan prepareAndCreateDAGPlan(DAG dag, AMConfiguration amConfig, Map<String, LocalResource> tezJarResources, boolean tezLrsAsArchive, Credentials credentials, Map<String, String> additionalDAGConfigs, ServicePluginsDescriptor servicePluginsDescriptor, JavaOptsChecker javaOptsChecker) throws IOException {
        Credentials dagCredentials = TezClientUtils.setupDAGCredentials(dag, credentials, amConfig.getTezConfiguration());
        return dag.createDag(amConfig.getTezConfiguration(), dagCredentials, tezJarResources, amConfig.getBinaryConfLR(), tezLrsAsArchive, additionalDAGConfigs, servicePluginsDescriptor, javaOptsChecker);
    }

    static void maybeAddDefaultLoggingJavaOpts(String logLevel, List<String> vargs) {
        Preconditions.checkNotNull(vargs);
        if (!vargs.isEmpty()) {
            for (String arg : vargs) {
                if (!arg.contains("tez.root.logger")) continue;
                return;
            }
        }
        TezClientUtils.addLog4jSystemProperties(logLevel, vargs);
    }

    @InterfaceAudience.Private
    public static String maybeAddDefaultLoggingJavaOpts(String logLevel, String javaOpts) {
        ArrayList<String> vargs = new ArrayList<String>(5);
        if (javaOpts != null) {
            vargs.add(javaOpts);
        } else {
            vargs.add("");
        }
        TezClientUtils.maybeAddDefaultLoggingJavaOpts(logLevel, vargs);
        if (vargs.size() == 1) {
            return (String)vargs.get(0);
        }
        return StringUtils.join(vargs, (String)" ").trim();
    }

    @InterfaceAudience.Private
    public static String addDefaultsToTaskLaunchCmdOpts(String vOpts, Configuration conf) throws TezException {
        return TezClientUtils.addDefaultsToTaskLaunchCmdOpts(vOpts, conf, null);
    }

    @InterfaceAudience.Private
    public static String addDefaultsToTaskLaunchCmdOpts(String vOpts, Configuration conf, JavaOptsChecker javaOptsChecker) throws TezException {
        String vConfigOpts = "";
        String taskDefaultOpts = conf.get("tez.task.launch.cluster-default.cmd-opts", "-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN");
        if (taskDefaultOpts != null && !taskDefaultOpts.isEmpty()) {
            vConfigOpts = taskDefaultOpts + " ";
        }
        String defaultTaskCmdOpts = "-XX:+PrintGCDetails -verbose:gc -XX:+PrintGCTimeStamps -XX:+UseNUMA -XX:+UseParallelGC";
        if (vOpts != null && !vOpts.isEmpty()) {
            defaultTaskCmdOpts = "";
        }
        if ((vConfigOpts = vConfigOpts + conf.get("tez.task.launch.cmd-opts", defaultTaskCmdOpts)) != null && !vConfigOpts.isEmpty()) {
            vOpts = vConfigOpts + " " + vOpts;
        }
        if (javaOptsChecker != null) {
            javaOptsChecker.checkOpts(vOpts);
        }
        return vOpts;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void addLog4jSystemProperties(String logLevel, List<String> vargs) {
        vargs.add("-Dlog4j.configuratorClass=org.apache.tez.common.TezLog4jConfigurator");
        vargs.add("-Dlog4j.configuration=tez-container-log4j.properties");
        vargs.add("-Dyarn.app.container.log.dir=<LOG_DIR>");
        vargs.add("-Dtez.root.logger=" + logLevel + "," + "CLA");
    }

    static DAGProtos.ConfigurationProto createFinalConfProtoForApp(Configuration amConf, Map<String, String> additionalConfigs, ServicePluginsDescriptor servicePluginsDescriptor) {
        DAGProtos.PlanKeyValuePair.Builder kvp;
        assert (amConf != null);
        DAGProtos.ConfigurationProto.Builder builder = DAGProtos.ConfigurationProto.newBuilder();
        for (Map.Entry<String, String> entry : amConf) {
            kvp = DAGProtos.PlanKeyValuePair.newBuilder();
            kvp.setKey((String)entry.getKey());
            kvp.setValue(amConf.get((String)entry.getKey()));
            builder.addConfKeyValues(kvp);
        }
        if (additionalConfigs != null && !additionalConfigs.isEmpty()) {
            for (Map.Entry<String, String> entry : additionalConfigs.entrySet()) {
                kvp = DAGProtos.PlanKeyValuePair.newBuilder();
                kvp.setKey(entry.getKey());
                kvp.setValue(entry.getValue());
                builder.addConfKeyValues(kvp);
            }
        }
        DAGProtos.AMPluginDescriptorProto pluginDescriptorProto = DagTypeConverters.convertServicePluginDescriptorToProto(servicePluginsDescriptor);
        builder.setAmPluginDescriptor(pluginDescriptorProto);
        return builder.build();
    }

    static LocalResource createLocalResource(FileSystem fs, Path p, LocalResourceType type, LocalResourceVisibility visibility) throws IOException {
        LocalResource rsrc = (LocalResource)Records.newRecord(LocalResource.class);
        FileStatus rsrcStat = fs.getFileStatus(p);
        rsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)fs.resolvePath(rsrcStat.getPath())));
        rsrc.setSize(rsrcStat.getLen());
        rsrc.setTimestamp(rsrcStat.getModificationTime());
        rsrc.setType(type);
        rsrc.setVisibility(visibility);
        return rsrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path localizeDagPlanAsText(DAGProtos.DAGPlan dagPB, FileSystem fs, AMConfiguration amConfig, String strAppId, Path tezSysStagingPath) throws IOException {
        Path textPath = TezCommonUtils.getTezTextPlanStagingPath(tezSysStagingPath, strAppId, dagPB.getName());
        try (FSDataOutputStream dagPBOutTextStream = null;){
            dagPBOutTextStream = TezCommonUtils.createFileForAM(fs, textPath);
            String dagPBStr = dagPB.toString();
            int dagPBStrLen = dagPBStr.length();
            if (dagPBStrLen <= 16384) {
                dagPBOutTextStream.writeUTF(dagPBStr);
            } else {
                for (int startIndex = 0; startIndex < dagPBStrLen; startIndex += 16384) {
                    int endIndex = startIndex + 16384;
                    if (endIndex > dagPBStrLen) {
                        endIndex = dagPBStrLen;
                    }
                    dagPBOutTextStream.writeUTF(dagPBStr.substring(startIndex, endIndex));
                }
            }
        }
        return textPath;
    }

    static DAGClientAMProtocolBlockingPB getAMProxy(FrameworkClient yarnClient, Configuration conf, ApplicationId applicationId) throws TezException, IOException {
        ApplicationReport appReport;
        try {
            appReport = yarnClient.getApplicationReport(applicationId);
            if (appReport == null) {
                throw new TezUncheckedException("Could not retrieve application report from YARN, applicationId=" + applicationId);
            }
            YarnApplicationState appState = appReport.getYarnApplicationState();
            if (appState != YarnApplicationState.RUNNING) {
                if (appState == YarnApplicationState.FINISHED || appState == YarnApplicationState.KILLED || appState == YarnApplicationState.FAILED) {
                    String msg = "Application not running, applicationId=" + applicationId + ", yarnApplicationState=" + appReport.getYarnApplicationState() + ", finalApplicationStatus=" + appReport.getFinalApplicationStatus() + ", trackingUrl=" + appReport.getTrackingUrl() + ", diagnostics=" + (appReport.getDiagnostics() != null ? appReport.getDiagnostics() : "No cluster diagnostics found.");
                    LOG.info(msg);
                    throw new SessionNotRunning(msg);
                }
                return null;
            }
        }
        catch (ApplicationNotFoundException e) {
            throw new SessionNotRunning(e);
        }
        catch (YarnException e) {
            throw new TezException(e);
        }
        return TezClientUtils.getAMProxy(conf, appReport.getHost(), appReport.getRpcPort(), appReport.getClientToAMToken());
    }

    @InterfaceAudience.Private
    public static DAGClientAMProtocolBlockingPB getAMProxy(final Configuration conf, String amHost, int amRpcPort, org.apache.hadoop.yarn.api.records.Token clientToAMToken) throws IOException {
        final InetSocketAddress serviceAddr = NetUtils.createSocketAddrForHost((String)amHost, (int)amRpcPort);
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)UserGroupInformation.getCurrentUser().getUserName());
        if (clientToAMToken != null) {
            Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)clientToAMToken, (InetSocketAddress)serviceAddr);
            userUgi.addToken(token);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting to Tez AM at " + serviceAddr);
        }
        DAGClientAMProtocolBlockingPB proxy = null;
        try {
            proxy = (DAGClientAMProtocolBlockingPB)userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DAGClientAMProtocolBlockingPB>(){

                @Override
                public DAGClientAMProtocolBlockingPB run() throws IOException {
                    RPC.setProtocolEngine((Configuration)conf, DAGClientAMProtocolBlockingPB.class, ProtobufRpcEngine.class);
                    return (DAGClientAMProtocolBlockingPB)RPC.getProxy(DAGClientAMProtocolBlockingPB.class, (long)0L, (InetSocketAddress)serviceAddr, (Configuration)conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to connect to AM", e);
        }
        return proxy;
    }

    static void createSessionToken(String tokenIdentifier, JobTokenSecretManager jobTokenSecretManager, Credentials credentials) {
        JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(tokenIdentifier));
        Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)jobTokenSecretManager);
        sessionToken.setService(identifier.getJobId());
        TokenCache.setSessionToken((Token<? extends TokenIdentifier>)sessionToken, credentials);
    }

    @InterfaceAudience.Private
    public static String maybeAddDefaultMemoryJavaOpts(String javaOpts, Resource resource, double maxHeapFactor) {
        if (javaOpts != null && !javaOpts.isEmpty() && (javaOpts.contains("-Xmx") || javaOpts.contains("-Xms")) || resource.getMemory() <= 0) {
            return javaOpts;
        }
        if (maxHeapFactor <= 0.0 || maxHeapFactor >= 1.0) {
            return javaOpts;
        }
        int maxMemory = (int)((double)resource.getMemory() * maxHeapFactor);
        maxMemory = maxMemory <= 0 ? 1 : maxMemory;
        return " -Xmx" + maxMemory + "m " + (javaOpts != null ? javaOpts : "");
    }

    private static boolean checkAncestorPermissionsForAllUsers(Configuration conf, String uri, FsAction permission) throws IOException {
        Path pathComponent = new Path(uri);
        FileSystem fs = pathComponent.getFileSystem(conf);
        if (Shell.WINDOWS && fs instanceof LocalFileSystem) {
            return true;
        }
        if (fs.getFileStatus(pathComponent).isFile()) {
            pathComponent = pathComponent.getParent();
        }
        while (pathComponent != null) {
            if (!fs.getFileStatus(pathComponent).getPermission().getOtherAction().implies(permission)) {
                return false;
            }
            pathComponent = pathComponent.getParent();
        }
        return true;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static String constructAMLaunchOpts(TezConfiguration tezConf, Resource capability) {
        String defaultOpts = tezConf.get("tez.am.launch.cluster-default.cmd-opts", "-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN");
        Path tmpDir = new Path(ApplicationConstants.Environment.PWD.$(), "./tmp");
        String amOpts = "-Djava.io.tmpdir=" + tmpDir + " ";
        if (defaultOpts != null && !defaultOpts.isEmpty()) {
            amOpts = amOpts + defaultOpts + " ";
        }
        amOpts = amOpts + tezConf.get("tez.am.launch.cmd-opts", "-XX:+PrintGCDetails -verbose:gc -XX:+PrintGCTimeStamps -XX:+UseNUMA -XX:+UseParallelGC");
        amOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts(amOpts, capability, tezConf.getDouble("tez.container.max.java.heap.fraction", 0.8));
        return amOpts;
    }

    private static void addVersionInfoToEnv(Map<String, String> environment, TezApiVersionInfo versionInfo) {
        if (!versionInfo.getVersion().equals("Unknown")) {
            TezYARNUtils.replaceInEnv(environment, "TEZ_CLIENT_VERSION", versionInfo.getVersion());
        }
    }

    @InterfaceAudience.Private
    public static void addLogParamsToEnv(Map<String, String> environment, String[] logParams) {
        if (logParams.length == 2 && !Strings.isNullOrEmpty((String)logParams[1])) {
            TezYARNUtils.replaceInEnv(environment, "TEZ_CONTAINER_LOG_PARAMS", logParams[1]);
        }
    }

    @InterfaceAudience.Private
    public static String[] parseLogParams(String logConfig) {
        if (!Strings.isNullOrEmpty((String)logConfig)) {
            int separatorIndex = logConfig.indexOf(";");
            if (separatorIndex == -1) {
                return new String[]{logConfig.trim()};
            }
            return new String[]{logConfig.substring(0, separatorIndex), logConfig.substring(separatorIndex + 1, logConfig.length()).trim()};
        }
        return null;
    }

    @VisibleForTesting
    public static void setApplicationPriority(ApplicationSubmissionContext context, AMConfiguration amConfig) {
        if (amConfig.getTezConfiguration().get("tez.am.application.priority") != null) {
            int priority = amConfig.getTezConfiguration().getInt("tez.am.application.priority", 0);
            context.setPriority(Priority.newInstance((int)priority));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Settting TEZ application priority, applicationId= " + context.getApplicationId() + ", priority= " + context.getPriority().getPriority());
            }
        }
    }
}

